/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.utils;

import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.controller.touchpad.TouchpadState;
import java.util.List;
import java.util.function.Function;
import java.util.stream.IntStream;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_148;
import net.minecraft.class_3532;
import org.joml.Vector2f;
import org.joml.Vector2fc;

public class ControllerUtils {
    public static String createControllerString(ControllerEntity controller) {
        return String.format("'%s'#%s-%s (%s)", controller.name(), controller.info().ucid().toString(), controller.info().hid().map(hid -> hid.asIdentifier().toString()).orElse("hid"), controller.info().type().friendlyName());
    }

    public static void wrapControllerError(Runnable runnable, String errorTitle, ControllerEntity controller) {
        try {
            runnable.run();
        }
        catch (Throwable e) {
            class_128 crashReport = class_128.method_560((Throwable)e, (String)errorTitle);
            class_129 category = crashReport.method_562("Affected controller");
            category.method_578("Controller name", (Object)controller.name());
            category.method_578("Controller identification", (Object)controller.info().type().friendlyName());
            category.method_578("Controller type", (Object)controller.getClass().getCanonicalName());
            throw new class_148(crashReport);
        }
    }

    public static float deadzone(float value, float deadzone) {
        return (value - Math.copySign(Math.min(deadzone, Math.abs(value)), value)) / (1.0f - deadzone);
    }

    public static float applyCircularityX(float x, float y) {
        return (float)((double)x * Math.sqrt(1.0f - y * y / 2.0f));
    }

    public static float applyCircularityY(float x, float y) {
        return (float)((double)y * Math.sqrt(1.0f - x * x / 2.0f));
    }

    public static Vector2f applyEasingToLength(float x, float y, Function<Float, Float> easing) {
        float length = class_3532.method_15355((float)(x * x + y * y));
        float easedLength = easing.apply(Float.valueOf(length)).floatValue();
        float angle = (float)class_3532.method_15349((double)y, (double)x);
        return new Vector2f(class_3532.method_15362((float)angle) * easedLength, class_3532.method_15374((float)angle) * easedLength);
    }

    public static boolean shouldApplyAntiSnapBack(float x, float y, float px, float py, float threshold) {
        boolean hasCrossedOrigin;
        float dx = x - px;
        float dy = y - py;
        float distanceSquared = dx * dx + dy * dy;
        boolean isSnap = distanceSquared >= threshold * threshold;
        boolean bl = hasCrossedOrigin = Math.signum(x) != Math.signum(px) && Math.signum(y) != Math.signum(py);
        if (isSnap && hasCrossedOrigin) {
            float t = (-x * (px - x) + -y * (py - y)) / distanceSquared;
            double distanceToMiddle = Math.sqrt(Math.pow(-(t = class_3532.method_15363((float)t, (float)0.0f, (float)1.0f)) * x + t * px, 2.0) + Math.pow(-t * y + t * py, 2.0));
            return distanceToMiddle <= 0.01;
        }
        return false;
    }

    public static List<TouchpadState.Finger> deltaFingers(List<TouchpadState.Finger> now, List<TouchpadState.Finger> then) {
        if (now.size() != then.size()) {
            return List.of();
        }
        return IntStream.range(0, now.size()).mapToObj(i -> new TouchpadState.Finger((Vector2fc)new Vector2f(((TouchpadState.Finger)now.get(i)).position().x() - ((TouchpadState.Finger)then.get(i)).position().x(), ((TouchpadState.Finger)now.get(i)).position().y() - ((TouchpadState.Finger)then.get(i)).position().y()), ((TouchpadState.Finger)now.get(i)).pressure() - ((TouchpadState.Finger)then.get(i)).pressure())).toList();
    }
}

