/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.screenop.compat.vanilla;

import dev.isxander.controlify.InputMode;
import dev.isxander.controlify.api.ControlifyApi;
import dev.isxander.controlify.bindings.ControlifyBindings;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.controller.dualsense.HapticEffects;
import dev.isxander.controlify.gui.guide.ContainerGuideCtx;
import dev.isxander.controlify.gui.guide.GuideAction;
import dev.isxander.controlify.gui.guide.GuideActionRenderer;
import dev.isxander.controlify.gui.layout.AnchorPoint;
import dev.isxander.controlify.gui.layout.ColumnLayoutComponent;
import dev.isxander.controlify.gui.layout.PositionedComponent;
import dev.isxander.controlify.gui.layout.RowLayoutComponent;
import dev.isxander.controlify.mixins.feature.guide.screen.AbstractContainerScreenAccessor;
import dev.isxander.controlify.mixins.feature.screenop.ScreenAccessor;
import dev.isxander.controlify.screenop.ScreenProcessor;
import dev.isxander.controlify.virtualmouse.VirtualMouseBehaviour;
import dev.isxander.controlify.virtualmouse.VirtualMouseHandler;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_2561;
import net.minecraft.class_4068;
import net.minecraft.class_465;

public class AbstractContainerScreenProcessor<T extends class_465<?>>
extends ScreenProcessor<T> {
    private PositionedComponent<ColumnLayoutComponent<RowLayoutComponent<GuideActionRenderer<ContainerGuideCtx>>>> leftLayout;
    private PositionedComponent<ColumnLayoutComponent<RowLayoutComponent<GuideActionRenderer<ContainerGuideCtx>>>> rightLayout;
    private final Supplier<class_1735> hoveredSlot;
    private final ClickSlotFunction clickSlotFunction;

    public AbstractContainerScreenProcessor(T screen, Supplier<class_1735> hoveredSlot, ClickSlotFunction clickSlotFunction) {
        super(screen);
        this.hoveredSlot = hoveredSlot;
        this.clickSlotFunction = clickSlotFunction;
    }

    @Override
    protected void handleScreenVMouse(ControllerEntity controller, VirtualMouseHandler vmouse) {
        AbstractContainerScreenAccessor accessor = (AbstractContainerScreenAccessor)this.screen;
        ContainerGuideCtx ctx = new ContainerGuideCtx(this.hoveredSlot.get(), ((class_465)this.screen).method_17577().method_34255(), accessor.invokeMethod_2381(vmouse.getCurrentX(1.0f), vmouse.getCurrentY(1.0f), accessor.getField_2776(), accessor.getField_2800(), 0));
        class_1735 hoveredSlot = this.hoveredSlot.get();
        if (!((class_465)this.screen).method_17577().method_34255().method_7960() && ControlifyBindings.DROP_INVENTORY.on(controller).justPressed()) {
            this.clickSlotFunction.clickSlot(null, -999, 0, class_1713.field_7790);
            this.hapticNavigate();
        }
        if (hoveredSlot != null) {
            if (ControlifyBindings.INV_SELECT.on(controller).justPressed()) {
                this.clickSlotFunction.clickSlot(hoveredSlot, hoveredSlot.field_7874, 0, class_1713.field_7790);
                this.hapticNavigate();
            }
            if (ControlifyBindings.INV_QUICK_MOVE.on(controller).justPressed()) {
                this.clickSlotFunction.clickSlot(hoveredSlot, hoveredSlot.field_7874, 0, class_1713.field_7794);
                this.hapticNavigate();
            }
            if (ControlifyBindings.INV_TAKE_HALF.on(controller).justPressed()) {
                this.clickSlotFunction.clickSlot(hoveredSlot, hoveredSlot.field_7874, 1, class_1713.field_7790);
                this.hapticNavigate();
            }
        } else {
            vmouse.handleCompatibilityBinds(controller);
        }
        if (this.leftLayout != null && this.rightLayout != null) {
            for (RowLayoutComponent row : this.leftLayout.getComponent().getChildComponents()) {
                for (GuideActionRenderer element : row.getChildComponents()) {
                    element.updateName(ctx);
                }
            }
            for (RowLayoutComponent row : this.rightLayout.getComponent().getChildComponents()) {
                for (GuideActionRenderer element : row.getChildComponents()) {
                    element.updateName(ctx);
                }
            }
            this.leftLayout.updatePosition(((class_465)this.screen).field_22789, ((class_465)this.screen).field_22790);
            this.rightLayout.updatePosition(((class_465)this.screen).field_22789, ((class_465)this.screen).field_22790);
        }
    }

    @Override
    public void onWidgetRebuild() {
        ControllerEntity controller = ControlifyApi.get().getCurrentController().filter(c -> c.input().isPresent()).orElse(null);
        if (controller == null) {
            return;
        }
        this.leftLayout = new PositionedComponent<ColumnLayoutComponent<RowLayoutComponent<GuideActionRenderer<ContainerGuideCtx>>>>(ColumnLayoutComponent.builder().spacing(2).elementPosition(ColumnLayoutComponent.ElementPosition.LEFT).colPadding(2).element(RowLayoutComponent.builder().spacing(5).rowPadding(0).elementPosition(RowLayoutComponent.ElementPosition.MIDDLE).element(new GuideActionRenderer<ContainerGuideCtx>(new GuideAction<ContainerGuideCtx>(ControlifyBindings.INV_SELECT.on(controller), ctx -> {
            if (!ctx.holdingItem().method_7960()) {
                if (ctx.hoveredSlot() != null && ctx.hoveredSlot().method_7681()) {
                    if (ctx.hoveredSlot().method_7680(ctx.holdingItem())) {
                        if (ctx.holdingItem().method_7947() > 1) {
                            return Optional.of(class_2561.method_43471((String)"controlify.guide.container.place_all"));
                        }
                        return Optional.of(class_2561.method_43471((String)"controlify.guide.container.place_one"));
                    }
                    return Optional.of(class_2561.method_43471((String)"controlify.guide.container.swap"));
                }
                if (ctx.cursorOutsideContainer()) {
                    return Optional.of(class_2561.method_43471((String)"controlify.guide.container.drop"));
                }
            }
            if (ctx.hoveredSlot() != null && ctx.hoveredSlot().method_7681()) {
                return Optional.of(class_2561.method_43471((String)"controlify.guide.container.take"));
            }
            return Optional.empty();
        }), false, false)).element(new GuideActionRenderer<ContainerGuideCtx>(new GuideAction<ContainerGuideCtx>(ControlifyBindings.GUI_BACK.on(controller), ctx -> Optional.of(class_2561.method_43471((String)"controlify.guide.container.exit"))), false, false)).build()).build(), AnchorPoint.BOTTOM_LEFT, 0, 0, AnchorPoint.BOTTOM_LEFT);
        this.rightLayout = new PositionedComponent<ColumnLayoutComponent<RowLayoutComponent<GuideActionRenderer<ContainerGuideCtx>>>>(ColumnLayoutComponent.builder().spacing(2).elementPosition(ColumnLayoutComponent.ElementPosition.RIGHT).colPadding(2).element(RowLayoutComponent.builder().spacing(5).rowPadding(0).elementPosition(RowLayoutComponent.ElementPosition.MIDDLE).element(new GuideActionRenderer<ContainerGuideCtx>(new GuideAction<ContainerGuideCtx>(ControlifyBindings.DROP_INVENTORY.on(controller), ctx -> {
            if (!ctx.holdingItem().method_7960()) {
                return Optional.of(class_2561.method_43471((String)"controlify.guide.container.drop"));
            }
            return Optional.empty();
        }), true, false)).build()).element(RowLayoutComponent.builder().spacing(5).rowPadding(0).elementPosition(RowLayoutComponent.ElementPosition.MIDDLE).element(new GuideActionRenderer<ContainerGuideCtx>(new GuideAction<ContainerGuideCtx>(ControlifyBindings.INV_TAKE_HALF.on(controller), ctx -> {
            if (ctx.hoveredSlot() != null && ctx.hoveredSlot().method_7677().method_7947() > 1 && ctx.holdingItem().method_7960()) {
                return Optional.of(class_2561.method_43471((String)"controlify.guide.container.take_half"));
            }
            if (ctx.hoveredSlot() != null && !ctx.holdingItem().method_7960() && ctx.hoveredSlot().method_7680(ctx.holdingItem())) {
                return Optional.of(class_2561.method_43471((String)"controlify.guide.container.take_one"));
            }
            return Optional.empty();
        }), true, false)).element(new GuideActionRenderer<ContainerGuideCtx>(new GuideAction<ContainerGuideCtx>(ControlifyBindings.INV_QUICK_MOVE.on(controller), ctx -> {
            if (ctx.hoveredSlot() != null && ctx.hoveredSlot().method_7681() && ctx.holdingItem().method_7960()) {
                return Optional.of(class_2561.method_43471((String)"controlify.guide.container.quick_move"));
            }
            return Optional.empty();
        }), true, false)).build()).build(), AnchorPoint.BOTTOM_RIGHT, 0, 0, AnchorPoint.BOTTOM_RIGHT);
        if (ControlifyApi.get().currentInputMode().isController()) {
            this.setRenderGuide(true);
        }
    }

    @Override
    public void onInputModeChanged(InputMode mode) {
        this.setRenderGuide(mode.isController());
    }

    private void setRenderGuide(boolean render) {
        render &= ControlifyApi.get().getCurrentController().map(c -> c.genericConfig().config().showScreenGuides).orElse(false).booleanValue();
        List<class_4068> renderables = ((ScreenAccessor)this.screen).getField_33816();
        if (this.leftLayout == null || this.rightLayout == null) {
            return;
        }
        if (render) {
            if (!renderables.contains(this.leftLayout)) {
                renderables.add(this.leftLayout);
            }
            if (!renderables.contains(this.rightLayout)) {
                renderables.add(this.rightLayout);
            }
        } else {
            renderables.remove(this.leftLayout);
            renderables.remove(this.rightLayout);
        }
    }

    public void onHoveredSlotChanged(class_1735 newSlot, class_1735 oldSlot) {
        if (ControlifyApi.get().currentInputMode().isController()) {
            this.hapticNavigate();
        }
    }

    private void hapticNavigate() {
        ControlifyApi.get().getCurrentController().flatMap(ControllerEntity::hdHaptics).ifPresent(hh -> hh.playHaptic(HapticEffects.NAVIGATE));
    }

    @Override
    public VirtualMouseBehaviour virtualMouseBehaviour() {
        return VirtualMouseBehaviour.CURSOR_ONLY;
    }

    @FunctionalInterface
    public static interface ClickSlotFunction {
        public void clickSlot(class_1735 var1, int var2, int var3, class_1713 var4);
    }
}

