/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.mixins.feature.rumble.levelevents;

import dev.isxander.controlify.api.ControlifyApi;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.rumble.BasicRumbleEffect;
import dev.isxander.controlify.rumble.RumbleEffect;
import dev.isxander.controlify.rumble.RumbleSource;
import dev.isxander.controlify.rumble.RumbleState;
import dev.isxander.controlify.utils.Easings;
import net.minecraft.class_2338;
import net.minecraft.class_761;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_761.class})
public class LevelRendererMixin {
    @Inject(method={"method_8567(ILnet/minecraft/class_2338;I)V"}, at={@At(value="HEAD")})
    private void onLevelEvent(int eventId, class_2338 pos, int data, CallbackInfo ci) {
        switch (eventId) {
            case 1030: {
                this.rumble(RumbleSource.GUI, BasicRumbleEffect.join(BasicRumbleEffect.constant(1.0f, 0.5f, 2), BasicRumbleEffect.empty(5)).repeat(3));
            }
        }
    }

    @Inject(method={"method_8564(ILnet/minecraft/class_2338;I)V"}, at={@At(value="HEAD")})
    private void onGlobalLevelEvent(int eventId, class_2338 pos, int data, CallbackInfo ci) {
        switch (eventId) {
            case 1028: {
                this.rumble(RumbleSource.WORLD, BasicRumbleEffect.join(BasicRumbleEffect.constant(1.0f, 1.0f, 194), BasicRumbleEffect.byTime(t -> {
                    float easeOutQuad = Easings.easeOutQuad(t.floatValue());
                    return new RumbleState(1.0f - easeOutQuad, 1.0f - easeOutQuad);
                }, 63)).prioritised(10));
                break;
            }
            case 1023: {
                this.rumble(RumbleSource.WORLD, BasicRumbleEffect.join(BasicRumbleEffect.constant(1.0f, 1.0f, 9), BasicRumbleEffect.constant(0.1f, 1.0f, 14), BasicRumbleEffect.byTime(t -> {
                    float easeOutQuad = 1.0f - (1.0f - t.floatValue()) * (1.0f - t.floatValue());
                    return new RumbleState(0.0f, 1.0f - easeOutQuad);
                }, 56)).prioritised(10));
            }
        }
    }

    @Unique
    private void rumble(RumbleSource source, RumbleEffect effect) {
        ControlifyApi.get().getCurrentController().flatMap(ControllerEntity::rumble).ifPresent(rumble -> rumble.rumbleManager().play(source, effect));
    }
}

