/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.gui.screen;

import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.api.bind.InputBinding;
import dev.isxander.controlify.api.bind.InputBindingSupplier;
import dev.isxander.controlify.bindings.BindContext;
import dev.isxander.controlify.bindings.ControlifyBindings;
import dev.isxander.controlify.bindings.input.EmptyInput;
import dev.isxander.controlify.bindings.input.Input;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.controller.GenericControllerConfig;
import dev.isxander.controlify.controller.dualsense.HDHapticComponent;
import dev.isxander.controlify.controller.gyro.GyroComponent;
import dev.isxander.controlify.controller.gyro.GyroYawMode;
import dev.isxander.controlify.controller.input.DeadzoneGroup;
import dev.isxander.controlify.controller.input.InputComponent;
import dev.isxander.controlify.controller.input.Inputs;
import dev.isxander.controlify.controller.rumble.RumbleComponent;
import dev.isxander.controlify.gui.controllers.BindController;
import dev.isxander.controlify.gui.controllers.Deadzone2DImageRenderer;
import dev.isxander.controlify.gui.guide.InGameButtonGuide;
import dev.isxander.controlify.gui.screen.ControllerCalibrationScreen;
import dev.isxander.controlify.gui.screen.ControllerMappingMakerScreen;
import dev.isxander.controlify.gui.screen.RadialItems;
import dev.isxander.controlify.gui.screen.RadialMenuScreen;
import dev.isxander.controlify.rumble.BasicRumbleEffect;
import dev.isxander.controlify.rumble.RumbleSource;
import dev.isxander.controlify.rumble.RumbleState;
import dev.isxander.controlify.server.ServerPolicies;
import dev.isxander.controlify.server.ServerPolicy;
import dev.isxander.controlify.utils.CUtil;
import dev.isxander.yacl3.api.ButtonOption;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.LabelOption;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionFlag;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.controller.BooleanControllerBuilder;
import dev.isxander.yacl3.api.controller.EnumControllerBuilder;
import dev.isxander.yacl3.api.controller.FloatSliderControllerBuilder;
import dev.isxander.yacl3.api.controller.IntegerSliderControllerBuilder;
import dev.isxander.yacl3.api.controller.StringControllerBuilder;
import dev.isxander.yacl3.api.controller.TickBoxControllerBuilder;
import dev.isxander.yacl3.api.controller.ValueFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;

public class ControllerConfigScreenFactory {
    private static final ValueFormatter<Float> percentFormatter = v -> class_2561.method_43470((String)String.format("%.0f%%", Float.valueOf(v.floatValue() * 100.0f)));
    private static final ValueFormatter<Float> percentOrOffFormatter = v -> v.floatValue() == 0.0f ? class_5244.field_24333 : percentFormatter.format(v);
    private static final class_2561 newOptionLabel = class_2561.method_43471((String)"controlify.gui.new_options.label").method_27692(class_124.field_1065);
    private static final ValueFormatter<Integer> ticksToMillisFormatter = v -> class_2561.method_43470((String)String.format("%03dms", v * 50));
    private final List<Option<?>> newOptions = new ArrayList();

    public static class_437 generateConfigScreen(class_437 parent, ControllerEntity controller) {
        return new ControllerConfigScreenFactory().generateConfigScreen0(parent, controller);
    }

    private class_437 generateConfigScreen0(class_437 parent, ControllerEntity controller) {
        ConfigCategory advancedCategory = this.createAdvancedCategory(controller);
        Optional<ConfigCategory> bindsCategory = this.makeBindsCategory(controller);
        ConfigCategory basicCategory = this.createBasicCategory(controller);
        YetAnotherConfigLib.Builder yacl = YetAnotherConfigLib.createBuilder().title((class_2561)class_2561.method_43470((String)"Controlify")).category(basicCategory).category(advancedCategory).save(() -> Controlify.instance().config().save());
        bindsCategory.ifPresent(arg_0 -> ((YetAnotherConfigLib.Builder)yacl).category(arg_0));
        return yacl.build().generateScreen(parent);
    }

    private ConfigCategory createBasicCategory(ControllerEntity controller) {
        Optional<OptionGroup> sensitivityGroup = this.makeSensitivityGroup(controller);
        Optional<OptionGroup> controlsGroup = this.makeControlsGroup(controller);
        Optional<OptionGroup> accessibilityGroup = this.makeAccessibilityGroup(controller);
        Optional<OptionGroup> deadzoneGroup = this.makeDeadzoneGroup(controller);
        GenericControllerConfig config = controller.genericConfig().config();
        GenericControllerConfig def = controller.genericConfig().defaultConfig();
        ConfigCategory.Builder builder = ConfigCategory.createBuilder().name((class_2561)class_2561.method_43471((String)"controlify.gui.config.category.basic")).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"controlify.gui.custom_name")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"controlify.gui.custom_name.tooltip")})).binding((Object)(def.nickname == null ? "" : def.nickname), () -> config.nickname == null ? "" : config.nickname, v -> {
            config.nickname = v.isEmpty() ? null : v;
        }).controller(StringControllerBuilder::create).build());
        if (!this.newOptions.isEmpty()) {
            builder.group(OptionGroup.createBuilder().name((class_2561)class_2561.method_43471((String)"controlify.gui.new_options").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067})).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"controlify.gui.new_options.tooltip")})).options(this.newOptions).build());
        }
        sensitivityGroup.ifPresent(arg_0 -> ((ConfigCategory.Builder)builder).group(arg_0));
        controlsGroup.ifPresent(arg_0 -> ((ConfigCategory.Builder)builder).group(arg_0));
        accessibilityGroup.ifPresent(arg_0 -> ((ConfigCategory.Builder)builder).group(arg_0));
        deadzoneGroup.ifPresent(arg_0 -> ((ConfigCategory.Builder)builder).group(arg_0));
        return builder.build();
    }

    private Optional<OptionGroup> makeSensitivityGroup(ControllerEntity controller) {
        Optional<InputComponent> inputOpt = controller.input();
        if (inputOpt.isEmpty()) {
            return Optional.empty();
        }
        InputComponent.Config config = (InputComponent.Config)inputOpt.get().confObj();
        InputComponent.Config def = (InputComponent.Config)inputOpt.get().defObj();
        return Optional.of(OptionGroup.createBuilder().name((class_2561)class_2561.method_43471((String)"controlify.gui.config.group.sensitivity")).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"controlify.gui.horizontal_look_sensitivity")).description(OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43471((String)"controlify.gui.horizontal_look_sensitivity.tooltip")}).build()).binding((Object)Float.valueOf(def.hLookSensitivity), () -> Float.valueOf(config.hLookSensitivity), v -> {
            config.hLookSensitivity = v.floatValue();
        }).controller(opt -> ((FloatSliderControllerBuilder)((FloatSliderControllerBuilder)FloatSliderControllerBuilder.create((Option)opt).range((Number)Float.valueOf(0.1f), (Number)Float.valueOf(2.0f))).step((Number)Float.valueOf(0.05f))).formatValue(percentFormatter)).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"controlify.gui.vertical_look_sensitivity")).description(OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43471((String)"controlify.gui.vertical_look_sensitivity.tooltip")}).build()).binding((Object)Float.valueOf(def.vLookSensitivity), () -> Float.valueOf(config.vLookSensitivity), v -> {
            config.vLookSensitivity = v.floatValue();
        }).controller(opt -> ((FloatSliderControllerBuilder)((FloatSliderControllerBuilder)FloatSliderControllerBuilder.create((Option)opt).range((Number)Float.valueOf(0.1f), (Number)Float.valueOf(2.0f))).step((Number)Float.valueOf(0.05f))).formatValue(percentFormatter)).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"controlify.gui.vmouse_sensitivity")).description(OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43471((String)"controlify.gui.vmouse_sensitivity.tooltip")}).build()).binding((Object)Float.valueOf(def.virtualMouseSensitivity), () -> Float.valueOf(config.virtualMouseSensitivity), v -> {
            config.virtualMouseSensitivity = v.floatValue();
        }).controller(opt -> ((FloatSliderControllerBuilder)((FloatSliderControllerBuilder)FloatSliderControllerBuilder.create((Option)opt).range((Number)Float.valueOf(0.1f), (Number)Float.valueOf(2.0f))).step((Number)Float.valueOf(0.05f))).formatValue(percentFormatter)).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"controlify.gui.reduce_aiming_sensitivity")).description(OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43471((String)"controlify.gui.reduce_aiming_sensitivity.tooltip")}).webpImage(ControllerConfigScreenFactory.screenshot("reduce-aim-sensitivity.webp")).build()).binding((Object)def.reduceAimingSensitivity, () -> config.reduceAimingSensitivity, v -> {
            config.reduceAimingSensitivity = v;
        }).controller(TickBoxControllerBuilder::create).build()).build());
    }

    private Optional<OptionGroup> makeControlsGroup(ControllerEntity controller) {
        ValueFormatter holdToggleFormatter = v -> class_2561.method_43471((String)("controlify.gui.format.hold_toggle." + (v != false ? "toggle" : "hold")));
        GenericControllerConfig config = controller.genericConfig().config();
        GenericControllerConfig def = controller.genericConfig().defaultConfig();
        return Optional.of(OptionGroup.createBuilder().name((class_2561)class_2561.method_43471((String)"controlify.gui.config.group.controls")).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"controlify.gui.toggle_sprint")).description(OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43471((String)"controlify.gui.toggle_sprint.tooltip")}).build()).binding((Object)def.toggleSprint, () -> config.toggleSprint, v -> {
            config.toggleSprint = v;
        }).controller(opt -> ((BooleanControllerBuilder)BooleanControllerBuilder.create((Option)opt).formatValue(holdToggleFormatter)).coloured(false)).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"controlify.gui.toggle_sneak")).description(OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43471((String)"controlify.gui.toggle_sneak.tooltip")}).build()).binding((Object)def.toggleSneak, () -> config.toggleSneak, v -> {
            config.toggleSneak = v;
        }).controller(opt -> ((BooleanControllerBuilder)BooleanControllerBuilder.create((Option)opt).formatValue(holdToggleFormatter)).coloured(false)).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"controlify.gui.auto_jump")).description(OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43471((String)"controlify.gui.auto_jump.tooltip")}).build()).binding((Object)def.autoJump, () -> config.autoJump, v -> {
            config.autoJump = v;
        }).controller(opt -> BooleanControllerBuilder.create((Option)opt).onOffFormatter()).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"controlify.gui.no_fly_drifting")).description(OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43471((String)"controlify.gui.no_fly_drifting.tooltip")}).text(new class_2561[]{ServerPolicies.DISABLE_FLY_DRIFTING.get() != ServerPolicy.UNSET ? class_2561.method_43471((String)"controlify.gui.server_controlled").method_27692(class_124.field_1065) : class_2561.method_43473()}).build()).binding((Object)def.disableFlyDrifting, () -> ServerPolicies.DISABLE_FLY_DRIFTING.get().isAllowed() && config.disableFlyDrifting, v -> {
            config.disableFlyDrifting = v;
        }).controller(TickBoxControllerBuilder::create).available(ServerPolicies.DISABLE_FLY_DRIFTING.get().isAllowed()).build()).build());
    }

    private Optional<OptionGroup> makeAccessibilityGroup(ControllerEntity controller) {
        GenericControllerConfig config = controller.genericConfig().config();
        GenericControllerConfig def = controller.genericConfig().defaultConfig();
        return Optional.of(OptionGroup.createBuilder().name((class_2561)class_2561.method_43471((String)"controlify.config.group.accessibility")).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"controlify.gui.show_ingame_guide")).description(OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43471((String)"controlify.gui.show_ingame_guide.tooltip")}).image(ControllerConfigScreenFactory.screenshot("ingame-button-guide.png"), 961, 306).build()).binding((Object)def.showIngameGuide, () -> config.showIngameGuide, v -> {
            config.showIngameGuide = v;
        }).controller(TickBoxControllerBuilder::create).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"controlify.gui.ingame_button_guide_position")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"controlify.gui.ingame_button_guide_position.tooltip")})).binding((Object)def.ingameGuideBottom, () -> config.ingameGuideBottom, v -> {
            config.ingameGuideBottom = v;
        }).controller(opt -> BooleanControllerBuilder.create((Option)opt).formatValue(v -> class_2561.method_43471((String)(v != false ? "controlify.gui.format.bottom" : "controlify.gui.format.top")))).flag(new OptionFlag[]{mc -> Controlify.instance().inGameButtonGuide().ifPresent(InGameButtonGuide::refreshLayout)}).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"controlify.gui.show_screen_guide")).description(OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43471((String)"controlify.gui.show_screen_guide.tooltip")}).webpImage(ControllerConfigScreenFactory.screenshot("screen-button-guide.webp")).build()).binding((Object)def.showScreenGuides, () -> config.showScreenGuides, v -> {
            config.showScreenGuides = v;
        }).controller(TickBoxControllerBuilder::create).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"controlify.gui.show_keyboard")).description(OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43471((String)"controlify.gui.show_keyboard.tooltip")}).build()).binding((Object)def.showOnScreenKeyboard, () -> config.showOnScreenKeyboard, v -> {
            config.showOnScreenKeyboard = v;
        }).available(def.showOnScreenKeyboard).controller(TickBoxControllerBuilder::create).build()).build());
    }

    private Optional<OptionGroup> makeDeadzoneGroup(ControllerEntity controller) {
        Optional<InputComponent> inputOpt = controller.input();
        if (inputOpt.isEmpty()) {
            return Optional.empty();
        }
        InputComponent input = inputOpt.get();
        InputComponent.Config config = (InputComponent.Config)input.confObj();
        InputComponent.Config def = (InputComponent.Config)input.defObj();
        ArrayList<Option> deadzoneOpts = new ArrayList<Option>();
        OptionGroup.Builder group = OptionGroup.createBuilder().name((class_2561)class_2561.method_43471((String)"controlify.config.group.deadzones"));
        group.option((Option)LabelOption.create((class_2561)class_2561.method_43471((String)"controlify.gui.stickdrift_warning").method_27692(class_124.field_1061)));
        for (DeadzoneGroup deadzoneGroup : input.getDeadzoneGroups().values()) {
            class_2960 groupName = deadzoneGroup.name();
            class_5250 name = class_2561.method_43471((String)("controlify.deadzone_group." + groupName.method_12836() + "." + groupName.method_12832()));
            AtomicReference<Option> deadzoneRef = new AtomicReference<Option>();
            Option deadzoneOpt = Option.createBuilder().name((class_2561)name).description(OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43469((String)"controlify.gui.axis_deadzone.tooltip", (Object[])new Object[]{name})}).customImage(CompletableFuture.completedFuture(deadzoneGroup.axes().size() == 4 ? Optional.of(new Deadzone2DImageRenderer(input, deadzoneGroup, deadzoneRef::get)) : Optional.empty())).build()).binding((Object)def.deadzones.getOrDefault(groupName, Float.valueOf(0.0f)), () -> config.deadzones.getOrDefault(groupName, Float.valueOf(0.0f)), v -> config.deadzones.put(groupName, (Float)v)).controller(opt -> ((FloatSliderControllerBuilder)((FloatSliderControllerBuilder)FloatSliderControllerBuilder.create((Option)opt).range((Number)Float.valueOf(0.0f), (Number)Float.valueOf(1.0f))).step((Number)Float.valueOf(0.02f))).formatValue(percentFormatter)).build();
            deadzoneRef.set(deadzoneOpt);
            group.option(deadzoneOpt);
            deadzoneOpts.add(deadzoneOpt);
        }
        group.option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"controlify.gui.button_activation_threshold")).description(OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43471((String)"controlify.gui.button_activation_threshold.tooltip")}).build()).binding((Object)Float.valueOf(def.buttonActivationThreshold), () -> Float.valueOf(config.buttonActivationThreshold), v -> {
            config.buttonActivationThreshold = v.floatValue();
        }).controller(opt -> ((FloatSliderControllerBuilder)((FloatSliderControllerBuilder)FloatSliderControllerBuilder.create((Option)opt).range((Number)Float.valueOf(0.0f), (Number)Float.valueOf(1.0f))).step((Number)Float.valueOf(0.01f))).formatValue(percentFormatter)).build());
        group.option((Option)ButtonOption.createBuilder().name((class_2561)class_2561.method_43471((String)"controlify.gui.auto_calibration")).description(OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43471((String)"controlify.gui.auto_calibration.tooltip")}).build()).action((screen, button) -> class_310.method_1551().method_1507((class_437)new ControllerCalibrationScreen(controller, () -> {
            deadzoneOpts.forEach(Option::forgetPendingValue);
            return screen;
        }))).build());
        return Optional.of(group.build());
    }

    private ConfigCategory createAdvancedCategory(ControllerEntity controller) {
        Optional<InputComponent> input = controller.input();
        ConfigCategory.Builder builder = ConfigCategory.createBuilder().name((class_2561)class_2561.method_43471((String)"controlify.config.category.advanced"));
        input.ifPresent(inputComponent -> builder.option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"controlify.gui.mixed_input")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"controlify.gui.mixed_input.tooltip")})).binding((Object)((InputComponent.Config)inputComponent.defObj()).mixedInput, () -> ((InputComponent.Config)inputComponent.confObj()).mixedInput, v -> {
            ((InputComponent.Config)inputComponent.confObj()).mixedInput = v;
        }).controller(TickBoxControllerBuilder::create).build()));
        this.makeVibrationGroup(controller).ifPresent(arg_0 -> ((ConfigCategory.Builder)builder).group(arg_0));
        this.makeGyroGroup(controller).ifPresent(arg_0 -> ((ConfigCategory.Builder)builder).group(arg_0));
        this.makeControllerMappingGroup(controller).ifPresent(arg_0 -> ((ConfigCategory.Builder)builder).group(arg_0));
        return builder.build();
    }

    private Optional<OptionGroup> makeControllerMappingGroup(ControllerEntity controller) {
        Optional<InputComponent> inputOpt = controller.input();
        if (inputOpt.isEmpty()) {
            return Optional.empty();
        }
        InputComponent input = inputOpt.get();
        InputComponent.Config config = (InputComponent.Config)input.confObj();
        InputComponent.Config def = (InputComponent.Config)input.defObj();
        return Optional.of(OptionGroup.createBuilder().name((class_2561)class_2561.method_43471((String)"controlify.gui.group.controller_mapping")).option((Option)LabelOption.create((class_2561)class_2561.method_43471((String)"controlify.gui.controller_mapping.explanation"))).option((Option)ButtonOption.createBuilder().name((class_2561)class_2561.method_43471((String)"controlify.gui.create_gamepad_mapping")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"controlify.gui.create_gamepad_mapping.tooltip")})).action((screen, button) -> class_310.method_1551().method_1507((class_437)ControllerMappingMakerScreen.createGamepadMapping(input, (class_437)screen))).build()).option((Option)ButtonOption.createBuilder().name((class_2561)class_2561.method_43471((String)"controlify.gui.clear_mapping")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"controlify.gui.clear_mapping.tooltip")})).action((screen, button) -> {
            config.mapping = def.mapping;
        }).build()).collapsed(true).build());
    }

    private Optional<OptionGroup> makeVibrationGroup(ControllerEntity controller) {
        OptionGroup.Builder vibrationGroup = OptionGroup.createBuilder().name((class_2561)class_2561.method_43471((String)"controlify.gui.group.vibration")).description(OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43471((String)"controlify.gui.group.vibration.tooltip")}).build());
        Optional<RumbleComponent> rumbleOpt = controller.rumble();
        if (rumbleOpt.isEmpty()) {
            vibrationGroup.option((Option)LabelOption.create((class_2561)class_2561.method_43471((String)"controlify.gui.allow_vibrations.not_available").method_27692(class_124.field_1061)));
            return Optional.of(vibrationGroup.build());
        }
        RumbleComponent rumble = rumbleOpt.get();
        RumbleComponent.Config config = (RumbleComponent.Config)rumble.confObj();
        RumbleComponent.Config def = (RumbleComponent.Config)rumble.defObj();
        ArrayList<Option> strengthOptions = new ArrayList<Option>();
        Option allowVibrationOption = Option.createBuilder().name((class_2561)class_2561.method_43471((String)"controlify.gui.allow_vibrations")).description(OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43471((String)"controlify.gui.allow_vibrations.tooltip")}).build()).binding((Object)def.enabled, () -> config.enabled, v -> {
            config.enabled = v;
        }).listener((opt, allowVibration) -> strengthOptions.forEach(so -> so.setAvailable(allowVibration.booleanValue()))).controller(TickBoxControllerBuilder::create).build();
        vibrationGroup.option(allowVibrationOption);
        controller.hdHaptics().ifPresent(haptics -> vibrationGroup.option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"controlify.gui.hd_haptics")).description(OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43471((String)"controlify.gui.hd_haptics.tooltip")}).build()).binding((Object)((HDHapticComponent.Config)haptics.defObj()).enabled, () -> ((HDHapticComponent.Config)haptics.confObj()).enabled, v -> {
            ((HDHapticComponent.Config)haptics.confObj()).enabled = v;
        }).controller(TickBoxControllerBuilder::create).build()));
        for (RumbleSource source : RumbleSource.values()) {
            Option option = Option.createBuilder().name((class_2561)class_2561.method_43471((String)("controlify.vibration_strength." + source.id().method_12836() + "." + source.id().method_12832()))).description(OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43471((String)("controlify.vibration_strength." + source.id().method_12836() + "." + source.id().method_12832() + ".tooltip"))}).build()).binding((Object)def.vibrationStrengths.getOrDefault(source.id(), Float.valueOf(1.0f)), () -> config.vibrationStrengths.getOrDefault(source.id(), Float.valueOf(1.0f)), v -> config.vibrationStrengths.put(source.id(), (Float)v)).controller(opt -> ((FloatSliderControllerBuilder)((FloatSliderControllerBuilder)FloatSliderControllerBuilder.create((Option)opt).range((Number)Float.valueOf(0.0f), (Number)Float.valueOf(2.0f))).step((Number)Float.valueOf(0.05f))).formatValue(percentOrOffFormatter)).available(((Boolean)allowVibrationOption.pendingValue()).booleanValue()).build();
            strengthOptions.add(option);
            vibrationGroup.option(option);
        }
        vibrationGroup.option((Option)ButtonOption.createBuilder().name((class_2561)class_2561.method_43471((String)"controlify.gui.test_vibration")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"controlify.gui.test_vibration.tooltip")})).action((screen, btn) -> rumble.rumbleManager().play(RumbleSource.MASTER, BasicRumbleEffect.byTime(t -> new RumbleState(0.0f, t.floatValue()), 20).join(BasicRumbleEffect.byTime(t -> new RumbleState(0.0f, 1.0f - t.floatValue()), 20)).repeat(3).join(BasicRumbleEffect.constant(1.0f, 0.0f, 5).join(BasicRumbleEffect.constant(0.0f, 1.0f, 5)).repeat(10)).earlyFinish(BasicRumbleEffect.finishOnScreenChange()))).build());
        return Optional.of(vibrationGroup.build());
    }

    private Optional<OptionGroup> makeGyroGroup(ControllerEntity controller) {
        OptionGroup.Builder gyroGroup = OptionGroup.createBuilder().name((class_2561)class_2561.method_43471((String)"controlify.gui.group.gyro")).description(OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43471((String)"controlify.gui.group.gyro.tooltip")}).build());
        Optional<GyroComponent> gyroOpt = controller.gyro();
        if (gyroOpt.isEmpty()) {
            gyroGroup.collapsed(true);
            gyroGroup.option((Option)LabelOption.create((class_2561)class_2561.method_43471((String)"controlify.gui.group.gyro.no_gyro.tooltip").method_27692(class_124.field_1061)));
            return Optional.of(gyroGroup.build());
        }
        GyroComponent.Config config = (GyroComponent.Config)gyroOpt.get().confObj();
        GyroComponent.Config def = (GyroComponent.Config)gyroOpt.get().defObj();
        ArrayList gyroOptions = new ArrayList();
        Option gyroSensitivity = Option.createBuilder().name((class_2561)class_2561.method_43471((String)"controlify.gui.gyro_look_sensitivity")).description(OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43471((String)"controlify.gui.gyro_look_sensitivity.tooltip")}).build()).binding((Object)Float.valueOf(def.lookSensitivity), () -> Float.valueOf(config.lookSensitivity), v -> {
            config.lookSensitivity = v.floatValue();
        }).controller(opt -> ((FloatSliderControllerBuilder)((FloatSliderControllerBuilder)FloatSliderControllerBuilder.create((Option)opt).range((Number)Float.valueOf(0.0f), (Number)Float.valueOf(3.0f))).step((Number)Float.valueOf(0.1f))).formatValue(percentOrOffFormatter)).listener((opt, sensitivity) -> gyroOptions.forEach(o -> {
            o.setAvailable(sensitivity.floatValue() > 0.0f);
            o.requestSetDefault();
        })).build();
        gyroGroup.option(gyroSensitivity);
        Option relativeModeOpt = Option.createBuilder().name((class_2561)class_2561.method_43471((String)"controlify.gui.gyro_behaviour")).description(val -> OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43471((String)"controlify.gui.gyro_behaviour.tooltip")}).text(new class_2561[]{val != false ? class_2561.method_43471((String)"controlify.gui.gyro_behaviour.relative.tooltip") : class_2561.method_43471((String)"controlify.gui.gyro_behaviour.absolute.tooltip")}).build()).binding((Object)def.relativeGyroMode, () -> config.relativeGyroMode, v -> {
            config.relativeGyroMode = v;
        }).controller(opt -> BooleanControllerBuilder.create((Option)opt).formatValue(v -> v != false ? class_2561.method_43471((String)"controlify.gui.gyro_behaviour.relative") : class_2561.method_43471((String)"controlify.gui.gyro_behaviour.absolute"))).build();
        gyroGroup.option(relativeModeOpt);
        gyroGroup.option((Option)class_156.method_656(() -> {
            Option option = Option.createBuilder().name((class_2561)class_2561.method_43471((String)"controlify.gui.gyro_yaw_mode")).description(val -> OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43471((String)"controlify.gui.gyro_yaw_mode.tooltip")}).text(new class_2561[]{val == GyroYawMode.YAW ? class_2561.method_43471((String)"controlify.gui.gyro_yaw_mode.tooltip.yaw_only") : class_2561.method_43473()}).text(new class_2561[]{val == GyroYawMode.ROLL ? class_2561.method_43471((String)"controlify.gui.gyro_yaw_mode.tooltip.roll_only") : class_2561.method_43473()}).text(new class_2561[]{val == GyroYawMode.BOTH ? class_2561.method_43471((String)"controlify.gui.gyro_yaw_mode.tooltip.both") : class_2561.method_43473()}).build()).binding((Object)def.yawMode, () -> config.yawMode, v -> {
                config.yawMode = v;
            }).controller(opt -> EnumControllerBuilder.create((Option)opt).enumClass(GyroYawMode.class)).build();
            gyroOptions.add(option);
            return option;
        }));
        gyroGroup.option((Option)class_156.method_656(() -> {
            Option opt = Option.createBuilder().name((class_2561)class_2561.method_43471((String)"controlify.gui.gyro_invert_x")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"controlify.gui.gyro_invert_x.tooltip")})).binding((Object)def.invertX, () -> config.invertX, v -> {
                config.invertX = v;
            }).controller(TickBoxControllerBuilder::create).build();
            gyroOptions.add(opt);
            return opt;
        }));
        gyroGroup.option((Option)class_156.method_656(() -> {
            Option opt = Option.createBuilder().name((class_2561)class_2561.method_43471((String)"controlify.gui.gyro_invert_y")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"controlify.gui.gyro_invert_y.tooltip")})).binding((Object)def.invertY, () -> config.invertY, v -> {
                config.invertY = v;
            }).controller(TickBoxControllerBuilder::create).build();
            gyroOptions.add(opt);
            return opt;
        }));
        gyroGroup.option((Option)class_156.method_656(() -> {
            Option opt = Option.createBuilder().name((class_2561)class_2561.method_43471((String)"controlify.gui.gyro_requires_button")).description(OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43471((String)"controlify.gui.gyro_requires_button.tooltip")}).build()).binding((Object)def.requiresButton, () -> config.requiresButton, v -> {
                config.requiresButton = v;
            }).controller(TickBoxControllerBuilder::create).available(((Float)gyroSensitivity.pendingValue()).floatValue() > 0.0f).listener((o, val) -> {
                if (val.booleanValue()) {
                    relativeModeOpt.setAvailable(((Float)gyroSensitivity.pendingValue()).floatValue() > 0.0f);
                } else {
                    relativeModeOpt.setAvailable(false);
                    relativeModeOpt.requestSet((Object)false);
                }
            }).build();
            gyroOptions.add(opt);
            return opt;
        }));
        gyroGroup.option((Option)class_156.method_656(() -> {
            Option opt = Option.createBuilder().name((class_2561)class_2561.method_43471((String)"controlify.gui.flick_stick")).description(OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43471((String)"controlify.gui.flick_stick.tooltip")}).build()).binding((Object)def.flickStick, () -> config.flickStick, v -> {
                config.flickStick = v;
            }).controller(TickBoxControllerBuilder::create).available(((Float)gyroSensitivity.pendingValue()).floatValue() > 0.0f).build();
            gyroOptions.add(opt);
            return opt;
        }));
        return Optional.of(gyroGroup.build());
    }

    private Optional<ConfigCategory> makeBindsCategory(ControllerEntity controller) {
        Optional<InputComponent> inputOpt = controller.input();
        if (inputOpt.isEmpty()) {
            return Optional.empty();
        }
        InputComponent input = inputOpt.get();
        ConfigCategory.Builder category = ConfigCategory.createBuilder().name((class_2561)class_2561.method_43471((String)"controlify.gui.group.controls"));
        InputComponent.Config config = (InputComponent.Config)input.confObj();
        InputComponent.Config def = (InputComponent.Config)input.defObj();
        ArrayList<OptionBindPair> optionBinds = new ArrayList<OptionBindPair>();
        ButtonOption editRadialButton = ButtonOption.createBuilder().name((class_2561)class_2561.method_43471((String)"controlify.gui.radial_menu").method_27692(class_124.field_1065)).description(OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43471((String)"controlify.gui.radial_menu.tooltip")}).text(new class_2561[]{newOptionLabel}).build()).action((screen, opt) -> class_310.method_1551().method_1507((class_437)new RadialMenuScreen(controller, null, RadialItems.createBindings(controller), (class_2561)class_2561.method_43473(), new RadialItems.BindingEditMode(controller), (class_437)screen))).text((class_2561)class_2561.method_43471((String)"controlify.gui.radial_menu.btn_text")).build();
        Option radialBind = ControllerConfigScreenFactory.createBindingOpt(ControlifyBindings.RADIAL_MENU, controller).listener((opt, val) -> this.updateConflictingBinds(optionBinds)).build();
        optionBinds.add(new OptionBindPair(radialBind, ControlifyBindings.RADIAL_MENU.on(controller)));
        category.option((Option)editRadialButton);
        category.option(radialBind);
        category.option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"controlify.gui.radial_menu.btn_focus_timeout")).description(OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43471((String)"controlify.gui.radial_menu.btn_focus_timeout.tooltip")}).build()).binding((Object)def.radialButtonFocusTimeoutTicks, () -> config.radialButtonFocusTimeoutTicks, v -> {
            config.radialButtonFocusTimeoutTicks = v;
        }).controller(opt -> ((IntegerSliderControllerBuilder)((IntegerSliderControllerBuilder)IntegerSliderControllerBuilder.create((Option)opt).range((Number)2, (Number)40)).step((Number)1)).formatValue(ticksToMillisFormatter)).build());
        ControllerConfigScreenFactory.groupBindings(input.getAllBindings()).forEach((categoryName, bindGroup) -> {
            OptionGroup.Builder controlsGroup = OptionGroup.createBuilder().name(categoryName);
            controlsGroup.options(bindGroup.stream().flatMap(binding -> {
                if (binding != ControlifyBindings.RADIAL_MENU.on(controller)) {
                    Option.Builder option = ControllerConfigScreenFactory.createBindingOpt(binding, controller).listener((opt, val) -> this.updateConflictingBinds(optionBinds));
                    Option built = option.build();
                    optionBinds.add(new OptionBindPair((Option<?>)built, (InputBinding)binding));
                    return Stream.of(built);
                }
                return Stream.empty();
            }).toList());
            category.group(controlsGroup.build());
        });
        this.updateConflictingBinds(optionBinds);
        category.option((Option)ButtonOption.createBuilder().name((class_2561)class_2561.method_43471((String)"controlify.gui.reset_all_binds")).description(OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43471((String)"controlify.gui.reset_all_binds.tooltip")}).build()).action((screen, opt) -> {
            for (OptionBindPair pair : optionBinds) {
                pair.option().requestSet((Object)pair.binding.defaultInput());
            }
        }).build());
        return Optional.of(category.build());
    }

    private void updateConflictingBinds(List<OptionBindPair> all) {
        all.forEach(pair -> ((BindController)pair.option().controller()).setConflicting(false));
        for (OptionBindPair opt : all) {
            Set<BindContext> ctxs = opt.binding().contexts();
            List<OptionBindPair> conflicting = all.stream().filter(pair -> pair.binding() != opt.binding()).filter(pair -> {
                boolean contextsMatch = pair.binding().contexts().stream().anyMatch(ctxs::contains);
                boolean bindMatches = pair.option().pendingValue().equals(opt.option().pendingValue());
                boolean bindIsNotEmpty = !(pair.option().pendingValue() instanceof EmptyInput);
                return contextsMatch && bindMatches && bindIsNotEmpty;
            }).toList();
            conflicting.forEach(conflict -> ((BindController)conflict.option().controller()).setConflicting(true));
        }
    }

    private static Map<class_2561, List<InputBinding>> groupBindings(Collection<InputBinding> bindings) {
        return bindings.stream().collect(Collectors.groupingBy(InputBinding::category, LinkedHashMap::new, Collectors.toList()));
    }

    private static Option.Builder<Input> createBindingOpt(InputBindingSupplier bindingSupplier, ControllerEntity controller) {
        return ControllerConfigScreenFactory.createBindingOpt(bindingSupplier.on(controller), controller);
    }

    private static Option.Builder<Input> createBindingOpt(InputBinding binding, ControllerEntity controller) {
        return Option.createBuilder().name(binding.name()).description(v -> OptionDescription.createBuilder().text(new class_2561[]{binding.description()}).text(new class_2561[]{class_2561.method_43469((String)"controlify.gui.bind.currently_bound_to", (Object[])new Object[]{class_2561.method_43473().method_10852(Controlify.instance().inputFontMapper().getComponentFromInputs(controller.info().type().namespace(), v.getRelevantInputs())).method_10852(class_5244.field_41874).method_10852((class_2561)Inputs.getInputComponentAnd(v.getRelevantInputs()))})}).text(new class_2561[]{v.equals(binding.defaultInput()) ? class_2561.method_43473() : class_2561.method_43469((String)"controlify.gui.bind.default_bound_to", (Object[])new Object[]{class_2561.method_43473().method_10852(Controlify.instance().inputFontMapper().getComponentFromInputs(controller.info().type().namespace(), binding.defaultInput().getRelevantInputs())).method_10852(class_5244.field_41874).method_10852((class_2561)Inputs.getInputComponentAnd(binding.defaultInput().getRelevantInputs()))})}).build()).binding((Object)EmptyInput.INSTANCE, binding::boundInput, binding::setBoundInput).customController(opt -> new BindController((Option<Input>)opt, controller));
    }

    private static class_2960 screenshot(String filename) {
        return CUtil.rl("textures/screenshots/" + filename);
    }

    private record OptionBindPair(Option<?> option, InputBinding binding) {
    }
}

