/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.driver.sdl;

import com.sun.jna.ptr.IntByReference;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.controller.ControllerInfo;
import dev.isxander.controlify.controller.battery.BatteryLevelComponent;
import dev.isxander.controlify.controller.battery.PowerState;
import dev.isxander.controlify.controller.id.ControllerType;
import dev.isxander.controlify.controller.impl.ControllerStateImpl;
import dev.isxander.controlify.controller.input.HatState;
import dev.isxander.controlify.controller.input.InputComponent;
import dev.isxander.controlify.controller.input.JoystickInputs;
import dev.isxander.controlify.controller.rumble.RumbleComponent;
import dev.isxander.controlify.controller.rumble.TriggerRumbleComponent;
import dev.isxander.controlify.controllermanager.UniqueControllerID;
import dev.isxander.controlify.driver.Driver;
import dev.isxander.controlify.hid.HIDDevice;
import dev.isxander.controlify.utils.CUtil;
import dev.isxander.sdl3java.api.error.SdlError;
import dev.isxander.sdl3java.api.joystick.SDL_Joystick;
import dev.isxander.sdl3java.api.joystick.SDL_JoystickID;
import dev.isxander.sdl3java.api.joystick.SdlJoystick;
import dev.isxander.sdl3java.api.properties.SDL_PropertiesID;
import dev.isxander.sdl3java.api.properties.SdlProperties;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_3532;

public class SDL3JoystickDriver
implements Driver {
    private final SDL_Joystick ptrJoystick;
    private final ControllerEntity controller;
    private final boolean isRumbleSupported;
    private final boolean isTriggerRumbleSupported;
    private final String guid;
    private final String name;
    private final int numAxes;
    private final int numButtons;
    private final int numHats;

    public SDL3JoystickDriver(SDL_JoystickID jid, ControllerType type, String uid, UniqueControllerID ucid, Optional<HIDDevice> hid) {
        this.ptrJoystick = SdlJoystick.SDL_OpenJoystick((SDL_JoystickID)jid);
        if (this.ptrJoystick == null) {
            throw new IllegalStateException("Could not open joystick: " + SdlError.SDL_GetError());
        }
        SDL_PropertiesID props = SdlJoystick.SDL_GetJoystickProperties((SDL_Joystick)this.ptrJoystick);
        this.guid = SdlJoystick.SDL_GetJoystickInstanceGUID((SDL_JoystickID)jid).toString();
        this.name = SdlJoystick.SDL_GetJoystickName((SDL_Joystick)this.ptrJoystick);
        this.isRumbleSupported = SdlProperties.SDL_GetBooleanProperty((SDL_PropertiesID)props, (String)"SDL.joystick.cap.rumble", (boolean)false) == 1;
        this.isTriggerRumbleSupported = SdlProperties.SDL_GetBooleanProperty((SDL_PropertiesID)props, (String)"SDL.joystick.cap.trigger_rumble", (boolean)false) == 1;
        ControllerInfo info = new ControllerInfo(uid, ucid, this.guid, this.name, type, hid);
        this.controller = new ControllerEntity(info);
        this.numAxes = SdlJoystick.SDL_GetNumJoystickAxes((SDL_Joystick)this.ptrJoystick);
        this.numButtons = SdlJoystick.SDL_GetNumJoystickButtons((SDL_Joystick)this.ptrJoystick);
        this.numHats = SdlJoystick.SDL_GetNumJoystickHats((SDL_Joystick)this.ptrJoystick);
        this.controller.setComponent(new InputComponent(this.controller, this.numButtons, this.numAxes * 2, this.numHats, false, Set.of(), type.mappingId()), InputComponent.ID);
        this.controller.setComponent(new BatteryLevelComponent(), BatteryLevelComponent.ID);
        if (this.isRumbleSupported) {
            this.controller.setComponent(new RumbleComponent(), RumbleComponent.ID);
        }
        if (this.isTriggerRumbleSupported) {
            this.controller.setComponent(new TriggerRumbleComponent(), TriggerRumbleComponent.ID);
        }
        this.controller.finalise();
    }

    @Override
    public ControllerEntity getController() {
        return this.controller;
    }

    @Override
    public void update(boolean outOfFocus) {
        this.updateInput();
        this.updateRumble();
        this.updateBatteryLevel();
    }

    @Override
    public void close() {
        SdlJoystick.SDL_CloseJoystick((SDL_Joystick)this.ptrJoystick);
    }

    private void updateInput() {
        int i;
        ControllerStateImpl state = new ControllerStateImpl();
        for (i = 0; i < this.numAxes; ++i) {
            float axis = SDL3JoystickDriver.mapShortToFloat(SdlJoystick.SDL_GetJoystickAxis((SDL_Joystick)this.ptrJoystick, (int)i));
            state.setAxis(JoystickInputs.axis(i, true), Math.max(axis, 0.0f));
            state.setAxis(JoystickInputs.axis(i, false), -Math.min(axis, 0.0f));
        }
        for (i = 0; i < this.numButtons; ++i) {
            state.setButton(JoystickInputs.button(i), SdlJoystick.SDL_GetJoystickButton((SDL_Joystick)this.ptrJoystick, (int)i) == 1);
        }
        for (i = 0; i < this.numHats; ++i) {
            HatState hatState = switch (SdlJoystick.SDL_GetJoystickHat((SDL_Joystick)this.ptrJoystick, (int)i)) {
                case 0 -> HatState.CENTERED;
                case 1 -> HatState.UP;
                case 2 -> HatState.RIGHT;
                case 4 -> HatState.DOWN;
                case 8 -> HatState.LEFT;
                case 3 -> HatState.RIGHT_UP;
                case 6 -> HatState.RIGHT_DOWN;
                case 9 -> HatState.LEFT_UP;
                case 12 -> HatState.LEFT_DOWN;
                default -> throw new IllegalStateException("Unexpected value: " + SdlJoystick.SDL_GetJoystickHat((SDL_Joystick)this.ptrJoystick, (int)i));
            };
            state.setHat(JoystickInputs.hat(i), hatState);
        }
        this.controller.input().orElseThrow().pushState(state);
    }

    private void updateRumble() {
        Optional<Record> stateOpt;
        if (this.isRumbleSupported) {
            stateOpt = this.controller.rumble().orElseThrow().consumeRumble();
            stateOpt.ifPresent(state -> {
                if (SdlJoystick.SDL_RumbleJoystick((SDL_Joystick)this.ptrJoystick, (short)((short)(state.strong() * 65535.0f)), (short)((short)(state.weak() * 65535.0f)), (int)0) != 0) {
                    CUtil.LOGGER.error("Could not rumble joystick: {}", (Object)SdlError.SDL_GetError());
                }
            });
        }
        if (this.isTriggerRumbleSupported) {
            stateOpt = this.controller.triggerRumble().orElseThrow().consumeTriggerRumble();
            stateOpt.ifPresent(state -> {
                if (SdlJoystick.SDL_RumbleJoystickTriggers((SDL_Joystick)this.ptrJoystick, (short)((short)(state.left() * 65535.0f)), (short)((short)(state.right() * 65535.0f)), (int)0) != 0) {
                    CUtil.LOGGER.error("Could not rumble triggers joystick: {}", (Object)SdlError.SDL_GetError());
                }
            });
        }
    }

    private void updateBatteryLevel() {
        IntByReference percent = new IntByReference();
        int powerState = SdlJoystick.SDL_GetJoystickPowerInfo((SDL_Joystick)this.ptrJoystick, (IntByReference)percent);
        Record level = switch (powerState) {
            case -1, 0 -> new PowerState.Unknown();
            case 1 -> new PowerState.Depleting(percent.getValue());
            case 2 -> new PowerState.WiredOnly();
            case 3 -> new PowerState.Charging(percent.getValue());
            case 4 -> new PowerState.Full();
            default -> throw new IllegalStateException("Unexpected value");
        };
        this.controller.batteryLevel().orElseThrow().setBatteryLevel((PowerState)((Object)level));
    }

    private static float mapShortToFloat(short value) {
        return class_3532.method_37958((float)value, (float)-32768.0f, (float)0.0f, (float)-1.0f, (float)0.0f) + class_3532.method_37958((float)value, (float)0.0f, (float)32767.0f, (float)0.0f, (float)1.0f);
    }
}

