/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.driver.sdl;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.ByteByReference;
import com.sun.jna.ptr.FloatByReference;
import com.sun.jna.ptr.IntByReference;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.controller.ControllerInfo;
import dev.isxander.controlify.controller.battery.BatteryLevelComponent;
import dev.isxander.controlify.controller.battery.PowerState;
import dev.isxander.controlify.controller.dualsense.DualSenseComponent;
import dev.isxander.controlify.controller.dualsense.HDHapticComponent;
import dev.isxander.controlify.controller.dualsense.HapticBufferLibrary;
import dev.isxander.controlify.controller.gyro.GyroComponent;
import dev.isxander.controlify.controller.gyro.GyroState;
import dev.isxander.controlify.controller.id.ControllerType;
import dev.isxander.controlify.controller.impl.ControllerStateImpl;
import dev.isxander.controlify.controller.input.GamepadInputs;
import dev.isxander.controlify.controller.input.InputComponent;
import dev.isxander.controlify.controller.misc.BluetoothDeviceComponent;
import dev.isxander.controlify.controller.rumble.RumbleComponent;
import dev.isxander.controlify.controller.rumble.TriggerRumbleComponent;
import dev.isxander.controlify.controller.touchpad.TouchpadComponent;
import dev.isxander.controlify.controller.touchpad.TouchpadState;
import dev.isxander.controlify.controllermanager.UniqueControllerID;
import dev.isxander.controlify.driver.Driver;
import dev.isxander.controlify.driver.sdl.DS5EffectsState;
import dev.isxander.controlify.hid.HIDDevice;
import dev.isxander.controlify.utils.CUtil;
import dev.isxander.sdl3java.api.audio.SDL_AudioDeviceID;
import dev.isxander.sdl3java.api.audio.SDL_AudioFormat;
import dev.isxander.sdl3java.api.audio.SDL_AudioSpec;
import dev.isxander.sdl3java.api.audio.SDL_AudioStream;
import dev.isxander.sdl3java.api.audio.SdlAudio;
import dev.isxander.sdl3java.api.error.SdlError;
import dev.isxander.sdl3java.api.gamepad.SDL_Gamepad;
import dev.isxander.sdl3java.api.gamepad.SdlGamepad;
import dev.isxander.sdl3java.api.joystick.SDL_JoystickID;
import dev.isxander.sdl3java.api.properties.SDL_PropertiesID;
import dev.isxander.sdl3java.api.properties.SdlProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import javax.sound.sampled.AudioFormat;
import net.minecraft.class_156;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2f;
import org.joml.Vector2fc;

public class SDL3GamepadDriver
implements Driver {
    private static final int AUDIO_STREAM_TIMEOUT_TICKS = 360000;
    private SDL_Gamepad ptrGamepad;
    private final ControllerEntity controller;
    private final boolean isGryoSupported;
    private final boolean isRumbleSupported;
    private final boolean isTriggerRumbleSupported;
    private final int numTouchpads;
    private final int maxTouchpadFingers;
    private final String guid;
    private final String name;
    @Nullable
    private SDL_AudioDeviceID dualsenseAudioDev;
    @Nullable
    private SDL_AudioSpec dualsenseAudioSpec;
    private final List<AudioStreamHandle> dualsenseAudioHandles;

    public SDL3GamepadDriver(SDL_JoystickID jid, ControllerType type, String uid, UniqueControllerID ucid, Optional<HIDDevice> hid) {
        this.ptrGamepad = SdlGamepad.SDL_OpenGamepad((SDL_JoystickID)jid);
        if (this.ptrGamepad == null) {
            throw new IllegalStateException("Could not open gamepad: " + SdlError.SDL_GetError());
        }
        SDL_PropertiesID properties = SdlGamepad.SDL_GetGamepadProperties((SDL_Gamepad)this.ptrGamepad);
        this.name = SdlGamepad.SDL_GetGamepadName((SDL_Gamepad)this.ptrGamepad);
        this.guid = SdlGamepad.SDL_GetGamepadInstanceGUID((SDL_JoystickID)jid).toString();
        this.isGryoSupported = SdlGamepad.SDL_GamepadHasSensor((SDL_Gamepad)this.ptrGamepad, (int)2) == 1;
        this.isRumbleSupported = SdlProperties.SDL_GetBooleanProperty((SDL_PropertiesID)properties, (String)"SDL.joystick.cap.rumble", (boolean)false) == 1;
        this.isTriggerRumbleSupported = SdlProperties.SDL_GetBooleanProperty((SDL_PropertiesID)properties, (String)"SDL.joystick.cap.trigger_rumble", (boolean)false) == 1;
        this.numTouchpads = SdlGamepad.SDL_GetNumGamepadTouchpads((SDL_Gamepad)this.ptrGamepad);
        this.maxTouchpadFingers = IntStream.range(0, this.numTouchpads).map(i -> SdlGamepad.SDL_GetNumGamepadTouchpadFingers((SDL_Gamepad)this.ptrGamepad, (int)i)).sum();
        ControllerInfo info = new ControllerInfo(uid, ucid, this.guid, this.name, type, hid);
        this.controller = new ControllerEntity(info);
        this.dualsenseAudioHandles = new ArrayList<AudioStreamHandle>();
        if (CUtil.rl("dualsense").equals((Object)type.namespace())) {
            this.controller.setComponent(new DualSenseComponent(), DualSenseComponent.ID);
            if (class_156.method_668() != class_156.class_158.field_1137) {
                SDL_AudioDeviceID dualsenseAudioDev = null;
                SDL_AudioSpec.ByReference devSpec = new SDL_AudioSpec.ByReference();
                for (SDL_AudioDeviceID dev : SdlAudio.SDL_GetAudioOutputDevices()) {
                    String name = SdlAudio.SDL_GetAudioDeviceName((SDL_AudioDeviceID)dev).toLowerCase();
                    if (!name.contains("dualsense") && !name.contains("ps5") && !name.contains("wireless controller")) continue;
                    SdlAudio.SDL_GetAudioDeviceFormat((SDL_AudioDeviceID)dev, (SDL_AudioSpec.ByReference)devSpec, null);
                    if (devSpec.channels != 4) continue;
                    dualsenseAudioDev = dev;
                    break;
                }
                if (dualsenseAudioDev != null) {
                    this.dualsenseAudioSpec = devSpec;
                    this.dualsenseAudioDev = SdlAudio.SDL_OpenAudioDevice(dualsenseAudioDev, (SDL_AudioSpec.ByReference)((SDL_AudioSpec.ByReference)this.dualsenseAudioSpec));
                    HDHapticComponent hdHapticComponent = new HDHapticComponent();
                    hdHapticComponent.acceptPlayHaptic(this::playHaptic);
                    this.controller.setComponent(hdHapticComponent, HDHapticComponent.ID);
                } else {
                    this.dualsenseAudioDev = null;
                    this.dualsenseAudioSpec = null;
                    this.controller.setComponent(new BluetoothDeviceComponent(), BluetoothDeviceComponent.ID);
                }
            }
        }
        this.controller.setComponent(new InputComponent(this.controller, 21, 10, 0, true, GamepadInputs.DEADZONE_GROUPS, type.mappingId()), InputComponent.ID);
        this.controller.setComponent(new BatteryLevelComponent(), BatteryLevelComponent.ID);
        if (this.isGryoSupported) {
            SdlGamepad.SDL_SetGamepadSensorEnabled((SDL_Gamepad)this.ptrGamepad, (int)2, (boolean)true);
            this.controller.setComponent(new GyroComponent(), GyroComponent.ID);
        }
        if (this.isRumbleSupported) {
            this.controller.setComponent(new RumbleComponent(), RumbleComponent.ID);
        }
        if (this.isTriggerRumbleSupported) {
            this.controller.setComponent(new TriggerRumbleComponent(), TriggerRumbleComponent.ID);
        }
        if (this.numTouchpads > 0) {
            this.controller.setComponent(new TouchpadComponent(this.maxTouchpadFingers), TouchpadComponent.ID);
        }
        this.controller.finalise();
    }

    @Override
    public ControllerEntity getController() {
        return this.controller;
    }

    @Override
    public void update(boolean outOfFocus) {
        if (this.ptrGamepad == null) {
            throw new IllegalStateException("Tried to update controller even though it's closed.");
        }
        this.updateInput();
        this.updateRumble();
        this.updateGyro();
        this.updateTouchpad();
        this.updateBatteryLevel();
        this.updateHDHaptic();
        this.updateDualSense();
    }

    @Override
    public void close() {
        if (this.ptrGamepad == null) {
            throw new IllegalStateException("Gamepad already closed.");
        }
        SdlGamepad.SDL_CloseGamepad((SDL_Gamepad)this.ptrGamepad);
        this.ptrGamepad = null;
        if (this.dualsenseAudioDev != null) {
            SdlAudio.SDL_CloseAudioDevice((SDL_AudioDeviceID)this.dualsenseAudioDev);
        }
        for (AudioStreamHandle handle : this.dualsenseAudioHandles) {
            handle.close();
        }
    }

    private void updateInput() {
        ControllerStateImpl state = new ControllerStateImpl();
        state.setAxis(GamepadInputs.LEFT_STICK_AXIS_RIGHT, SDL3GamepadDriver.positiveAxis(SDL3GamepadDriver.mapShortToFloat(SdlGamepad.SDL_GetGamepadAxis((SDL_Gamepad)this.ptrGamepad, (int)0))));
        state.setAxis(GamepadInputs.LEFT_STICK_AXIS_LEFT, SDL3GamepadDriver.negativeAxis(SDL3GamepadDriver.mapShortToFloat(SdlGamepad.SDL_GetGamepadAxis((SDL_Gamepad)this.ptrGamepad, (int)0))));
        state.setAxis(GamepadInputs.LEFT_STICK_AXIS_UP, SDL3GamepadDriver.negativeAxis(SDL3GamepadDriver.mapShortToFloat(SdlGamepad.SDL_GetGamepadAxis((SDL_Gamepad)this.ptrGamepad, (int)1))));
        state.setAxis(GamepadInputs.LEFT_STICK_AXIS_DOWN, SDL3GamepadDriver.positiveAxis(SDL3GamepadDriver.mapShortToFloat(SdlGamepad.SDL_GetGamepadAxis((SDL_Gamepad)this.ptrGamepad, (int)1))));
        state.setAxis(GamepadInputs.RIGHT_STICK_AXIS_RIGHT, SDL3GamepadDriver.positiveAxis(SDL3GamepadDriver.mapShortToFloat(SdlGamepad.SDL_GetGamepadAxis((SDL_Gamepad)this.ptrGamepad, (int)2))));
        state.setAxis(GamepadInputs.RIGHT_STICK_AXIS_LEFT, SDL3GamepadDriver.negativeAxis(SDL3GamepadDriver.mapShortToFloat(SdlGamepad.SDL_GetGamepadAxis((SDL_Gamepad)this.ptrGamepad, (int)2))));
        state.setAxis(GamepadInputs.RIGHT_STICK_AXIS_UP, SDL3GamepadDriver.negativeAxis(SDL3GamepadDriver.mapShortToFloat(SdlGamepad.SDL_GetGamepadAxis((SDL_Gamepad)this.ptrGamepad, (int)3))));
        state.setAxis(GamepadInputs.RIGHT_STICK_AXIS_DOWN, SDL3GamepadDriver.positiveAxis(SDL3GamepadDriver.mapShortToFloat(SdlGamepad.SDL_GetGamepadAxis((SDL_Gamepad)this.ptrGamepad, (int)3))));
        state.setAxis(GamepadInputs.LEFT_TRIGGER_AXIS, SDL3GamepadDriver.mapShortToFloat(SdlGamepad.SDL_GetGamepadAxis((SDL_Gamepad)this.ptrGamepad, (int)4)));
        state.setAxis(GamepadInputs.RIGHT_TRIGGER_AXIS, SDL3GamepadDriver.mapShortToFloat(SdlGamepad.SDL_GetGamepadAxis((SDL_Gamepad)this.ptrGamepad, (int)5)));
        state.setButton(GamepadInputs.SOUTH_BUTTON, SdlGamepad.SDL_GetGamepadButton((SDL_Gamepad)this.ptrGamepad, (int)0) == 1);
        state.setButton(GamepadInputs.EAST_BUTTON, SdlGamepad.SDL_GetGamepadButton((SDL_Gamepad)this.ptrGamepad, (int)1) == 1);
        state.setButton(GamepadInputs.WEST_BUTTON, SdlGamepad.SDL_GetGamepadButton((SDL_Gamepad)this.ptrGamepad, (int)2) == 1);
        state.setButton(GamepadInputs.NORTH_BUTTON, SdlGamepad.SDL_GetGamepadButton((SDL_Gamepad)this.ptrGamepad, (int)3) == 1);
        state.setButton(GamepadInputs.LEFT_SHOULDER_BUTTON, SdlGamepad.SDL_GetGamepadButton((SDL_Gamepad)this.ptrGamepad, (int)9) == 1);
        state.setButton(GamepadInputs.RIGHT_SHOULDER_BUTTON, SdlGamepad.SDL_GetGamepadButton((SDL_Gamepad)this.ptrGamepad, (int)10) == 1);
        state.setButton(GamepadInputs.BACK_BUTTON, SdlGamepad.SDL_GetGamepadButton((SDL_Gamepad)this.ptrGamepad, (int)4) == 1);
        state.setButton(GamepadInputs.START_BUTTON, SdlGamepad.SDL_GetGamepadButton((SDL_Gamepad)this.ptrGamepad, (int)6) == 1);
        state.setButton(GamepadInputs.GUIDE_BUTTON, SdlGamepad.SDL_GetGamepadButton((SDL_Gamepad)this.ptrGamepad, (int)5) == 1);
        state.setButton(GamepadInputs.DPAD_UP_BUTTON, SdlGamepad.SDL_GetGamepadButton((SDL_Gamepad)this.ptrGamepad, (int)11) == 1);
        state.setButton(GamepadInputs.DPAD_DOWN_BUTTON, SdlGamepad.SDL_GetGamepadButton((SDL_Gamepad)this.ptrGamepad, (int)12) == 1);
        state.setButton(GamepadInputs.DPAD_LEFT_BUTTON, SdlGamepad.SDL_GetGamepadButton((SDL_Gamepad)this.ptrGamepad, (int)13) == 1);
        state.setButton(GamepadInputs.DPAD_RIGHT_BUTTON, SdlGamepad.SDL_GetGamepadButton((SDL_Gamepad)this.ptrGamepad, (int)14) == 1);
        state.setButton(GamepadInputs.LEFT_STICK_BUTTON, SdlGamepad.SDL_GetGamepadButton((SDL_Gamepad)this.ptrGamepad, (int)7) == 1);
        state.setButton(GamepadInputs.RIGHT_STICK_BUTTON, SdlGamepad.SDL_GetGamepadButton((SDL_Gamepad)this.ptrGamepad, (int)8) == 1);
        state.setButton(GamepadInputs.MISC_1_BUTTON, SdlGamepad.SDL_GetGamepadButton((SDL_Gamepad)this.ptrGamepad, (int)15) == 1);
        state.setButton(GamepadInputs.MISC_2_BUTTON, SdlGamepad.SDL_GetGamepadButton((SDL_Gamepad)this.ptrGamepad, (int)21) == 1);
        state.setButton(GamepadInputs.MISC_3_BUTTON, SdlGamepad.SDL_GetGamepadButton((SDL_Gamepad)this.ptrGamepad, (int)22) == 1);
        state.setButton(GamepadInputs.MISC_4_BUTTON, SdlGamepad.SDL_GetGamepadButton((SDL_Gamepad)this.ptrGamepad, (int)23) == 1);
        state.setButton(GamepadInputs.MISC_5_BUTTON, SdlGamepad.SDL_GetGamepadButton((SDL_Gamepad)this.ptrGamepad, (int)24) == 1);
        state.setButton(GamepadInputs.MISC_6_BUTTON, SdlGamepad.SDL_GetGamepadButton((SDL_Gamepad)this.ptrGamepad, (int)25) == 1);
        state.setButton(GamepadInputs.LEFT_PADDLE_1_BUTTON, SdlGamepad.SDL_GetGamepadButton((SDL_Gamepad)this.ptrGamepad, (int)17) == 1);
        state.setButton(GamepadInputs.LEFT_PADDLE_2_BUTTON, SdlGamepad.SDL_GetGamepadButton((SDL_Gamepad)this.ptrGamepad, (int)19) == 1);
        state.setButton(GamepadInputs.RIGHT_PADDLE_1_BUTTON, SdlGamepad.SDL_GetGamepadButton((SDL_Gamepad)this.ptrGamepad, (int)16) == 1);
        state.setButton(GamepadInputs.RIGHT_PADDLE_2_BUTTON, SdlGamepad.SDL_GetGamepadButton((SDL_Gamepad)this.ptrGamepad, (int)18) == 1);
        state.setButton(GamepadInputs.TOUCHPAD_BUTTON, SdlGamepad.SDL_GetGamepadButton((SDL_Gamepad)this.ptrGamepad, (int)20) == 1);
        this.controller.input().orElseThrow().pushState(state);
    }

    private void updateRumble() {
        Optional<Record> stateOpt;
        if (this.isRumbleSupported) {
            stateOpt = this.controller.rumble().orElseThrow().consumeRumble();
            stateOpt.ifPresent(state -> {
                if (SdlGamepad.SDL_RumbleGamepad((SDL_Gamepad)this.ptrGamepad, (short)((short)(state.strong() * 65535.0f)), (short)((short)(state.weak() * 65535.0f)), (int)5000) != 0) {
                    CUtil.LOGGER.error("Could not rumble gamepad: {}", (Object)SdlError.SDL_GetError());
                }
            });
        }
        if (this.isTriggerRumbleSupported) {
            stateOpt = this.controller.triggerRumble().orElseThrow().consumeTriggerRumble();
            stateOpt.ifPresent(state -> {
                if (SdlGamepad.SDL_RumbleGamepadTriggers((SDL_Gamepad)this.ptrGamepad, (short)((short)(state.left() * 65535.0f)), (short)((short)(state.right() * 65535.0f)), (int)0) != 0) {
                    CUtil.LOGGER.error("Could not rumble triggers gamepad: {}", (Object)SdlError.SDL_GetError());
                }
            });
        }
    }

    private void updateGyro() {
        if (!this.isGryoSupported) {
            return;
        }
        float[] gyro = new float[3];
        try (Memory memory = new Memory((long)(gyro.length * 4));){
            if (SdlGamepad.SDL_GetGamepadSensorData((SDL_Gamepad)this.ptrGamepad, (int)2, (Pointer)memory, (int)3) == 0) {
                memory.read(0L, gyro, 0, gyro.length);
                this.controller.gyro().orElseThrow().setState(new GyroState(gyro[0], gyro[1], gyro[2]));
            } else {
                CUtil.LOGGER.error("Could not get gyro data: {}", (Object)SdlError.SDL_GetError());
            }
        }
    }

    private void updateTouchpad() {
        if (this.numTouchpads == 0) {
            return;
        }
        ArrayList<TouchpadState.Finger> fingers = new ArrayList<TouchpadState.Finger>();
        for (int finger = 0; finger < this.maxTouchpadFingers; ++finger) {
            ByteByReference fingerState = new ByteByReference();
            FloatByReference x = new FloatByReference();
            FloatByReference y = new FloatByReference();
            FloatByReference pressure = new FloatByReference();
            if (SdlGamepad.SDL_GetGamepadTouchpadFinger((SDL_Gamepad)this.ptrGamepad, (int)0, (int)finger, (ByteByReference)fingerState, (FloatByReference)x, (FloatByReference)y, (FloatByReference)pressure) != 0) {
                CUtil.LOGGER.error("Failed to fetch touchpad finger: {}", (Object)SdlError.SDL_GetError());
                continue;
            }
            if (fingerState.getValue() != 1) continue;
            fingers.add(new TouchpadState.Finger((Vector2fc)new Vector2f(x.getValue(), y.getValue()), pressure.getValue()));
        }
        this.controller.touchpad().orElseThrow().pushFingers(fingers);
    }

    private void updateBatteryLevel() {
        IntByReference percent = new IntByReference();
        int powerState = SdlGamepad.SDL_GetGamepadPowerInfo((SDL_Gamepad)this.ptrGamepad, (IntByReference)percent);
        Record level = switch (powerState) {
            case -1, 0 -> new PowerState.Unknown();
            case 1 -> new PowerState.Depleting(percent.getValue());
            case 2 -> new PowerState.WiredOnly();
            case 3 -> new PowerState.Charging(percent.getValue());
            case 4 -> new PowerState.Full();
            default -> throw new IllegalStateException("Unexpected value");
        };
        this.controller.batteryLevel().orElseThrow().setBatteryLevel((PowerState)((Object)level));
    }

    private void updateDualSense() {
        this.controller.dualSense().ifPresent(ds -> {
            DS5EffectsState.ByValue effectsState = new DS5EffectsState.ByValue();
            boolean somethingHappened = false;
            if (ds.consumeMuteLightDirty()) {
                somethingHappened = true;
                effectsState.ucEnableBits2 = (byte)(effectsState.ucEnableBits2 | 1);
                if (ds.getMuteLight()) {
                    effectsState.ucMicLightMode = 1;
                }
            }
            if (somethingHappened) {
                effectsState.write();
                SdlGamepad.SDL_SendGamepadEffect((SDL_Gamepad)this.ptrGamepad, (Pointer)effectsState.getPointer(), (int)Native.getNativeSize(DS5EffectsState.ByValue.class));
            }
        });
    }

    private void updateHDHaptic() {
        for (int i = 0; i < this.dualsenseAudioHandles.size(); ++i) {
            AudioStreamHandle handle = this.dualsenseAudioHandles.get(i);
            if (handle.isTimedOut()) {
                handle.close();
                this.dualsenseAudioHandles.remove(handle);
                continue;
            }
            handle.tick();
        }
    }

    private void playHaptic(HapticBufferLibrary.HapticBuffer sound) {
        if (this.ptrGamepad == null || this.dualsenseAudioDev == null || this.dualsenseAudioSpec == null) {
            return;
        }
        SDL_AudioSpec spec = new SDL_AudioSpec();
        spec.channels = sound.format().getChannels();
        spec.freq = (int)sound.format().getSampleRate();
        int ss = sound.format().getSampleSizeInBits();
        int byteSs = ss / 8;
        AudioFormat.Encoding encoding = sound.format().getEncoding();
        if (ss == 8) {
            if (encoding == AudioFormat.Encoding.PCM_SIGNED) {
                spec.format = new SDL_AudioFormat(32776L);
            } else if (encoding == AudioFormat.Encoding.PCM_UNSIGNED) {
                spec.format = new SDL_AudioFormat(8L);
            }
        } else if (sound.format().isBigEndian()) {
            SDL3GamepadDriver.audioFmtEndian(spec, ss, encoding, 36880, 36896, 37152);
        } else {
            SDL3GamepadDriver.audioFmtEndian(spec, ss, encoding, 32784, 32800, 33056);
        }
        if (spec.format == null) {
            throw new IllegalStateException("Unsupported format");
        }
        AudioStreamHandle handle = null;
        for (AudioStreamHandle stream : this.dualsenseAudioHandles) {
            SDL_AudioSpec streamSpec = stream.getSpec();
            if (streamSpec.format.intValue() != spec.format.intValue() || streamSpec.freq != spec.freq || streamSpec.channels != spec.channels || stream.isInUse()) continue;
            handle = stream;
            break;
        }
        int length = sound.audio().length / spec.freq / spec.channels / byteSs * 20;
        if (handle != null) {
            handle.queueAudio(sound.audio(), length);
        } else {
            if (this.dualsenseAudioHandles.size() >= 16) {
                this.dualsenseAudioHandles.remove(0).close();
            }
            AudioStreamHandle newHandle = AudioStreamHandle.createWithAudio(this.dualsenseAudioDev, spec, this.dualsenseAudioSpec, sound.audio(), length);
            this.dualsenseAudioHandles.add(newHandle);
        }
    }

    private static void audioFmtEndian(SDL_AudioSpec spec, int ss, AudioFormat.Encoding encoding, int signed16, int signed32, int float32) {
        if (ss == 16) {
            if (encoding == AudioFormat.Encoding.PCM_SIGNED) {
                spec.format = new SDL_AudioFormat((long)signed16);
            }
        } else if (ss == 32) {
            if (encoding == AudioFormat.Encoding.PCM_SIGNED) {
                spec.format = new SDL_AudioFormat((long)signed32);
            } else if (encoding == AudioFormat.Encoding.PCM_FLOAT) {
                spec.format = new SDL_AudioFormat((long)float32);
            }
        }
    }

    private static float positiveAxis(float value) {
        return value < 0.0f ? 0.0f : value;
    }

    private static float negativeAxis(float value) {
        return value > 0.0f ? 0.0f : -value;
    }

    private static float mapShortToFloat(short value) {
        return class_3532.method_37958((float)value, (float)-32768.0f, (float)0.0f, (float)-1.0f, (float)0.0f) + class_3532.method_37958((float)value, (float)0.0f, (float)32767.0f, (float)0.0f, (float)1.0f);
    }

    private static class AudioStreamHandle {
        private int streamLastPlayed;
        private final SDL_AudioStream stream;
        private final SDL_AudioSpec spec;

        private AudioStreamHandle(SDL_AudioStream stream, SDL_AudioSpec spec) {
            this.stream = stream;
            this.spec = spec;
            this.streamLastPlayed = 0;
        }

        public void queueAudio(byte[] audio, int tickLength) {
            try (Memory memory = new Memory((long)audio.length);){
                memory.write(0L, audio, 0, audio.length);
                SdlAudio.SDL_PutAudioStreamData((SDL_AudioStream)this.stream, (Pointer)memory, (int)audio.length);
                this.streamLastPlayed = Math.min(0, this.streamLastPlayed);
                this.streamLastPlayed -= tickLength;
            }
        }

        public SDL_AudioSpec getSpec() {
            return this.spec;
        }

        public boolean isInUse() {
            return this.streamLastPlayed < 0;
        }

        public boolean isTimedOut() {
            return this.streamLastPlayed >= 360000;
        }

        public void tick() {
            ++this.streamLastPlayed;
        }

        public void close() {
            SdlAudio.SDL_DestroyAudioStream((SDL_AudioStream)this.stream);
        }

        public static AudioStreamHandle createWithAudio(SDL_AudioDeviceID device, SDL_AudioSpec audioSpec, SDL_AudioSpec devSpec, byte[] audio, int tickLength) {
            SDL_AudioStream stream = SdlAudio.SDL_CreateAudioStream((SDL_AudioSpec)audioSpec, (SDL_AudioSpec)devSpec);
            SdlAudio.SDL_BindAudioStream((SDL_AudioDeviceID)device, (SDL_AudioStream)stream);
            AudioStreamHandle handle = new AudioStreamHandle(stream, audioSpec);
            handle.queueAudio(audio, tickLength);
            return handle;
        }

        public static AudioStreamHandle createWithInitialTimeout(SDL_AudioDeviceID device, SDL_AudioSpec srcSpec, SDL_AudioSpec devSpec) {
            SDL_AudioStream stream = SdlAudio.SDL_CreateAudioStream((SDL_AudioSpec)srcSpec, (SDL_AudioSpec)devSpec);
            SdlAudio.SDL_BindAudioStream((SDL_AudioDeviceID)device, (SDL_AudioStream)stream);
            return new AudioStreamHandle(stream, srcSpec);
        }
    }
}

