/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.driver.glfw;

import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.controller.ControllerInfo;
import dev.isxander.controlify.controller.id.ControllerType;
import dev.isxander.controlify.controller.impl.ControllerStateImpl;
import dev.isxander.controlify.controller.input.HatState;
import dev.isxander.controlify.controller.input.InputComponent;
import dev.isxander.controlify.controller.input.JoystickInputs;
import dev.isxander.controlify.controllermanager.UniqueControllerID;
import dev.isxander.controlify.driver.Driver;
import dev.isxander.controlify.hid.HIDDevice;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.lwjgl.glfw.GLFW;

public class GLFWJoystickDriver
implements Driver {
    private final int jid;
    private final String guid;
    private final String name;
    private final int numButtons;
    private final int numAxes;
    private final int numHats;
    private final ControllerEntity controller;

    public GLFWJoystickDriver(int jid, ControllerType type, String uid, UniqueControllerID ucid, Optional<HIDDevice> hid) {
        this.jid = jid;
        this.guid = GLFW.glfwGetJoystickGUID((int)jid);
        this.name = GLFW.glfwGetJoystickName((int)jid);
        ControllerInfo info = new ControllerInfo(uid, ucid, this.guid, this.name, type, hid);
        this.controller = new ControllerEntity(info);
        GLFWJoystickState testState = this.getJoystickState();
        this.numButtons = testState.buttons().limit();
        this.numAxes = testState.axes().limit();
        this.numHats = testState.hats().limit();
        this.controller.setComponent(new InputComponent(this.controller, this.numButtons, this.numAxes * 2, this.numHats, false, Set.of(), type.mappingId()), InputComponent.ID);
        this.controller.finalise();
    }

    @Override
    public void update(boolean outOfFocus) {
        this.updateInput();
    }

    @Override
    public void close() {
    }

    @Override
    public ControllerEntity getController() {
        return this.controller;
    }

    private void updateInput() {
        int i;
        GLFWJoystickState glfwState = this.getJoystickState();
        ControllerStateImpl state = new ControllerStateImpl();
        for (i = 0; i < this.numAxes; ++i) {
            float axis = glfwState.axes().get(i);
            state.setAxis(JoystickInputs.axis(i, true), Math.max(axis, 0.0f));
            state.setAxis(JoystickInputs.axis(i, false), -Math.min(axis, 0.0f));
        }
        for (i = 0; i < this.numButtons; ++i) {
            state.setButton(JoystickInputs.button(i), glfwState.buttons().get(i) == 1);
        }
        for (i = 0; i < this.numHats; ++i) {
            HatState hatState = switch (glfwState.hats().get(i)) {
                case 0 -> HatState.CENTERED;
                case 1 -> HatState.UP;
                case 2 -> HatState.RIGHT;
                case 4 -> HatState.DOWN;
                case 8 -> HatState.LEFT;
                case 3 -> HatState.RIGHT_UP;
                case 6 -> HatState.RIGHT_DOWN;
                case 9 -> HatState.LEFT_UP;
                case 12 -> HatState.LEFT_DOWN;
                default -> throw new IllegalStateException("Unexpected value: " + glfwState.hats().get(i));
            };
            state.setHat(JoystickInputs.hat(i), hatState);
        }
        this.controller.input().orElseThrow().pushState(state);
    }

    private GLFWJoystickState getJoystickState() {
        ByteBuffer buttonsBuf = GLFW.glfwGetJoystickButtons((int)this.jid);
        FloatBuffer axesBuf = GLFW.glfwGetJoystickAxes((int)this.jid);
        ByteBuffer hatsBuf = GLFW.glfwGetJoystickHats((int)this.jid);
        Validate.notNull((Object)buttonsBuf, (String)"Could not fetch buttons state for joystick", (Object[])new Object[0]);
        Validate.notNull((Object)axesBuf, (String)"Could not fetch axes state for joystick", (Object[])new Object[0]);
        Validate.notNull((Object)hatsBuf, (String)"Could not fetch  hat state for joystick", (Object[])new Object[0]);
        return new GLFWJoystickState(buttonsBuf, axesBuf, hatsBuf);
    }

    private record GLFWJoystickState(ByteBuffer buttons, FloatBuffer axes, ByteBuffer hats) {
    }
}

