/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.driver;

import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.config.ControlifyConfig;
import dev.isxander.controlify.gui.screen.DownloadingSDLScreen;
import dev.isxander.controlify.platform.main.PlatformMainUtil;
import dev.isxander.controlify.utils.CUtil;
import dev.isxander.controlify.utils.TrackingBodySubscriber;
import dev.isxander.controlify.utils.TrackingConsumer;
import dev.isxander.sdl3java.api.SdlInit;
import dev.isxander.sdl3java.api.error.SdlError;
import dev.isxander.sdl3java.api.hints.SdlHints;
import dev.isxander.sdl3java.jna.SdlNativeLibraryLoader;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_156;
import net.minecraft.class_310;
import net.minecraft.class_437;
import org.apache.commons.codec.digest.DigestUtils;

public class SDL3NativesManager {
    private static final String SDL3_VERSION = "3.6896c4c";
    private static final Map<Target, NativeFileInfo> NATIVE_LIBRARIES = Map.of(new Target(class_156.class_158.field_1133, true, false), new NativeFileInfo("win32-x86-64", "windows64", "dll"), new Target(class_156.class_158.field_1133, false, false), new NativeFileInfo("win32-x86", "window32", "dll"), new Target(class_156.class_158.field_1135, true, false), new NativeFileInfo("linux-x86-64", "linux64", "so"), new Target(class_156.class_158.field_1137, true, false), new NativeFileInfo("darwin-x86-64", "macos-x86_64", "dylib"), new Target(class_156.class_158.field_1137, true, true), new NativeFileInfo("darwin-aarch64", "macos-aarch64", "dylib"));
    private static final String NATIVE_LIBRARY_URL = "https://maven.isxander.dev/releases/dev/isxander/libsdl4j-natives/%s/".formatted("3.6896c4c");
    private static boolean loaded = false;
    private static boolean attemptedLoad = false;
    private static CompletableFuture<Boolean> initFuture;

    public static CompletableFuture<Boolean> maybeLoad() {
        if (initFuture != null) {
            return initFuture;
        }
        if (!Controlify.instance().config().globalSettings().loadVibrationNatives) {
            initFuture = CompletableFuture.completedFuture(false);
            return initFuture;
        }
        if (attemptedLoad) {
            initFuture = CompletableFuture.completedFuture(loaded);
            return initFuture;
        }
        attemptedLoad = true;
        if (SDL3NativesManager.tryOfflineLoadAndStart()) {
            initFuture = CompletableFuture.completedFuture(true);
            return initFuture;
        }
        if (!SDL3NativesManager.isSupportedOnThisPlatform()) {
            CUtil.LOGGER.warn("No native library for current platform, skipping SDL3 load");
            initFuture = CompletableFuture.completedFuture(false);
            return initFuture;
        }
        Path nativesFolder = SDL3NativesManager.getNativesFolderPath();
        Path localLibraryPath = nativesFolder.resolve(Target.CURRENT.getArtifactName());
        Path checksumPath = nativesFolder.resolve(Target.CURRENT.getArtifactMD5Name());
        if (Files.exists(localLibraryPath, new LinkOption[0])) {
            if (Files.notExists(checksumPath, new LinkOption[0])) {
                CUtil.LOGGER.info("Downloading checksum for existing SDL natives");
                SDL3NativesManager.downloadChecksum(checksumPath);
            }
            if (SDL3NativesManager.verifyMd5(localLibraryPath, checksumPath, true) && SDL3NativesManager.loadAndStart(localLibraryPath)) {
                initFuture = CompletableFuture.completedFuture(true);
                return initFuture;
            }
            CUtil.LOGGER.warn("Failed to load SDL3 from local file, attempting to re-download");
        }
        initFuture = SDL3NativesManager.downloadAndStart(localLibraryPath);
        return initFuture;
    }

    public static boolean tryOfflineLoadAndStart() {
        if (initFuture != null) {
            throw new IllegalStateException("Tried to start offline mode but initialization already in progress.");
        }
        try {
            SdlNativeLibraryLoader.loadLibSDL3FromFilePathNow((String)"SDL3");
        }
        catch (UnsatisfiedLinkError e) {
            return false;
        }
        initFuture = new CompletableFuture();
        try {
            SDL3NativesManager.startSDL3();
            loaded = true;
            initFuture.complete(true);
        }
        catch (Throwable t) {
            CUtil.LOGGER.error("Failed to start SDL3", t);
            initFuture.complete(false);
            return false;
        }
        return true;
    }

    private static boolean loadAndStart(Path localLibraryPath) {
        try {
            SdlNativeLibraryLoader.loadLibSDL3FromFilePathNow((String)localLibraryPath.toAbsolutePath().toString());
            SDL3NativesManager.startSDL3();
            loaded = true;
            return true;
        }
        catch (Throwable e) {
            CUtil.LOGGER.error("Failed to start SDL3", e);
            return false;
        }
    }

    private static void startSDL3() {
        SdlHints.SDL_SetHint((String)"SDL_JOYSTICK_HIDAPI_PS3", (String)"1");
        SdlHints.SDL_SetHint((String)"SDL_JOYSTICK_HIDAPI_PS4_RUMBLE", (String)"1");
        SdlHints.SDL_SetHint((String)"SDL_JOYSTICK_HIDAPI_STEAMDECK", (String)"1");
        if (SdlInit.SDL_Init((int)25104) != 0) {
            CUtil.LOGGER.error("Failed to initialise SDL3: " + SdlError.SDL_GetError());
            throw new RuntimeException("Failed to initialise SDL3: " + SdlError.SDL_GetError());
        }
        CUtil.LOGGER.info("Initialised SDL4j {}", (Object)SDL3_VERSION);
    }

    private static CompletableFuture<Boolean> downloadAndStart(Path localLibraryPath) {
        return ((CompletableFuture)SDL3NativesManager.downloadLibrary(localLibraryPath.getParent()).thenCompose(success -> {
            if (!success.booleanValue()) {
                return CompletableFuture.completedFuture(false);
            }
            return CompletableFuture.completedFuture(SDL3NativesManager.loadAndStart(localLibraryPath));
        })).thenCompose(success -> class_310.method_1551().method_5385(() -> success));
    }

    private static CompletableFuture<Boolean> downloadLibrary(Path targetFolder) {
        System.out.println("starting download");
        String artifactName = Target.CURRENT.getArtifactName();
        String md5Name = Target.CURRENT.getArtifactMD5Name();
        Path artifactPath = targetFolder.resolve(artifactName);
        Path md5Path = targetFolder.resolve(md5Name);
        try {
            Files.deleteIfExists(artifactPath);
            Files.deleteIfExists(md5Path);
            Files.createDirectories(targetFolder, new FileAttribute[0]);
            Files.createFile(artifactPath, new FileAttribute[0]);
            Files.createFile(md5Path, new FileAttribute[0]);
        }
        catch (Exception e) {
            CUtil.LOGGER.error("Failed to delete existing SDL3 native library file", (Throwable)e);
            return CompletableFuture.completedFuture(false);
        }
        String url = NATIVE_LIBRARY_URL + artifactName;
        String md5Url = NATIVE_LIBRARY_URL + md5Name;
        HttpClient httpClient = HttpClient.newHttpClient();
        HttpRequest libRequest = HttpRequest.newBuilder(URI.create(url)).build();
        HttpRequest hashRequest = HttpRequest.newBuilder(URI.create(md5Url)).build();
        class_310 minecraft = class_310.method_1551();
        DownloadingSDLScreen downloadScreen = new DownloadingSDLScreen(minecraft.field_1755, 0L, artifactPath);
        minecraft.method_1507((class_437)downloadScreen);
        CompletableFuture<?> libFuture = SDL3NativesManager.downloadTracked(httpClient, libRequest, downloadScreen, targetFolder, minecraft);
        CompletableFuture<?> hashFuture = SDL3NativesManager.downloadTracked(httpClient, hashRequest, downloadScreen, targetFolder, minecraft);
        return CompletableFuture.allOf(libFuture, hashFuture).handle((response, throwable) -> {
            if (throwable != null) {
                CUtil.LOGGER.error("Failed to download SDL3 native library", throwable);
                return false;
            }
            CUtil.LOGGER.debug("Finished downloading SDL3 native library");
            minecraft.execute(downloadScreen::finishDownload);
            return SDL3NativesManager.verifyMd5(artifactPath, md5Path, true);
        });
    }

    private static boolean verifyMd5(Path filePath, Path md5Path, boolean deleteOnFail) {
        try {
            String fileMd5 = DigestUtils.md5Hex((byte[])Files.readAllBytes(filePath));
            String checksum = Files.readString(md5Path);
            if (!fileMd5.equals(checksum)) {
                throw new Exception("Checksum did not match");
            }
        }
        catch (Exception e) {
            CUtil.LOGGER.error("Failed to verify checksum for " + String.valueOf(filePath), (Throwable)e);
            if (deleteOnFail) {
                try {
                    Files.deleteIfExists(md5Path);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
            return false;
        }
        return true;
    }

    private static CompletableFuture<?> downloadTracked(HttpClient client, HttpRequest request, DownloadingSDLScreen downloadScreen, Path folder, class_310 minecraft) {
        return client.sendAsync(request, TrackingBodySubscriber.bodyHandler(HttpResponse.BodyHandlers.ofFileDownload(folder, StandardOpenOption.WRITE), new TrackingConsumer(downloadScreen::increaseTotal, (received, total) -> downloadScreen.updateDownloadProgress((long)received), error -> {
            if (error.isPresent()) {
                CUtil.LOGGER.error("Failed to download SDL3 native library", (Throwable)error.get());
                minecraft.execute(() -> downloadScreen.failDownload((Throwable)error.get()));
            }
        })));
    }

    private static void downloadChecksum(Path checksumPath) {
        try {
            Path nativesFolder = checksumPath.getParent();
            Files.deleteIfExists(checksumPath);
            Files.createDirectories(nativesFolder, new FileAttribute[0]);
            Files.createFile(checksumPath, new FileAttribute[0]);
            HttpClient client = HttpClient.newHttpClient();
            HttpRequest request = HttpRequest.newBuilder(URI.create(NATIVE_LIBRARY_URL + Target.CURRENT.getArtifactMD5Name())).build();
            client.send(request, HttpResponse.BodyHandlers.ofFileDownload(nativesFolder, StandardOpenOption.WRITE));
        }
        catch (Exception e) {
            CUtil.LOGGER.error("Failed to download checksum", (Throwable)e);
        }
    }

    public static boolean isLoaded() {
        return loaded;
    }

    public static boolean hasAttemptedLoad() {
        return attemptedLoad;
    }

    public static boolean isSupportedOnThisPlatform() {
        return Target.CURRENT.hasNativeLibrary();
    }

    private static Path getNativesFolderPath() {
        Path nativesFolderPath = PlatformMainUtil.getGameDir();
        ControlifyConfig config = Controlify.instance().config();
        String customPath = config.globalSettings().customVibrationNativesPath;
        if (!customPath.isEmpty()) {
            try {
                nativesFolderPath = Path.of(customPath, new String[0]);
            }
            catch (InvalidPathException e) {
                CUtil.LOGGER.error("Invalid custom SDL3 native library path. Using default and resetting custom path.", (Throwable)e);
                config.globalSettings().customVibrationNativesPath = "";
                config.save();
            }
        }
        return nativesFolderPath.resolve("controlify-natives");
    }

    public record Target(class_156.class_158 os, boolean is64Bit, boolean isARM) {
        public static final Target CURRENT = (Target)class_156.method_656(() -> {
            class_156.class_158 os = class_156.method_668();
            String arch = System.getProperty("os.arch");
            boolean is64bit = arch.contains("64");
            boolean isARM = arch.contains("arm") || arch.contains("aarch");
            return new Target(os, is64bit, isARM);
        });

        public boolean hasNativeLibrary() {
            return NATIVE_LIBRARIES.containsKey(this);
        }

        public String getArtifactName() {
            NativeFileInfo file = NATIVE_LIBRARIES.get(this);
            return "libsdl4j-natives-3.6896c4c-" + file.downloadSuffix + "." + file.fileExtension;
        }

        public String getArtifactMD5Name() {
            return this.getArtifactName() + ".md5";
        }

        public boolean isMacArm() {
            return this.os == class_156.class_158.field_1137 && this.isARM;
        }

        public String formatted() {
            return this.os().name() + " 64bit=" + this.is64Bit() + ";isARM=" + this.isARM();
        }
    }

    public record NativeFileInfo(String folderName, String downloadSuffix, String fileExtension) {
        public Path getNativePath() {
            return this.getSearchPath().resolve(this.folderName).resolve("SDL3." + this.fileExtension);
        }

        public Path getSearchPath() {
            return PlatformMainUtil.getGameDir().resolve("controlify-natives").resolve(SDL3NativesManager.SDL3_VERSION);
        }
    }
}

