/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.debug;

import dev.isxander.controlify.platform.main.PlatformMainUtil;
import dev.isxander.controlify.utils.CUtil;
import java.util.ArrayList;
import java.util.List;

public class DebugProperties {
    private static final List<DebugProperty> properties = new ArrayList<DebugProperty>();
    public static final boolean DEBUG_LOGGING = DebugProperties.boolProp("controlify.debug.logging", false, true);
    public static final boolean PRINT_VID_PID = DebugProperties.boolProp("controlify.debug.print_vid_pid", false, true);
    public static final boolean DEBUG_SNAPPING = DebugProperties.boolProp("controlify.debug.snapping", false, false);
    public static final boolean FORCE_JOYSTICK = DebugProperties.boolProp("controlify.debug.force_joystick", false, false);
    public static final boolean PRINT_DRIVER = DebugProperties.boolProp("controlify.debug.print_driver", true, true);
    public static final boolean INIT_DUMP = DebugProperties.boolProp("controlify.debug.init_dump", false, true);

    public static void printProperties() {
        if (properties.stream().noneMatch(prop -> prop.enabled() != prop.def())) {
            return;
        }
        String header = "*----------------- Controlify Debug Properties -----------------*";
        CUtil.LOGGER.error(header);
        int maxWidth = properties.stream().mapToInt(prop -> prop.name().length()).max().orElse(0);
        for (DebugProperty prop2 : properties) {
            Object line = "| %s%s = %s".formatted(prop2.name(), " ".repeat(maxWidth - prop2.name().length()), prop2.enabled());
            line = (String)line + " ".repeat(header.length() - ((String)line).length() - 1) + "|";
            CUtil.LOGGER.error((String)line);
        }
        CUtil.LOGGER.error("*---------------------------------------------------------------*");
    }

    private static boolean boolProp(String name, boolean defProd, boolean defDev) {
        boolean def = PlatformMainUtil.isDevEnv() ? defDev : defProd;
        boolean enabled = Boolean.parseBoolean(System.getProperty(name, Boolean.toString(def)));
        properties.add(new DebugProperty(name, enabled, def));
        return enabled;
    }

    private record DebugProperty(String name, boolean enabled, boolean def) {
    }
}

