/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.controllermanager;

import com.google.common.io.ByteStreams;
import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.controller.id.ControllerType;
import dev.isxander.controlify.controllermanager.AbstractControllerManager;
import dev.isxander.controlify.controllermanager.UniqueControllerID;
import dev.isxander.controlify.debug.DebugProperties;
import dev.isxander.controlify.driver.SDL3NativesManager;
import dev.isxander.controlify.driver.sdl.SDL3GamepadDriver;
import dev.isxander.controlify.driver.sdl.SDL3JoystickDriver;
import dev.isxander.controlify.hid.ControllerHIDService;
import dev.isxander.controlify.hid.HIDDevice;
import dev.isxander.controlify.hid.HIDIdentifier;
import dev.isxander.controlify.utils.CUtil;
import dev.isxander.controlify.utils.ControllerUtils;
import dev.isxander.sdl3java.api.error.SdlError;
import dev.isxander.sdl3java.api.events.SDL_EventFilter;
import dev.isxander.sdl3java.api.events.SdlEvents;
import dev.isxander.sdl3java.api.events.events.SDL_Event;
import dev.isxander.sdl3java.api.gamepad.SdlGamepad;
import dev.isxander.sdl3java.api.iostream.SDL_IOStream;
import dev.isxander.sdl3java.api.iostream.SdlIOStream;
import dev.isxander.sdl3java.api.joystick.SDL_JoystickGUID;
import dev.isxander.sdl3java.api.joystick.SDL_JoystickID;
import dev.isxander.sdl3java.api.joystick.SdlJoystick;
import dev.isxander.sdl3java.jna.size_t;
import java.io.InputStream;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_3298;
import net.minecraft.class_5912;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;

public class SDLControllerManager
extends AbstractControllerManager {
    private SDL_Event event = new SDL_Event();
    private final EventFilter eventFilter;

    public SDLControllerManager() {
        Validate.isTrue((boolean)SDL3NativesManager.isLoaded(), (String)"SDL3 natives must be loaded before creating SDLControllerManager", (Object[])new Object[0]);
        this.eventFilter = new EventFilter();
        SdlEvents.SDL_SetEventFilter((SDL_EventFilter)this.eventFilter, (Pointer)Pointer.NULL);
    }

    @Override
    public void tick(boolean outOfFocus) {
        super.tick(outOfFocus);
        SdlEvents.SDL_PumpEvents();
        if (this.event == null) {
            CUtil.LOGGER.error("EVENT WAS NULL SOMEHOW!! RECONSTRUCTING");
            this.event = new SDL_Event();
        }
        while (SdlEvents.SDL_PollEvent((SDL_Event)this.event) == 1) {
            switch (this.event.type) {
                case 1541: {
                    SDL_JoystickID jid = this.event.jdevice.which;
                    Validate.notNull((Object)jid, (String)"JID was null", (Object[])new Object[0]);
                    SDLUniqueControllerID ucid = new SDLUniqueControllerID(jid);
                    Optional<ControllerEntity> controllerOpt = this.tryCreate(ucid, SDLControllerManager.fetchTypeFromSDL(jid).orElse(new ControllerHIDService.ControllerHIDInfo(ControllerType.DEFAULT, Optional.empty())));
                    controllerOpt.ifPresent(controller -> ControllerUtils.wrapControllerError(() -> this.onControllerConnected((ControllerEntity)controller, true), "Connecting controller", controller));
                    break;
                }
                case 1542: {
                    SDL_JoystickID jid = this.event.jdevice.which;
                    Validate.notNull((Object)jid, (String)"JID was null", (Object[])new Object[0]);
                    this.getController(new SDLUniqueControllerID(jid)).ifPresentOrElse(this::onControllerRemoved, () -> CUtil.LOGGER.warn("Controller removed but not found: {}", (Object)jid.intValue()));
                }
            }
        }
        SdlGamepad.SDL_UpdateGamepads();
        SdlJoystick.SDL_UpdateJoysticks();
    }

    @Override
    public void discoverControllers() {
        SDL_JoystickID[] joysticks;
        for (SDL_JoystickID jid : joysticks = SdlJoystick.SDL_GetJoysticks()) {
            Optional<ControllerEntity> controllerOpt = this.tryCreate(new SDLUniqueControllerID(jid), SDLControllerManager.fetchTypeFromSDL(jid).orElse(new ControllerHIDService.ControllerHIDInfo(ControllerType.DEFAULT, Optional.empty())));
            controllerOpt.ifPresent(controller -> this.onControllerConnected((ControllerEntity)controller, false));
        }
    }

    @Override
    protected Optional<ControllerEntity> createController(UniqueControllerID ucid, ControllerHIDService.ControllerHIDInfo hidInfo) {
        boolean isGamepad;
        SDL_JoystickID jid = ((SDLUniqueControllerID)ucid).jid;
        Optional<HIDIdentifier> hid = hidInfo.hidDevice().map(HIDDevice::asIdentifier);
        String uid = hidInfo.createControllerUID(this.getControllerCountWithMatchingHID(hid.orElse(null))).orElse("unknown-uid-" + String.valueOf(ucid));
        boolean bl = isGamepad = this.isControllerGamepad(ucid) && !DebugProperties.FORCE_JOYSTICK;
        if (isGamepad) {
            SDL3GamepadDriver driver = new SDL3GamepadDriver(jid, hidInfo.type(), uid, ucid, hidInfo.hidDevice());
            this.addController(ucid, driver.getController(), driver);
            return Optional.of(driver.getController());
        }
        SDL3JoystickDriver driver = new SDL3JoystickDriver(jid, hidInfo.type(), uid, ucid, hidInfo.hidDevice());
        this.addController(ucid, driver.getController(), driver);
        return Optional.of(driver.getController());
    }

    @Override
    public boolean probeConnectedControllers() {
        return SdlJoystick.SDL_GetJoysticks().length > 0;
    }

    @Override
    public boolean isControllerGamepad(UniqueControllerID ucid) {
        SDL_JoystickID jid = ((SDLUniqueControllerID)ucid).jid;
        return SdlGamepad.SDL_IsGamepad((SDL_JoystickID)jid) == 1;
    }

    @Override
    protected String getControllerSystemName(UniqueControllerID ucid) {
        SDL_JoystickID jid = ((SDLUniqueControllerID)ucid).jid;
        return this.isControllerGamepad(ucid) ? SdlGamepad.SDL_GetGamepadInstanceName((SDL_JoystickID)jid) : SdlJoystick.SDL_GetJoystickInstanceName((SDL_JoystickID)jid);
    }

    private Optional<ControllerEntity> getController(UniqueControllerID ucid) {
        return Optional.ofNullable(this.controllersByJid.getOrDefault(ucid, null));
    }

    @Override
    protected void loadGamepadMappings(class_5912 resourceProvider) {
        CUtil.LOGGER.debug("Loading gamepad mappings...");
        Optional resourceOpt = resourceProvider.method_14486(CUtil.rl("controllers/gamecontrollerdb-sdl3.txt"));
        if (resourceOpt.isEmpty()) {
            CUtil.LOGGER.error("Failed to find game controller database.");
            return;
        }
        try (InputStream is = ((class_3298)resourceOpt.get()).method_14482();){
            byte[] bytes = ByteStreams.toByteArray((InputStream)is);
            try (Memory memory = new Memory((long)bytes.length);){
                memory.write(0L, bytes, 0, bytes.length);
                SDL_IOStream stream = SdlIOStream.SDL_IOFromConstMem((Pointer)memory, (size_t)new size_t((long)bytes.length));
                if (stream == null) {
                    throw new IllegalStateException("Failed to open stream");
                }
                int count = SdlGamepad.SDL_AddGamepadMappingsFromIO((SDL_IOStream)stream, (boolean)true);
                if (count < 0) {
                    CUtil.LOGGER.error("Failed to load gamepad mappings: {}", (Object)SdlError.SDL_GetError());
                } else if (count == 0) {
                    CUtil.LOGGER.warn("Successfully applied gamepad mappings but none were found for this platform. Unsupported OS?");
                } else {
                    CUtil.LOGGER.info("Successfully loaded {} gamepad mapping entries!", (Object)count);
                }
            }
        }
        catch (Throwable e) {
            CUtil.LOGGER.error("Failed to load gamepad mappings", e);
        }
    }

    private static Optional<ControllerHIDService.ControllerHIDInfo> fetchTypeFromSDL(SDL_JoystickID jid) {
        short vid = SdlJoystick.SDL_GetJoystickInstanceVendor((SDL_JoystickID)jid);
        short pid = SdlJoystick.SDL_GetJoystickInstanceProduct((SDL_JoystickID)jid);
        SDL_JoystickGUID guid = SdlJoystick.SDL_GetJoystickInstanceGUID((SDL_JoystickID)jid);
        String guidStr = guid.toString();
        if (vid != 0 && pid != 0) {
            CUtil.LOGGER.info("Using SDL to identify controller type.");
            return Optional.of(new ControllerHIDService.ControllerHIDInfo(Controlify.instance().controllerTypeManager().getControllerType(new HIDIdentifier(vid, pid)), Optional.of(new HIDDevice.SDLHidApi(vid, pid, guidStr))));
        }
        return Optional.empty();
    }

    private static class EventFilter
    implements SDL_EventFilter {
        private EventFilter() {
        }

        public int filterEvent(Pointer userdata, SDL_Event event) {
            switch (event.type) {
                case 1541: 
                case 1542: {
                    return 1;
                }
            }
            return 0;
        }
    }

    public record SDLUniqueControllerID(@NotNull SDL_JoystickID jid) implements UniqueControllerID
    {
        @Override
        public boolean equals(Object obj) {
            return obj instanceof SDLUniqueControllerID && ((SDLUniqueControllerID)obj).jid.equals((Object)this.jid);
        }

        @Override
        public String toString() {
            return "SDL-" + this.jid.longValue();
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.jid.longValue());
        }
    }
}

