/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.controllermanager;

import com.google.common.io.ByteStreams;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.controllermanager.AbstractControllerManager;
import dev.isxander.controlify.controllermanager.UniqueControllerID;
import dev.isxander.controlify.debug.DebugProperties;
import dev.isxander.controlify.driver.glfw.GLFWGamepadDriver;
import dev.isxander.controlify.driver.glfw.GLFWJoystickDriver;
import dev.isxander.controlify.hid.ControllerHIDService;
import dev.isxander.controlify.hid.HIDDevice;
import dev.isxander.controlify.hid.HIDIdentifier;
import dev.isxander.controlify.utils.CUtil;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.class_3298;
import net.minecraft.class_5912;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.system.MemoryUtil;

public class GLFWControllerManager
extends AbstractControllerManager {
    public GLFWControllerManager() {
        this.setupCallbacks();
    }

    private void setupCallbacks() {
        GLFW.glfwSetJoystickCallback((jid, event) -> {
            try {
                GLFWUniqueControllerID ucid = new GLFWUniqueControllerID(jid);
                if (event == 262145) {
                    this.tryCreate(ucid, this.controlify.controllerHIDService().fetchType(jid)).ifPresent(controller -> this.onControllerConnected((ControllerEntity)controller, true));
                } else if (event == 262146) {
                    this.getController(ucid).ifPresent(this::onControllerRemoved);
                }
            }
            catch (Throwable e) {
                CUtil.LOGGER.error("Failed to handle controller connect/disconnect event", e);
            }
        });
    }

    @Override
    public void discoverControllers() {
        for (int i = 0; i < 15; ++i) {
            if (!GLFW.glfwJoystickPresent((int)i)) continue;
            GLFWUniqueControllerID ucid = new GLFWUniqueControllerID(i);
            Optional<ControllerEntity> controllerOpt = this.tryCreate(ucid, this.controlify.controllerHIDService().fetchType(i));
            controllerOpt.ifPresent(controller -> this.onControllerConnected((ControllerEntity)controller, false));
        }
    }

    @Override
    protected Optional<ControllerEntity> createController(UniqueControllerID ucid, ControllerHIDService.ControllerHIDInfo hidInfo) {
        boolean isGamepad;
        int jid = ((GLFWUniqueControllerID)ucid).jid;
        Optional<HIDIdentifier> hid = hidInfo.hidDevice().map(HIDDevice::asIdentifier);
        String uid = hidInfo.createControllerUID(this.getControllerCountWithMatchingHID(hid.orElse(null))).orElse("unknown-uid-" + String.valueOf(ucid));
        boolean bl = isGamepad = this.isControllerGamepad(ucid) && !DebugProperties.FORCE_JOYSTICK;
        if (isGamepad) {
            GLFWGamepadDriver driver = new GLFWGamepadDriver(jid, hidInfo.type(), uid, ucid, hidInfo.hidDevice());
            this.addController(ucid, driver.getController(), driver);
            return Optional.of(driver.getController());
        }
        GLFWJoystickDriver driver = new GLFWJoystickDriver(jid, hidInfo.type(), uid, ucid, hidInfo.hidDevice());
        this.addController(ucid, driver.getController(), driver);
        return Optional.of(driver.getController());
    }

    @Override
    public boolean probeConnectedControllers() {
        return GLFWControllerManager.areControllersConnected();
    }

    @Override
    protected void loadGamepadMappings(class_5912 resourceProvider) {
        CUtil.LOGGER.debug("Loading gamepad mappings...");
        Optional resourceOpt = resourceProvider.method_14486(CUtil.rl("controllers/gamecontrollerdb-sdl2.txt"));
        if (resourceOpt.isEmpty()) {
            CUtil.LOGGER.error("Failed to find game controller database.");
            return;
        }
        try (InputStream is = ((class_3298)resourceOpt.get()).method_14482();){
            byte[] bytes = ByteStreams.toByteArray((InputStream)is);
            ByteBuffer buffer = MemoryUtil.memASCIISafe((CharSequence)new String(bytes));
            if (!GLFW.glfwUpdateGamepadMappings((ByteBuffer)buffer)) {
                CUtil.LOGGER.error("Failed to load gamepad mappings: {}", (Object)GLFW.glfwGetError(null));
            }
        }
        catch (Throwable e) {
            CUtil.LOGGER.error("Failed to load gamepad mappings: {}", (Object)e.getMessage());
        }
    }

    private Optional<ControllerEntity> getController(GLFWUniqueControllerID joystickId) {
        return this.controllersByUid.values().stream().filter(controller -> controller.info().ucid().equals(joystickId)).findAny();
    }

    @Override
    public boolean isControllerGamepad(UniqueControllerID ucid) {
        int joystickId = ((GLFWUniqueControllerID)ucid).jid;
        return GLFW.glfwJoystickIsGamepad((int)joystickId);
    }

    @Override
    protected String getControllerSystemName(UniqueControllerID ucid) {
        int joystickId = ((GLFWUniqueControllerID)ucid).jid;
        return this.isControllerGamepad(ucid) ? GLFW.glfwGetGamepadName((int)joystickId) : GLFW.glfwGetJoystickName((int)joystickId);
    }

    public static boolean areControllersConnected() {
        return IntStream.range(0, 16).anyMatch(GLFW::glfwJoystickPresent);
    }

    public record GLFWUniqueControllerID(int jid) implements UniqueControllerID
    {
    }
}

