/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.controllermanager;

import com.google.common.collect.ImmutableList;
import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.api.event.ControlifyEvents;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.controllermanager.ControllerManager;
import dev.isxander.controlify.controllermanager.UniqueControllerID;
import dev.isxander.controlify.driver.Driver;
import dev.isxander.controlify.hid.ControllerHIDService;
import dev.isxander.controlify.hid.HIDDevice;
import dev.isxander.controlify.hid.HIDIdentifier;
import dev.isxander.controlify.utils.CUtil;
import dev.isxander.controlify.utils.ControllerUtils;
import dev.isxander.controlify.utils.DebugLog;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_148;
import net.minecraft.class_310;
import net.minecraft.class_5912;

public abstract class AbstractControllerManager
implements ControllerManager {
    protected final Controlify controlify;
    protected final class_310 minecraft;
    protected final Map<UniqueControllerID, ControllerEntity> controllersByJid = new Object2ObjectOpenHashMap();
    protected final Map<String, ControllerEntity> controllersByUid = new Object2ObjectOpenHashMap();
    protected final Map<String, ControllerHIDService.ControllerHIDInfo> hidInfoByUid = new Object2ObjectOpenHashMap();
    protected final Map<String, Driver> driversByUid = new Object2ObjectOpenHashMap();

    public AbstractControllerManager() {
        this.controlify = Controlify.instance();
        this.minecraft = class_310.method_1551();
        this.loadGamepadMappings((class_5912)this.minecraft.method_1478());
    }

    public Optional<ControllerEntity> tryCreate(UniqueControllerID ucid, ControllerHIDService.ControllerHIDInfo hidInfo) {
        try {
            if (this.controllersByJid.containsKey(ucid)) {
                CUtil.LOGGER.warn("Tried to create controller that already is initialised: {}", (Object)ucid);
                return Optional.empty();
            }
            if (hidInfo.type().dontLoad()) {
                DebugLog.log("Preventing load of controller #" + String.valueOf(ucid) + " because its type prevents loading.", new Object[0]);
                return Optional.empty();
            }
            return this.createController(ucid, hidInfo);
        }
        catch (Throwable e) {
            CUtil.LOGGER.error("Failed to create controller #{}!", (Object)ucid, (Object)e);
            class_128 crashReport = class_128.method_560((Throwable)e, (String)("Creating controller #" + String.valueOf(ucid)));
            class_129 category = crashReport.method_562("Controller Info");
            category.method_578("Unique controller ID", (Object)ucid);
            category.method_578("Controller identification", (Object)hidInfo.type());
            category.method_578("HID path", (Object)hidInfo.hidDevice().map(HIDDevice::path).orElse("N/A"));
            category.method_578("HID service status", (Object)(Controlify.instance().controllerHIDService().isDisabled() ? "Disabled" : "Enabled"));
            category.method_578("System name", (Object)Optional.ofNullable(this.getControllerSystemName(ucid)).orElse("N/A"));
            throw new class_148(crashReport);
        }
    }

    protected abstract Optional<ControllerEntity> createController(UniqueControllerID var1, ControllerHIDService.ControllerHIDInfo var2);

    @Override
    public void tick(boolean outOfFocus) {
        for (Driver driver : this.driversByUid.values()) {
            driver.update(outOfFocus);
            ControlifyEvents.CONTROLLER_STATE_UPDATE.invoke(new ControlifyEvents.ControllerStateUpdate(driver.getController()));
        }
    }

    protected void onControllerConnected(ControllerEntity controller, boolean hotplug) {
        boolean newController = this.controlify.config().loadControllerConfig(controller);
        CUtil.LOGGER.info("Controller connected: {}", (Object)ControllerUtils.createControllerString(controller));
        ControlifyEvents.CONTROLLER_CONNECTED.invoke(new ControlifyEvents.ControllerConnected(controller, hotplug, newController));
    }

    protected void onControllerRemoved(ControllerEntity controller) {
        CUtil.LOGGER.info("Controller disconnected: {}", (Object)ControllerUtils.createControllerString(controller));
        this.removeController(controller.info().uid());
        ControlifyEvents.CONTROLLER_DISCONNECTED.invoke(new ControlifyEvents.ControllerDisconnected(controller));
    }

    @Override
    public Optional<ControllerEntity> reinitController(ControllerEntity controller, ControllerHIDService.ControllerHIDInfo hidInfo) {
        this.onControllerRemoved(controller);
        Optional<ControllerEntity> newController = this.tryCreate(controller.info().ucid(), hidInfo);
        newController.ifPresent(c -> ControllerUtils.wrapControllerError(() -> this.onControllerConnected((ControllerEntity)c, true), "Connecting controller", c));
        return newController;
    }

    protected void addController(UniqueControllerID ucid, ControllerEntity controller, Driver driver) {
        this.controllersByUid.put(controller.info().uid(), controller);
        this.controllersByJid.put(ucid, controller);
        this.driversByUid.put(controller.info().uid(), driver);
    }

    protected void removeController(String uid) {
        ControllerEntity controller = this.controllersByUid.remove(uid);
        this.controllersByJid.remove(controller.info().ucid());
        Optional.ofNullable(this.hidInfoByUid.remove(uid)).ifPresent(this.controlify.controllerHIDService()::unconsumeController);
        this.closeController(uid);
        this.driversByUid.remove(uid);
    }

    @Override
    public void closeController(String uid) {
        this.driversByUid.get(uid).close();
    }

    @Override
    public List<ControllerEntity> getConnectedControllers() {
        return ImmutableList.copyOf(this.controllersByUid.values());
    }

    @Override
    public boolean isControllerConnected(String uid) {
        return this.controllersByUid.containsKey(uid);
    }

    protected int getControllerCountWithMatchingHID(HIDIdentifier hid) {
        return (int)this.controllersByJid.values().stream().filter(c -> c.info().hid().equals(Optional.ofNullable(hid))).count();
    }

    @Override
    public void close() {
        this.driversByUid.values().forEach(Driver::close);
    }

    protected abstract void loadGamepadMappings(class_5912 var1);

    protected abstract String getControllerSystemName(UniqueControllerID var1);
}

