/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.controller.input.mapping;

import dev.isxander.controlify.controller.input.ControllerState;
import dev.isxander.controlify.controller.input.HatState;
import dev.isxander.controlify.controller.input.ModifiableControllerState;
import dev.isxander.controlify.controller.input.mapping.MapType;
import net.minecraft.class_2960;
import net.minecraft.class_3532;

public sealed interface MappingEntry {
    public void apply(ControllerState var1, ModifiableControllerState var2);

    public MapType inputType();

    public MapType outputType();

    public static sealed interface FromNothing
    extends MappingEntry {
        @Override
        default public MapType inputType() {
            return MapType.NOTHING;
        }

        public record ToHat(class_2960 to) implements FromNothing
        {
            @Override
            public void apply(ControllerState oldState, ModifiableControllerState newState) {
                newState.setHat(this.to, HatState.CENTERED);
            }

            @Override
            public MapType outputType() {
                return MapType.HAT;
            }
        }

        public record ToAxis(class_2960 to, float state) implements FromNothing
        {
            @Override
            public void apply(ControllerState oldState, ModifiableControllerState newState) {
                newState.setAxis(this.to, this.state);
            }

            @Override
            public MapType outputType() {
                return MapType.AXIS;
            }
        }

        public record ToButton(class_2960 to, boolean state) implements FromNothing
        {
            @Override
            public void apply(ControllerState oldState, ModifiableControllerState newState) {
                newState.setButton(this.to, this.state);
            }

            @Override
            public MapType outputType() {
                return MapType.BUTTON;
            }
        }
    }

    public static sealed interface FromHat
    extends MappingEntry {

        public record ToHat(class_2960 from, class_2960 to, MapType inputType, MapType outputType) implements FromHat
        {
            public ToHat(class_2960 from, class_2960 to) {
                this(from, to, MapType.HAT, MapType.HAT);
            }

            @Override
            public void apply(ControllerState oldState, ModifiableControllerState newState) {
                newState.setHat(this.to, oldState.getHatState(this.from));
            }
        }

        public record ToAxis(class_2960 from, class_2960 to, HatState targetState, float onState, float offState, MapType inputType, MapType outputType) implements FromHat
        {
            public ToAxis(class_2960 from, class_2960 to, HatState targetState, float onState, float offState) {
                this(from, to, targetState, onState, offState, MapType.HAT, MapType.AXIS);
            }

            @Override
            public void apply(ControllerState oldState, ModifiableControllerState newState) {
                newState.setAxis(this.to, oldState.getHatState(this.from) == this.targetState ? this.onState : this.offState);
            }
        }

        public record ToButton(class_2960 from, class_2960 to, HatState targetState, MapType inputType, MapType outputType) implements FromHat
        {
            public ToButton(class_2960 from, class_2960 to, HatState targetState) {
                this(from, to, targetState, MapType.HAT, MapType.BUTTON);
            }

            @Override
            public void apply(ControllerState oldState, ModifiableControllerState newState) {
                newState.setButton(this.to, oldState.getHatState(this.from) == this.targetState);
            }
        }
    }

    public static sealed interface FromAxis
    extends MappingEntry {

        public record ToHat(class_2960 from, class_2960 to, float threshold, HatState targetState, MapType inputType, MapType outputType) implements FromAxis
        {
            public ToHat(class_2960 from, class_2960 to, float threshold, HatState targetState) {
                this(from, to, threshold, targetState, MapType.AXIS, MapType.HAT);
            }

            @Override
            public void apply(ControllerState oldState, ModifiableControllerState newState) {
                float oldVal = oldState.getAxisState(this.from);
                newState.setHat(this.to, oldVal >= this.threshold ? this.targetState : HatState.CENTERED);
            }
        }

        public record ToAxis(class_2960 from, class_2960 to, float minIn, float minOut, float maxIn, float maxOut, MapType inputType, MapType outputType) implements FromAxis
        {
            public ToAxis(class_2960 from, class_2960 to, float minIn, float minOut, float maxIn, float maxOut) {
                this(from, to, minIn, minOut, maxIn, maxOut, MapType.AXIS, MapType.AXIS);
            }

            @Override
            public void apply(ControllerState oldState, ModifiableControllerState newState) {
                float oldVal = oldState.getAxisState(this.from);
                float newVal = class_3532.method_16439((float)class_3532.method_37960((float)oldVal, (float)this.minIn, (float)this.maxIn), (float)this.minOut, (float)this.maxOut);
                newState.setAxis(this.to, newVal);
            }
        }

        public record ToButton(class_2960 from, class_2960 to, float threshold, MapType inputType, MapType outputType) implements FromAxis
        {
            public ToButton(class_2960 from, class_2960 to, float threshold) {
                this(from, to, threshold, MapType.AXIS, MapType.BUTTON);
            }

            @Override
            public void apply(ControllerState oldState, ModifiableControllerState newState) {
                newState.setButton(this.to, oldState.getAxisState(this.from) >= this.threshold);
            }
        }
    }

    public static sealed interface FromButton
    extends MappingEntry {

        public record ToHat(class_2960 from, class_2960 to, HatState offState, HatState onState, MapType inputType, MapType outputType) implements FromButton
        {
            public ToHat(class_2960 from, class_2960 to, HatState offState, HatState onState) {
                this(from, to, offState, onState, MapType.BUTTON, MapType.HAT);
            }

            @Override
            public void apply(ControllerState oldState, ModifiableControllerState newState) {
                newState.setHat(this.to, oldState.isButtonDown(this.from) ? this.onState : this.offState);
            }
        }

        public record ToAxis(class_2960 from, class_2960 to, float offState, float onState, MapType inputType, MapType outputType) implements FromButton
        {
            public ToAxis(class_2960 from, class_2960 to, float offState, float onState) {
                this(from, to, offState, onState, MapType.BUTTON, MapType.AXIS);
            }

            @Override
            public void apply(ControllerState oldState, ModifiableControllerState newState) {
                newState.setAxis(this.to, oldState.isButtonDown(this.from) ? this.onState : this.offState);
            }
        }

        public record ToButton(class_2960 from, class_2960 to, boolean invert, MapType inputType, MapType outputType) implements FromButton
        {
            public ToButton(class_2960 from, class_2960 to, boolean invert) {
                this(from, to, invert, MapType.BUTTON, MapType.BUTTON);
            }

            @Override
            public void apply(ControllerState oldState, ModifiableControllerState newState) {
                boolean fromState = oldState.isButtonDown(this.from);
                if (this.invert()) {
                    fromState = !fromState;
                }
                newState.setButton(this.to, fromState);
            }
        }
    }
}

