/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.controller.dualsense;

import dev.isxander.controlify.driver.sdl.DualsenseOggAudioStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.sound.sampled.AudioFormat;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5912;

public class HapticBufferLibrary {
    private final Map<class_2960, CompletableFuture<HapticBuffer>> bufferMap = new HashMap<class_2960, CompletableFuture<HapticBuffer>>();
    private final class_5912 resources;
    public static final HapticBufferLibrary INSTANCE = new HapticBufferLibrary((class_5912)class_310.method_1551().method_1478());

    private HapticBufferLibrary(class_5912 resources) {
        this.resources = resources;
    }

    public CompletableFuture<HapticBuffer> getHaptic(class_2960 haptic) {
        return this.bufferMap.computeIfAbsent(haptic, this::createHapticBuffer);
    }

    private CompletableFuture<HapticBuffer> createHapticBuffer(class_2960 haptic) {
        return CompletableFuture.supplyAsync(() -> {
            try (InputStream is = this.resources.open(haptic);){
                HapticBuffer hapticBuffer;
                try (DualsenseOggAudioStream stream = new DualsenseOggAudioStream(is);){
                    ByteBuffer audioBuf = stream.method_59757();
                    byte[] audio = new byte[audioBuf.capacity()];
                    audioBuf.get(audio);
                    hapticBuffer = new HapticBuffer(audio, stream.method_19719());
                }
                return hapticBuffer;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }, class_156.method_18349());
    }

    public record HapticBuffer(byte[] audio, AudioFormat format) {
    }
}

