/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.bindings.defaults;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.api.bind.InputBinding;
import dev.isxander.controlify.bindings.defaults.DefaultBindProvider;
import dev.isxander.controlify.bindings.defaults.LayeredDefaultBindProvider;
import dev.isxander.controlify.bindings.defaults.MapBackedDefaultBindProvider;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.controller.id.ControllerType;
import dev.isxander.controlify.controller.input.InputComponent;
import dev.isxander.controlify.controllermanager.ControllerManager;
import dev.isxander.controlify.platform.client.resource.SimpleControlifyReloadListener;
import dev.isxander.controlify.utils.CUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_7654;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class DefaultBindManager
implements SimpleControlifyReloadListener<Preparations> {
    public static final String DIRECTORY = "controllers/default_bind";
    private static final class_7654 converter = class_7654.method_45114((String)"controllers/default_bind");
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Map<class_2960, DefaultBindProvider> defaultsByNamespace = new HashMap<class_2960, DefaultBindProvider>();

    @Override
    public CompletableFuture<@Nullable Preparations> load(class_3300 manager, class_3695 profiler, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            Map defaultFiles = converter.method_45116(manager);
            HashMap<class_2960, DefaultBindProvider> defaultsByNamespace = new HashMap<class_2960, DefaultBindProvider>();
            class_2960 defaultNamespaceFile = converter.method_45112(ControllerType.DEFAULT.namespace());
            if (!defaultFiles.containsKey(defaultNamespaceFile)) {
                LOGGER.error("No default binds found! Everything will be unbound!");
                return null;
            }
            LayeredDefaultBindProvider defaultNamespaceDefaults = new LayeredDefaultBindProvider((List)this.readDefaults(defaultNamespaceFile, (List)defaultFiles.get(defaultNamespaceFile)).getSecond());
            defaultsByNamespace.put(ControllerType.DEFAULT.namespace(), defaultNamespaceDefaults);
            for (Map.Entry stack : defaultFiles.entrySet()) {
                class_2960 id = (class_2960)stack.getKey();
                List files = (List)stack.getValue();
                if (id.equals((Object)defaultNamespaceFile)) continue;
                Pair<class_2960, List<LayeredDefaultBindProvider.Layer>> defaults = this.readDefaults(id, files);
                ((List)defaults.getSecond()).add(new LayeredDefaultBindProvider.Layer(defaultNamespaceDefaults, false));
                LayeredDefaultBindProvider defaultBindProvider = new LayeredDefaultBindProvider((List)defaults.getSecond());
                defaultsByNamespace.put((class_2960)defaults.getFirst(), defaultBindProvider);
            }
            return new Preparations(defaultsByNamespace);
        }, executor);
    }

    private Pair<class_2960, List<LayeredDefaultBindProvider.Layer>> readDefaults(class_2960 id, List<class_3298> files) {
        ArrayList<LayeredDefaultBindProvider.Layer> defaults = new ArrayList<LayeredDefaultBindProvider.Layer>();
        for (class_3298 resource : files) {
            try {
                BufferedReader reader = resource.method_43039();
                try {
                    JsonElement json = JsonParser.parseReader((Reader)reader);
                    ControllerDefault def = (ControllerDefault)ControllerDefault.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).result().orElseThrow();
                    defaults.add(0, new LayeredDefaultBindProvider.Layer(def.provider(), def.clearBelow()));
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
            catch (IOException | IllegalStateException e) {
                LOGGER.error("Failed to parse {}", (Object)id, (Object)e);
            }
        }
        class_2960 namespace = converter.method_45115(id);
        return Pair.of((Object)namespace, defaults);
    }

    @Override
    public CompletableFuture<Void> apply(@Nullable Preparations data, class_3300 manager, class_3695 profiler, Executor executor) {
        return CompletableFuture.runAsync(() -> {
            ArrayList defaultedBindings = new ArrayList();
            for (ControllerEntity controller : Controlify.instance().getControllerManager().map(ControllerManager::getConnectedControllers).orElse(List.of())) {
                controller.input().ifPresent(input -> {
                    if (!((InputComponent.Config)input.confObj()).keepDefaultBindings) {
                        for (InputBinding binding : input.getAllBindings()) {
                            if (!binding.boundInput().equals(binding.defaultInput())) continue;
                            defaultedBindings.add(binding);
                        }
                    }
                });
            }
            this.defaultsByNamespace.clear();
            if (data != null) {
                this.defaultsByNamespace.putAll(data.map());
            }
            for (InputBinding binding : defaultedBindings) {
                binding.setBoundInput(binding.defaultInput());
            }
        }, executor);
    }

    public DefaultBindProvider getDefaultBindProvider(class_2960 namespace) {
        DefaultBindProvider provider = this.defaultsByNamespace.get(namespace);
        if (provider == null) {
            provider = this.defaultsByNamespace.get(ControllerType.DEFAULT.namespace());
        }
        if (provider == null) {
            provider = DefaultBindProvider.EMPTY;
        }
        return provider;
    }

    @Override
    public class_2960 getReloadId() {
        return CUtil.rl("default_binds");
    }

    private record ControllerDefault(boolean clearBelow, MapBackedDefaultBindProvider provider) {
        public static final Codec<ControllerDefault> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("clear_below", (Object)false).forGetter(ControllerDefault::clearBelow), (App)MapBackedDefaultBindProvider.MAP_CODEC.fieldOf("defaults").forGetter(ControllerDefault::provider)).apply((Applicative)instance, ControllerDefault::new));
    }

    public record Preparations(Map<class_2960, DefaultBindProvider> map) {
    }
}

