/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify;

import dev.isxander.controlify.InputMode;
import dev.isxander.controlify.api.ControlifyApi;
import dev.isxander.controlify.api.event.ControlifyEvents;
import dev.isxander.controlify.bindings.BindContext;
import dev.isxander.controlify.bindings.ControlifyBindApiImpl;
import dev.isxander.controlify.bindings.ControlifyBindings;
import dev.isxander.controlify.bindings.defaults.DefaultBindManager;
import dev.isxander.controlify.compatibility.ControlifyCompat;
import dev.isxander.controlify.config.ControlifyConfig;
import dev.isxander.controlify.config.GlobalSettings;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.controller.id.ControllerTypeManager;
import dev.isxander.controlify.controller.input.ControllerState;
import dev.isxander.controlify.controller.input.ControllerStateView;
import dev.isxander.controlify.controller.input.HatState;
import dev.isxander.controlify.controller.input.InputComponent;
import dev.isxander.controlify.controller.misc.BluetoothDeviceComponent;
import dev.isxander.controlify.controller.rumble.RumbleComponent;
import dev.isxander.controlify.controllermanager.ControllerManager;
import dev.isxander.controlify.controllermanager.GLFWControllerManager;
import dev.isxander.controlify.controllermanager.SDLControllerManager;
import dev.isxander.controlify.debug.DebugProperties;
import dev.isxander.controlify.driver.SDL3NativesManager;
import dev.isxander.controlify.font.InputFontMapper;
import dev.isxander.controlify.gui.guide.InGameButtonGuide;
import dev.isxander.controlify.gui.screen.AskToMapControllerScreen;
import dev.isxander.controlify.gui.screen.BluetoothWarningScreen;
import dev.isxander.controlify.gui.screen.ControllerCalibrationScreen;
import dev.isxander.controlify.gui.screen.ControllerCarouselScreen;
import dev.isxander.controlify.gui.screen.DontInteruptScreen;
import dev.isxander.controlify.gui.screen.NoSDLScreen;
import dev.isxander.controlify.gui.screen.SDLOnboardingScreen;
import dev.isxander.controlify.gui.screen.SubmitUnknownControllerScreen;
import dev.isxander.controlify.hid.ControllerHIDService;
import dev.isxander.controlify.ingame.ControllerPlayerMovement;
import dev.isxander.controlify.ingame.InGameInputHandler;
import dev.isxander.controlify.mixins.feature.virtualmouse.MouseHandlerAccessor;
import dev.isxander.controlify.platform.client.PlatformClientUtil;
import dev.isxander.controlify.platform.main.PlatformMainUtil;
import dev.isxander.controlify.platform.network.SidedNetworkApi;
import dev.isxander.controlify.rumble.RumbleManager;
import dev.isxander.controlify.screenop.ScreenProcessorProvider;
import dev.isxander.controlify.server.ControlifyHandshake;
import dev.isxander.controlify.server.ServerPolicies;
import dev.isxander.controlify.server.ServerPolicy;
import dev.isxander.controlify.server.packets.EntityVibrationPacket;
import dev.isxander.controlify.server.packets.OriginVibrationPacket;
import dev.isxander.controlify.server.packets.ServerPolicyPacket;
import dev.isxander.controlify.server.packets.VibrationPacket;
import dev.isxander.controlify.sound.ControlifyClientSounds;
import dev.isxander.controlify.utils.CUtil;
import dev.isxander.controlify.utils.ControllerSetupWizard;
import dev.isxander.controlify.utils.ControllerUtils;
import dev.isxander.controlify.utils.DebugDump;
import dev.isxander.controlify.utils.DebugLog;
import dev.isxander.controlify.utils.InitialScreenRegistryDuck;
import dev.isxander.controlify.utils.ToastUtils;
import dev.isxander.controlify.utils.UnhandledCompletableFutures;
import dev.isxander.controlify.virtualmouse.VirtualMouseHandler;
import dev.isxander.controlify.wireless.LowBatteryNotifier;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayDeque;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3673;
import net.minecraft.class_433;
import net.minecraft.class_437;
import net.minecraft.class_642;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;

public class Controlify
implements ControlifyApi {
    private static Controlify instance = null;
    private final class_310 minecraft = class_310.method_1551();
    private ControllerManager controllerManager;
    private boolean finishedInit = false;
    private boolean probeMode = false;
    private ControllerEntity currentController = null;
    private InputMode currentInputMode = InputMode.KEYBOARD_MOUSE;
    private InGameInputHandler inGameInputHandler;
    public InGameButtonGuide inGameButtonGuide;
    private VirtualMouseHandler virtualMouseHandler;
    private InputFontMapper inputFontMapper;
    private DefaultBindManager defaultBindManager;
    private ControllerTypeManager controllerTypeManager;
    private Set<BindContext> thisTickContexts;
    private ControllerHIDService controllerHIDService;
    private CompletableFuture<Boolean> nativeOnboardingFuture = null;
    private final ControlifyConfig config = new ControlifyConfig(this);
    private final Queue<ControllerSetupWizard> setupWizards = new ArrayDeque<ControllerSetupWizard>();
    private ControllerSetupWizard currentSetupWizard = null;
    private boolean hasDiscoveredControllers = false;
    private int consecutiveInputSwitches = 0;
    private double lastInputSwitchTime = 0.0;
    private int showMouseTicks = 0;

    public void preInitialiseControlify() {
        DebugProperties.printProperties();
        CUtil.LOGGER.info("Pre-initializing Controlify...");
        this.inGameInputHandler = null;
        this.virtualMouseHandler = new VirtualMouseHandler();
        this.inputFontMapper = new InputFontMapper();
        this.defaultBindManager = new DefaultBindManager();
        this.controllerTypeManager = new ControllerTypeManager();
        PlatformClientUtil.registerAssetReloadListener(this.inputFontMapper);
        PlatformClientUtil.registerAssetReloadListener(this.defaultBindManager);
        PlatformClientUtil.registerAssetReloadListener(this.controllerTypeManager);
        this.controllerHIDService = new ControllerHIDService();
        this.controllerHIDService.start();
        this.registerBuiltinPack("legacy_console");
        ControlifyClientSounds.init();
        ControlifyHandshake.setupOnClient();
        SidedNetworkApi.S2C().listenForPacket(VibrationPacket.CHANNEL, packet -> {
            if (this.config().globalSettings().allowServerRumble) {
                this.getCurrentController().flatMap(ControllerEntity::rumble).ifPresent(rumble -> rumble.rumbleManager().play(packet.source(), packet.createEffect()));
            }
        });
        SidedNetworkApi.S2C().listenForPacket(OriginVibrationPacket.CHANNEL, packet -> {
            if (this.config().globalSettings().allowServerRumble) {
                this.getCurrentController().flatMap(ControllerEntity::rumble).ifPresent(rumble -> rumble.rumbleManager().play(packet.source(), packet.createEffect()));
            }
        });
        SidedNetworkApi.S2C().listenForPacket(EntityVibrationPacket.CHANNEL, packet -> {
            if (this.config().globalSettings().allowServerRumble) {
                this.getCurrentController().flatMap(ControllerEntity::rumble).ifPresent(rumble -> rumble.rumbleManager().play(packet.source(), packet.createEffect()));
            }
        });
        SidedNetworkApi.S2C().listenForPacket(ServerPolicyPacket.CHANNEL, packet -> {
            CUtil.LOGGER.info("Connected server specified '{}' policy is {}.", (Object)packet.id(), (Object)(packet.allowed() ? "ALLOWED" : "DISALLOWED"));
            ServerPolicies.getById(packet.id()).set(ServerPolicy.fromBoolean(packet.allowed()));
        });
        PlatformClientUtil.registerClientDisconnected(client -> {
            DebugLog.log("Disconnected from server, resetting server policies", new Object[0]);
            ServerPolicies.unsetAll();
        });
        PlatformClientUtil.addHudLayer(CUtil.rl("button_guide"), (graphics, tickDelta) -> this.inGameButtonGuide().ifPresent(guide -> guide.renderHud(graphics, tickDelta)));
    }

    private void registerBuiltinPack(String id) {
        PlatformClientUtil.registerBuiltinResourcePack(CUtil.rl(id), (class_2561)class_2561.method_43471((String)("controlify.extra_pack." + id + ".name")));
    }

    public void initializeControlify() {
        CUtil.LOGGER.info("Initializing Controlify...");
        this.config().load();
        ControlifyEvents.CONTROLLER_CONNECTED.register(event -> this.onControllerAdded(event.controller(), event.hotplugged(), event.newController()));
        ControlifyEvents.CONTROLLER_DISCONNECTED.register(event -> this.onControllerRemoved(event.controller()));
        ControlifyBindings.registerModdedBindings();
        PlatformClientUtil.registerPostScreenRender((screen, graphics, mouseX, mouseY, tickDelta) -> ControlifyApi.get().getCurrentController().ifPresent(controller -> {
            this.virtualMouseHandler().renderVirtualMouse(graphics);
            ScreenProcessorProvider.provide(screen).render((ControllerEntity)controller, graphics, tickDelta);
        }));
        PlatformMainUtil.applyToControlifyEntrypoint(entrypoint -> {
            try {
                entrypoint.onControlifyInit(this);
            }
            catch (Throwable e) {
                CUtil.LOGGER.error("Failed to run `onControlifyInit` on Controlify entrypoint: {}", (Object)entrypoint.getClass().getName(), (Object)e);
            }
        });
        if (this.config().globalSettings().quietMode) {
            boolean controllersConnected = GLFWControllerManager.areControllersConnected();
            if (controllersConnected) {
                ToastUtils.sendToast((class_2561)class_2561.method_43471((String)"controlify.toast.setup_in_config.title"), (class_2561)class_2561.method_43469((String)"controlify.toast.setup_in_config.description", (Object[])new Object[]{class_2561.method_43471((String)"options.title"), class_2561.method_43471((String)"controls.title"), class_2561.method_43470((String)"Controlify")}), false);
            } else {
                this.probeMode = true;
                PlatformClientUtil.registerClientTickEnded(client -> this.probeTick());
            }
        } else {
            this.finishControlifyInit();
        }
        PlatformClientUtil.registerClientStopping(client -> this.controllerHIDService().stop());
    }

    public void discoverControllers() {
        if (this.hasDiscoveredControllers) {
            CUtil.LOGGER.warn("Attempted to discover controllers twice!");
            return;
        }
        this.hasDiscoveredControllers = true;
        DebugLog.log("Discovering and initializing controllers...", new Object[0]);
        this.controllerManager.discoverControllers();
        if (this.controllerManager.getConnectedControllers().isEmpty()) {
            CUtil.LOGGER.info("No controllers found.");
        }
        if (this.getCurrentController().isEmpty()) {
            Optional<ControllerEntity> lastUsedController = this.controllerManager.getConnectedControllers().stream().filter(c -> c.info().uid().equals(this.config().currentControllerUid())).findAny();
            if (lastUsedController.isPresent()) {
                this.setCurrentController(lastUsedController.get(), false);
            } else {
                ControllerEntity anyController = this.controllerManager.getConnectedControllers().stream().filter(c -> c.input().map(input -> input.config().config().deadzonesCalibrated).orElse(true) != false || c.gyro().map(gyro -> gyro.config().config().calibrated).orElse(true) != false).findFirst().orElse(null);
                this.setCurrentController(anyController, false);
            }
        }
        this.config().saveIfDirty();
        PlatformMainUtil.applyToControlifyEntrypoint(entrypoint -> {
            try {
                entrypoint.onControllersDiscovered(this);
            }
            catch (Throwable e) {
                CUtil.LOGGER.error("Failed to run `onControllersDiscovered` on Controlify entrypoint: {}", (Object)entrypoint.getClass().getName(), (Object)e);
            }
        });
    }

    public CompletableFuture<Void> finishControlifyInit() {
        if (this.finishedInit) {
            return CompletableFuture.completedFuture(null);
        }
        this.probeMode = false;
        this.finishedInit = true;
        return ((CompletableFuture)this.askNatives().whenComplete((loaded, th) -> UnhandledCompletableFutures.run(() -> {
            CUtil.LOGGER.info("Finishing Controlify init...");
            if (!loaded.booleanValue()) {
                CUtil.LOGGER.warn("CONTROLIFY DID NOT LOAD SDL3 NATIVES. MANY FEATURES DISABLED!");
            }
            try {
                this.controllerManager = loaded != false ? new SDLControllerManager() : new GLFWControllerManager();
            }
            catch (Throwable throwable) {
                CUtil.LOGGER.error("Failed to initialize controller manager", throwable);
                return;
            }
            PlatformClientUtil.registerClientTickStarted(this::tick);
            ControlifyCompat.init();
            ControlifyBindApiImpl.INSTANCE.lock();
            if (this.config().globalSettings().quietMode) {
                this.config().globalSettings().quietMode = false;
                this.config().setDirty();
            }
            this.discoverControllers();
            if (DebugProperties.INIT_DUMP) {
                CUtil.LOGGER.info("\n{}", (Object)DebugDump.dumpDebug());
            }
        }, this.minecraft))).thenApply(t -> null);
    }

    private void onControllerAdded(ControllerEntity controller, boolean hotplugged, boolean newController) {
        class_437 class_4372;
        boolean calibrated;
        ControllerSetupWizard wizard = new ControllerSetupWizard();
        wizard.addStage(() -> SubmitUnknownControllerScreen.canSubmit(controller), nextScreen -> new SubmitUnknownControllerScreen(controller, nextScreen));
        boolean bl = calibrated = controller.input().map(input -> input.config().config().deadzonesCalibrated).orElse(false) != false || controller.gyro().map(gyro -> gyro.config().config().calibrated).orElse(false) != false;
        if (hotplugged && calibrated) {
            this.setCurrentController(controller, true);
        }
        wizard.addStage(() -> {
            Optional<InputComponent> inputOpt = controller.input();
            if (inputOpt.isPresent()) {
                InputComponent input = inputOpt.get();
                return !input.isDefinitelyGamepad() && ((InputComponent.Config)input.confObj()).mapping == null;
            }
            return false;
        }, nextScreen -> new AskToMapControllerScreen(controller, nextScreen));
        wizard.addStage(() -> !calibrated, nextScreen -> new ControllerCalibrationScreen(controller, nextScreen));
        wizard.addStage(() -> controller.bluetooth().map(bt -> !((BluetoothDeviceComponent.Config)bt.confObj()).dontShowWarningAgain).orElse(false), nextScreen -> new BluetoothWarningScreen(controller.bluetooth().orElseThrow(), nextScreen));
        if (hotplugged) {
            ToastUtils.sendToast((class_2561)class_2561.method_43471((String)"controlify.toast.controller_connected.title"), (class_2561)class_2561.method_43469((String)"controlify.toast.controller_connected.description", (Object[])new Object[]{controller.name()}), false);
        }
        if ((class_4372 = this.minecraft.field_1755) instanceof ControllerCarouselScreen) {
            ControllerCarouselScreen controllerListScreen = (ControllerCarouselScreen)class_4372;
            controllerListScreen.refreshControllers();
        }
        if (hotplugged) {
            this.config().saveIfDirty();
        }
        this.setupWizards.add(wizard);
    }

    private void onControllerRemoved(ControllerEntity controller) {
        this.setCurrentController(this.controllerManager.getConnectedControllers().stream().findFirst().orElse(null), true);
        this.setInputMode(this.getCurrentController().isEmpty() ? InputMode.KEYBOARD_MOUSE : InputMode.CONTROLLER);
        ToastUtils.sendToast((class_2561)class_2561.method_43471((String)"controlify.toast.controller_disconnected.title"), (class_2561)class_2561.method_43469((String)"controlify.toast.controller_disconnected.description", (Object[])new Object[]{controller.name()}), false);
    }

    public CompletableFuture<Boolean> askNatives() {
        if (this.nativeOnboardingFuture != null) {
            return this.nativeOnboardingFuture;
        }
        GlobalSettings settings = this.config().globalSettings();
        if ((!settings.vibrationOnboarded || settings.loadVibrationNatives) && SDL3NativesManager.tryOfflineLoadAndStart()) {
            settings.vibrationOnboarded = true;
            settings.loadVibrationNatives = true;
            this.config().setDirty();
            this.nativeOnboardingFuture = CompletableFuture.completedFuture(true);
            return this.nativeOnboardingFuture;
        }
        if (!SDL3NativesManager.isSupportedOnThisPlatform()) {
            CUtil.LOGGER.warn("SDL is not supported on this platform. Platform: {}", (Object)SDL3NativesManager.Target.CURRENT);
            this.nativeOnboardingFuture = new CompletableFuture();
            this.minecraft.method_1507((class_437)new NoSDLScreen(() -> this.nativeOnboardingFuture.complete(false), this.minecraft.field_1755));
            return this.nativeOnboardingFuture;
        }
        if (this.config().globalSettings().vibrationOnboarded) {
            if (this.config().globalSettings().loadVibrationNatives) {
                this.nativeOnboardingFuture = SDL3NativesManager.maybeLoad();
                return this.nativeOnboardingFuture;
            }
            this.nativeOnboardingFuture = CompletableFuture.completedFuture(false);
            return this.nativeOnboardingFuture;
        }
        this.nativeOnboardingFuture = new CompletableFuture();
        InitialScreenRegistryDuck.registerInitialScreen(runnable -> new SDLOnboardingScreen((Runnable)runnable, answer -> {
            if (answer) {
                SDL3NativesManager.maybeLoad().whenComplete((loaded, th) -> {
                    if (th != null) {
                        this.nativeOnboardingFuture.completeExceptionally((Throwable)th);
                    } else {
                        this.nativeOnboardingFuture.complete((Boolean)loaded);
                    }
                });
            } else {
                this.nativeOnboardingFuture.complete(false);
            }
        }));
        return this.nativeOnboardingFuture;
    }

    public void tick(class_310 client) {
        if (this.minecraft.method_18506() == null) {
            if (this.currentSetupWizard != null && this.currentSetupWizard.isDone()) {
                this.currentSetupWizard = null;
            }
            if (!this.setupWizards.isEmpty() && !(this.minecraft.field_1755 instanceof DontInteruptScreen)) {
                this.currentSetupWizard = this.setupWizards.poll();
                this.minecraft.method_1507(this.currentSetupWizard.start(this.minecraft.field_1755));
            }
        }
        boolean outOfFocus = !this.config().globalSettings().outOfFocusInput && !client.method_1569();
        this.thisTickContexts = BindContext.REGISTRY.method_10220().filter(ctx -> ctx.isApplicable().apply(this.minecraft)).collect(Collectors.toUnmodifiableSet());
        this.controllerManager.tick(outOfFocus);
        if (this.minecraft.field_1729.method_1613()) {
            this.showMouseTicks = 0;
        }
        if (this.currentInputMode() == InputMode.MIXED && this.showMouseTicks > 0) {
            --this.showMouseTicks;
            if (this.showMouseTicks == 0) {
                this.hideMouse(true, false);
                if (this.virtualMouseHandler().requiresVirtualMouse()) {
                    this.virtualMouseHandler().enableVirtualMouse();
                }
            }
        }
        LowBatteryNotifier.tick();
        this.getCurrentController().ifPresent(currentController -> ControllerUtils.wrapControllerError(() -> this.tickController((ControllerEntity)currentController, outOfFocus), "Ticking current controller", currentController));
    }

    /*
     * Unable to fully structure code
     */
    private void tickController(ControllerEntity controller, boolean outOfFocus) {
        input = controller.input().orElseThrow();
        state = input.stateNow();
        rumbleManager = controller.rumble().map((Function<RumbleComponent, RumbleManager>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, rumbleManager(), (Ldev/isxander/controlify/controller/rumble/RumbleComponent;)Ldev/isxander/controlify/rumble/RumbleManager;)());
        rumbleManager.ifPresent((Consumer<RumbleManager>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$tickController$43(boolean dev.isxander.controlify.rumble.RumbleManager ), (Ldev/isxander/controlify/rumble/RumbleManager;)V)((Controlify)this, (boolean)outOfFocus));
        if (outOfFocus) {
            state = ControllerState.EMPTY;
        } else {
            rumbleManager.ifPresent((Consumer<RumbleManager>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, tick(), (Ldev/isxander/controlify/rumble/RumbleManager;)V)());
        }
        if (state.getButtons().stream().anyMatch((Predicate<class_2960>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isButtonDown(net.minecraft.class_2960 ), (Lnet/minecraft/class_2960;)Z)((ControllerStateView)state))) ** GOTO lbl-1000
        if (state.getAxes().stream().map((Function<class_2960, Float>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getAxisState(net.minecraft.class_2960 ), (Lnet/minecraft/class_2960;)Ljava/lang/Float;)((ControllerStateView)state)).anyMatch((Predicate<Float>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$tickController$44(java.lang.Float ), (Ljava/lang/Float;)Z)())) ** GOTO lbl-1000
        if (state.getHats().stream().map((Function<class_2960, HatState>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getHatState(net.minecraft.class_2960 ), (Lnet/minecraft/class_2960;)Ldev/isxander/controlify/controller/input/HatState;)((ControllerStateView)state)).anyMatch((Predicate<HatState>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$tickController$45(dev.isxander.controlify.controller.input.HatState ), (Ldev/isxander/controlify/controller/input/HatState;)Z)())) lbl-1000:
        // 3 sources

        {
            v0 = true;
        } else {
            v0 = givingInput = false;
        }
        if (givingInput && !this.currentInputMode().isController()) {
            this.setInputMode(((InputComponent.Config)input.confObj()).mixedInput != false ? InputMode.MIXED : InputMode.CONTROLLER);
            return;
        }
        if (this.consecutiveInputSwitches > 100) {
            CUtil.LOGGER.warn("Controlify detected current controller to be constantly giving input and has been disabled.");
            ToastUtils.sendToast((class_2561)class_2561.method_43471((String)"controlify.toast.faulty_input.title"), (class_2561)class_2561.method_43471((String)"controlify.toast.faulty_input.description"), true);
            this.setCurrentController(null, true);
            this.consecutiveInputSwitches = 0;
            return;
        }
        if (this.currentInputMode().isController()) {
            if (this.minecraft.field_1687 != null) {
                this.inGameInputHandler().ifPresent((Consumer<InGameInputHandler>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, inputTick(), (Ldev/isxander/controlify/ingame/InGameInputHandler;)V)());
            }
            if (this.minecraft.field_1755 != null) {
                ScreenProcessorProvider.provide(this.minecraft.field_1755).onControllerUpdate(controller);
            }
            ControlifyEvents.ACTIVE_CONTROLLER_TICKED.invoke(new ControlifyEvents.ControllerStateUpdate(controller));
        }
    }

    private void probeTick() {
        if (this.probeMode && GLFWControllerManager.areControllersConnected()) {
            this.probeMode = false;
            this.minecraft.execute(this::finishControlifyInit);
        }
    }

    public ControlifyConfig config() {
        return this.config;
    }

    @Override
    @NotNull
    public Optional<ControllerEntity> getCurrentController() {
        return Optional.ofNullable(this.currentController);
    }

    public void setCurrentController(@Nullable ControllerEntity controller, boolean changeInputMode) {
        if (this.currentController == controller) {
            return;
        }
        this.currentController = controller;
        if (controller == null) {
            this.setInputMode(InputMode.KEYBOARD_MOUSE);
            this.inGameInputHandler = null;
            this.inGameButtonGuide = null;
            DebugLog.log("Updated current controller to null", new Object[0]);
            this.config().save();
            return;
        }
        DebugLog.log("Updated current controller to {}({})", controller.name(), controller.info().uid());
        if (!controller.info().uid().equals(this.config().currentControllerUid())) {
            this.config().setDirty();
        }
        this.inGameInputHandler = new InGameInputHandler(controller);
        ControllerPlayerMovement.ensureCorrectInput(this.minecraft.field_1724);
        if (controller.input().map(input -> input.config().config().mixedInput).orElse(false).booleanValue()) {
            this.setInputMode(InputMode.MIXED);
        } else if (changeInputMode) {
            this.setInputMode(InputMode.CONTROLLER);
        }
        this.config().saveIfDirty();
    }

    public Optional<ControllerManager> getControllerManager() {
        return Optional.ofNullable(this.controllerManager);
    }

    public Optional<InGameInputHandler> inGameInputHandler() {
        return Optional.ofNullable(this.inGameInputHandler);
    }

    public Optional<InGameButtonGuide> inGameButtonGuide() {
        return Optional.ofNullable(this.inGameButtonGuide);
    }

    public VirtualMouseHandler virtualMouseHandler() {
        return this.virtualMouseHandler;
    }

    public ControllerHIDService controllerHIDService() {
        return this.controllerHIDService;
    }

    @Override
    @NotNull
    public InputMode currentInputMode() {
        return this.currentInputMode;
    }

    @Override
    public boolean setInputMode(@NotNull InputMode currentInputMode) {
        if (this.currentInputMode == currentInputMode) {
            return false;
        }
        this.currentInputMode = currentInputMode;
        if (!this.minecraft.field_1729.method_1613()) {
            this.hideMouse(currentInputMode.isController(), true);
        }
        if (this.minecraft.field_1755 != null) {
            ScreenProcessorProvider.provide(this.minecraft.field_1755).onInputModeChanged(currentInputMode);
        }
        if (class_310.method_1551().field_1724 != null) {
            this.inGameButtonGuide = currentInputMode == InputMode.KEYBOARD_MOUSE ? null : (InGameButtonGuide)this.getCurrentController().map(c -> new InGameButtonGuide((ControllerEntity)c, class_310.method_1551().field_1724)).orElse(null);
        }
        this.consecutiveInputSwitches = class_3673.method_15974() - this.lastInputSwitchTime < 20.0 ? ++this.consecutiveInputSwitches : 0;
        this.lastInputSwitchTime = class_3673.method_15974();
        if (this.currentInputMode.isController()) {
            this.getCurrentController().flatMap(ControllerEntity::input).ifPresent(state -> {
                state.rawStateNow().clearState();
                state.rawStateThen().clearState();
            });
            if (this.minecraft.method_1558() != null) {
                this.notifyNewServer(this.minecraft.method_1558());
            }
        }
        ControllerPlayerMovement.updatePlayerInput(this.minecraft.field_1724);
        ControlifyEvents.INPUT_MODE_CHANGED.invoke(new ControlifyEvents.InputModeChanged(currentInputMode));
        return true;
    }

    public void hideMouse(boolean hide, boolean moveMouse) {
        GLFW.glfwSetInputMode((long)this.minecraft.method_22683().method_4490(), (int)208897, (int)(hide ? 212994 : 212993));
        if (this.minecraft.field_1755 != null) {
            MouseHandlerAccessor mouseHandlerAccessor = (MouseHandlerAccessor)this.minecraft.field_1729;
            if (hide && !this.virtualMouseHandler().isVirtualMouseEnabled() && moveMouse) {
                mouseHandlerAccessor.invokeMethod_1600(this.minecraft.method_22683().method_4490(), -50.0, -50.0);
            }
        }
    }

    public void showCursorTemporarily() {
        if (this.currentInputMode() == InputMode.MIXED && !this.minecraft.field_1729.method_1613()) {
            this.hideMouse(false, false);
            this.showMouseTicks = 40;
            if (this.virtualMouseHandler().isVirtualMouseEnabled()) {
                this.virtualMouseHandler().disableVirtualMouse();
            }
        }
    }

    public InputFontMapper inputFontMapper() {
        return this.inputFontMapper;
    }

    public DefaultBindManager defaultBindManager() {
        return this.defaultBindManager;
    }

    public ControllerTypeManager controllerTypeManager() {
        return this.controllerTypeManager;
    }

    public Set<BindContext> thisTickBindContexts() {
        return this.thisTickContexts;
    }

    public void notifyNewServer(class_642 data) {
        if (!this.currentInputMode().isController()) {
            return;
        }
        if (this.config().globalSettings().seenServers.add(data.field_3761)) {
            ToastUtils.sendToast((class_2561)class_2561.method_43471((String)"controlify.toast.new_server.title"), (class_2561)class_2561.method_43469((String)"controlify.toast.new_server.description", (Object[])new Object[]{data.field_3752}), true);
            this.config().save();
        }
    }

    public static Controlify instance() {
        if (instance == null) {
            instance = new Controlify();
        }
        return instance;
    }

    private static /* synthetic */ boolean lambda$tickController$45(HatState hat) {
        return hat != HatState.CENTERED;
    }

    private static /* synthetic */ boolean lambda$tickController$44(Float axis) {
        return Math.abs(axis.floatValue()) > 0.1f;
    }

    private /* synthetic */ void lambda$tickController$43(boolean outOfFocus, RumbleManager rumble) {
        rumble.setSilent(outOfFocus || this.minecraft.method_1493() || this.minecraft.field_1755 instanceof class_433);
    }
}

