/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.sodiumextra.client.gui.scrollable_page;

import java.util.ArrayList;
import me.flashyreese.mods.sodiumextra.client.gui.scrollable_page.AbstractFrame;
import me.flashyreese.mods.sodiumextra.client.gui.scrollable_page.ScrollBarComponent;
import net.caffeinemc.mods.sodium.client.gui.options.Option;
import net.caffeinemc.mods.sodium.client.gui.options.OptionGroup;
import net.caffeinemc.mods.sodium.client.gui.options.OptionImpact;
import net.caffeinemc.mods.sodium.client.gui.options.OptionPage;
import net.caffeinemc.mods.sodium.client.gui.options.control.Control;
import net.caffeinemc.mods.sodium.client.gui.options.control.ControlElement;
import net.caffeinemc.mods.sodium.client.gui.widgets.AbstractWidget;
import net.caffeinemc.mods.sodium.client.util.Dim2i;
import net.minecraft.class_124;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

public class OptionPageScrollFrame
extends AbstractFrame {
    protected final OptionPage page;
    private boolean canScroll;
    private ScrollBarComponent scrollBar = null;

    public OptionPageScrollFrame(Dim2i dim, OptionPage page) {
        super(dim);
        this.page = page;
        this.setupFrame();
        this.buildFrame();
    }

    public void setupFrame() {
        this.children.clear();
        this.renderable.clear();
        this.controlElements.clear();
        int y = 0;
        if (!this.page.getGroups().isEmpty()) {
            OptionGroup lastGroup = (OptionGroup)this.page.getGroups().get(this.page.getGroups().size() - 1);
            for (OptionGroup group : this.page.getGroups()) {
                y += group.getOptions().size() * 18;
                if (group == lastGroup) continue;
                y += 4;
            }
        }
        boolean bl = this.canScroll = this.dim.height() < y;
        if (this.canScroll) {
            this.scrollBar = new ScrollBarComponent(new Dim2i(this.dim.getLimitX() - 10, this.dim.y(), 10, this.dim.height()), y, this.dim.height(), this::buildFrame, this.dim);
        }
    }

    @Override
    public void buildFrame() {
        if (this.page == null) {
            return;
        }
        this.children.clear();
        this.renderable.clear();
        this.controlElements.clear();
        int y = 0;
        for (OptionGroup group : this.page.getGroups()) {
            for (Option option : group.getOptions()) {
                Control control = option.getControl();
                ControlElement element = control.createElement(new Dim2i(this.dim.x(), this.dim.y() + y - (this.canScroll ? this.scrollBar.getOffset() : 0), this.dim.width() - (this.canScroll ? 11 : 0), 18));
                this.children.add(element);
                y += 18;
            }
            y += 4;
        }
        if (this.canScroll) {
            this.scrollBar.updateThumbPosition();
        }
        super.buildFrame();
    }

    @Override
    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        ControlElement hoveredElement = this.controlElements.stream().filter(AbstractWidget::isHovered).findFirst().orElse(this.controlElements.stream().filter(AbstractWidget::method_25370).findFirst().orElse(null));
        this.applyScissor(this.dim.x(), this.dim.y(), this.dim.width(), this.dim.height(), () -> super.method_25394(guiGraphics, mouseX, mouseY, delta));
        if (this.canScroll) {
            this.scrollBar.method_25394(guiGraphics, mouseX, mouseY, delta);
        }
        if (this.dim.containsCursor((double)mouseX, (double)mouseY) && hoveredElement != null) {
            this.renderOptionTooltip(guiGraphics, hoveredElement);
        }
    }

    private void renderOptionTooltip(class_332 guiGraphics, ControlElement<?> element) {
        int boxYCutoff;
        int boxHeight;
        int boxYLimit;
        Dim2i dim = element.getDimensions();
        int textPadding = 3;
        int boxPadding = 3;
        int boxWidth = 240;
        int boxY = Math.max(dim.y(), this.dim.y());
        int boxX = this.dim.getLimitX() + boxPadding;
        Option option = element.getOption();
        ArrayList<class_5481> tooltip = new ArrayList<class_5481>(class_310.method_1551().field_1772.method_1728((class_5348)option.getTooltip(), boxWidth - textPadding * 2));
        OptionImpact impact = option.getImpact();
        if (impact != null) {
            tooltip.add(class_2477.method_10517().method_30934((class_5348)class_2561.method_43469((String)"sodium.options.performance_impact_string", (Object[])new Object[]{impact.getLocalizedName()}).method_27692(class_124.field_1080)));
        }
        if ((boxYLimit = boxY + (boxHeight = tooltip.size() * 12 + boxPadding)) > (boxYCutoff = this.dim.getLimitY() - 25)) {
            boxY -= boxYLimit - boxYCutoff;
        }
        this.drawRect(guiGraphics, boxX, boxY, boxX + boxWidth, boxY + boxHeight, -536870912);
        for (int i = 0; i < tooltip.size(); ++i) {
            guiGraphics.method_51430(class_310.method_1551().field_1772, (class_5481)tooltip.get(i), boxX + textPadding, boxY + textPadding + i * 12, -1, false);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.dim.containsCursor(mouseX, mouseY) && super.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (this.canScroll) {
            return this.scrollBar.method_25402(mouseX, mouseY, button);
        }
        return false;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (super.method_25403(mouseX, mouseY, button, deltaX, deltaY)) {
            return true;
        }
        if (this.canScroll) {
            return this.scrollBar.method_25403(mouseX, mouseY, button, deltaX, deltaY);
        }
        return false;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (super.method_25406(mouseX, mouseY, button)) {
            return true;
        }
        if (this.canScroll) {
            return this.scrollBar.method_25406(mouseX, mouseY, button);
        }
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount)) {
            return true;
        }
        if (this.canScroll) {
            return this.scrollBar.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
        }
        return false;
    }
}

