/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.version;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import journeymap.client.JourneymapClient;
import journeymap.common.Journeymap;
import journeymap.common.thread.JMThreadFactory;
import journeymap.common.version.Version;

public class VersionCheck {
    private static volatile ExecutorService executorService;
    private static volatile Boolean updateCheckEnabled;
    private static volatile Boolean versionIsCurrent;
    private static volatile Boolean versionIsChecked;
    private static volatile String versionAvailable;
    private static volatile String downloadUrl;

    public static Boolean getVersionIsCurrent() {
        if (versionIsChecked == null) {
            VersionCheck.checkVersion();
        }
        return versionIsCurrent;
    }

    public static Boolean getVersionIsChecked() {
        if (versionIsChecked == null) {
            VersionCheck.checkVersion();
        }
        return versionIsChecked;
    }

    public static String getVersionAvailable() {
        if (versionIsChecked == null) {
            VersionCheck.checkVersion();
        }
        return versionAvailable;
    }

    public static String getDownloadUrl() {
        if (versionIsChecked == null) {
            VersionCheck.checkVersion();
        }
        return downloadUrl;
    }

    private static synchronized void checkVersion() {
        versionIsChecked = false;
        versionIsCurrent = true;
        versionAvailable = "0";
        if (!updateCheckEnabled.booleanValue()) {
            Journeymap.getLogger().info("Update check disabled in properties file.");
        } else {
            executorService = Executors.newSingleThreadExecutor(new JMThreadFactory("VersionCheck"));
            try {
                executorService.submit(() -> {
                    String currentVersion = Journeymap.JM_VERSION.toString();
                    boolean currentIsRelease = Journeymap.JM_VERSION.isRelease();
                    JsonObject project = VersionCheck.makeGetRequest(Journeymap.VERSION_URL);
                    JsonObject downloadUrls = VersionCheck.makeGetRequest(Journeymap.VERSION_URL + "/references");
                    if (project != null && downloadUrls != null) {
                        JsonObject promos = project.get("promos").getAsJsonObject();
                        Set versions = project.get("promos").getAsJsonObject().keySet();
                        if (versions == null) {
                            Journeymap.getLogger().warn("No versions found online for 1.21.1");
                        } else {
                            for (String name : versions) {
                                String file = promos.get(name).getAsString();
                                try {
                                    if (currentIsRelease && !name.contains("recommended") || !name.contains("1.21.1")) continue;
                                    downloadUrl = downloadUrls.get(name).getAsString();
                                    file = Version.from(promos.get(name).getAsString(), null).toString();
                                    if (VersionCheck.isCurrent(currentVersion, file)) continue;
                                    versionAvailable = file;
                                    versionIsCurrent = false;
                                    versionIsChecked = true;
                                    Journeymap.getLogger().info("Newer version online: Current: {} New: {} for Minecraft {} on {}", (Object)currentVersion, (Object)versionAvailable, (Object)"1.21.1", (Object)downloadUrl);
                                    break;
                                }
                                catch (Exception e) {
                                    Journeymap.getLogger().error("Could not parse download info: " + file, (Throwable)e);
                                }
                            }
                        }
                        if (!versionIsChecked.booleanValue()) {
                            versionAvailable = currentVersion;
                            versionIsCurrent = true;
                            versionIsChecked = true;
                            downloadUrl = Journeymap.DOWNLOAD_URL;
                        }
                    }
                    if (!versionIsCurrent.booleanValue()) {
                        // empty if block
                    }
                });
            }
            catch (Exception e) {
                Journeymap.getLogger().error("Error with version checking");
            }
            finally {
                executorService.shutdown();
                executorService = null;
            }
        }
    }

    private static JsonObject makeGetRequest(String url) {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("Java-http-client/").append(System.getProperty("java.version")).append(' ');
            sb.append("journeymap").append('/').append(Journeymap.JM_VERSION);
            String userAgent = sb.toString();
            URI uri = URI.create(url);
            HttpRequest request = HttpRequest.newBuilder().uri(uri).timeout(Duration.ofSeconds(6L)).setHeader("Content-type", "application/json").setHeader("User-Agent", userAgent).GET().build();
            HttpClient httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(6L)).build();
            HttpResponse<String> response = httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() / 200 == 1) {
                String rawResponse = response.body();
                return JsonParser.parseString((String)rawResponse).getAsJsonObject();
            }
            Journeymap.getLogger().error(String.format("Version check to %s returned: %s ", uri, response.statusCode()));
        }
        catch (Throwable e) {
            Journeymap.getLogger().error("Could not check version URL {}", (Object)url, (Object)e);
            updateCheckEnabled = false;
        }
        return null;
    }

    private static boolean isCurrent(String thisVersionStr, String availableVersionStr) {
        if (thisVersionStr.equals(availableVersionStr)) {
            return true;
        }
        Version thisVersion = Version.from(thisVersionStr, null);
        Version availableVersion = Version.from(availableVersionStr, null);
        return !availableVersion.isNewerThan(thisVersion);
    }

    static {
        updateCheckEnabled = JourneymapClient.getInstance().isUpdateCheckEnabled();
        versionIsCurrent = true;
    }
}

