/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.network.dispatch;

import commonnetwork.api.NetworkHandler;
import java.util.List;
import journeymap.common.network.model.PlayerLoc;
import journeymap.common.network.packets.ClientPermissionsPacket;
import journeymap.common.network.packets.HandshakePacket;
import journeymap.common.network.packets.MultiplayerOptionsPacket;
import journeymap.common.network.packets.ServerAdminRequestPropPacket;
import journeymap.common.network.packets.ServerPlayerLocationPacket;
import journeymap.common.network.packets.WaypointPacket;
import journeymap.common.network.packets.WorldIdPacket;
import net.minecraft.class_3222;

public class NetworkDispatcher {
    protected final NetworkHandler handler;

    public NetworkDispatcher(NetworkHandler handler) {
        this.handler = handler;
    }

    public void sendPlayerLocationPacket(class_3222 player, List<PlayerLoc> remotePlayers) {
        this.handler.sendToClient((Object)new ServerPlayerLocationPacket(remotePlayers), player);
    }

    public void sendClientPermissions(class_3222 player, String payload, boolean serverAdmin) {
        this.handler.sendToClient((Object)new ClientPermissionsPacket(payload, serverAdmin, true), player);
    }

    public void sendWaypointPacket(class_3222 player, String waypoint, boolean announce, String action) {
        this.handler.sendToClient((Object)new WaypointPacket(waypoint, announce, action), player);
    }

    public void sendServerAdminPacket(class_3222 player, int type, String payload, String dimension) {
        this.handler.sendToClient((Object)new ServerAdminRequestPropPacket(type, payload, dimension), player);
    }

    public void sendWorldIdPacket(class_3222 player, String worldId) {
        this.handler.sendToClient((Object)new WorldIdPacket(worldId), player);
    }

    public void sendMultiplayerOptionsPacket(class_3222 player, String payload) {
        this.handler.sendToClient((Object)new MultiplayerOptionsPacket(payload), player);
    }

    public void sendHandshakePacket(class_3222 player, String version) {
        this.handler.sendToClient((Object)new HandshakePacket(version), player);
    }
}

