/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.migrate;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.io.FileHandler;
import journeymap.client.properties.ClientPropertiesBase;
import journeymap.client.task.MigrationTask;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import journeymap.common.properties.PropertiesBase;
import journeymap.common.version.Version;

public class Migrate59to60
implements MigrationTask {
    @Override
    public boolean isActive(Version currentVersion) {
        if (currentVersion.toMajorMinorString().startsWith("6.0.0")) {
            if (JourneymapClient.getInstance().getCoreProperties() == null) {
                JourneymapClient.getInstance().loadConfigProperties();
            }
            String optionsManagerViewed = JourneymapClient.getInstance().getCoreProperties().optionsManagerViewed.get();
            return Strings.isNullOrEmpty((String)optionsManagerViewed);
        }
        return false;
    }

    @Override
    public Boolean call() throws Exception {
        return this.migrateConfigs();
    }

    private boolean migrateConfigs() {
        try {
            String path_5_9 = Joiner.on((String)File.separator).join((Object)Constants.JOURNEYMAP_DIR, (Object)"config", new Object[]{"5.9"});
            File legacyConfigDir = new File(FileHandler.MinecraftDirectory, path_5_9);
            if (!legacyConfigDir.canRead()) {
                return true;
            }
            Journeymap.getLogger().info("Migrating configs from 5.9 to 6.0");
            List<ClientPropertiesBase> propertiesList = Arrays.asList(JourneymapClient.getInstance().getCoreProperties(), JourneymapClient.getInstance().getFullMapProperties(), JourneymapClient.getInstance().getMiniMapProperties(1), JourneymapClient.getInstance().getMiniMapProperties(2), JourneymapClient.getInstance().getWaypointProperties(), JourneymapClient.getInstance().getWebMapProperties(), JourneymapClient.getInstance().getTopoProperties());
            for (PropertiesBase propertiesBase : propertiesList) {
                File oldConfigfile = new File(legacyConfigDir, propertiesBase.getFile().getName());
                if (!oldConfigfile.canRead()) continue;
                try {
                    propertiesBase.load(oldConfigfile, false);
                    propertiesBase.save();
                }
                catch (Throwable t) {
                    Journeymap.getLogger().error("Unexpected error in migrateConfigs(): {}", (Object)LogFormatter.toString(t));
                }
            }
            JourneymapClient.getInstance().getCoreProperties().optionsManagerViewed.set("6.0.0");
            JourneymapClient.getInstance().getMiniMapProperties((int)1).zoomLevel.set((Object)512);
            JourneymapClient.getInstance().getMiniMapProperties((int)2).zoomLevel.set((Object)512);
            JourneymapClient.getInstance().getFullMapProperties().zoomLevel.set((Object)512);
            return true;
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Unexpected error in migrateConfigs(): {}", (Object)LogFormatter.toString(t));
            return false;
        }
    }
}

