/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.utils;

import com.google.common.base.Stopwatch;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.List;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.utils.LazyHolderSet;
import net.mehvahdjukaar.polytone.utils.PartialReloader;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import net.minecraft.class_5455;
import net.minecraft.class_638;

public class CompoundReloader
extends class_4080<List<Object>> {
    private final List<PartialReloader<?>> children;

    public CompoundReloader(PartialReloader<?> ... reloaders) {
        this.children = List.of(reloaders);
    }

    protected List<Object> prepare(class_3300 resourceManager, class_3695 profiler) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (PartialReloader<?> c : this.children) {
            list.add(c.prepare(resourceManager));
        }
        return list;
    }

    protected void apply(List<Object> object, class_3300 resourceManager, class_3695 profiler) {
        class_638 level = class_310.method_1551().field_1687;
        LazyHolderSet.clearAll();
        Stopwatch stopwatch = Stopwatch.createStarted();
        for (PartialReloader<?> c : this.children) {
            c.reset();
        }
        for (int i = 0; i < object.size(); ++i) {
            PartialReloader<?> c;
            c = this.children.get(i);
            try {
                this.processTyped(c, object.get(i));
                continue;
            }
            catch (Exception e) {
                String message = String.valueOf(c) + " failed to parse some resources";
                Polytone.logException(e, message);
                Polytone.iMessedUp = true;
                Polytone.LOGGER.error(message);
                throw e;
            }
        }
        if (class_310.method_1551().field_1687 != null) {
            try {
                LazyHolderSet.initializeAll(class_310.method_1551().field_1687.method_30349());
            }
            catch (Exception e) {
                String message = "failed to parse some resources";
                Polytone.logException(e, message);
                Polytone.iMessedUp = true;
                Polytone.LOGGER.error(message);
                throw e;
            }
        }
        for (PartialReloader<?> c : this.children) {
            try {
                c.apply();
                if (level == null) continue;
                c.applyWithLevel(level.method_30349(), false);
            }
            catch (Exception e) {
                String message = String.valueOf(c) + " failed to apply some resources";
                Polytone.logException(e, message);
                Polytone.iMessedUp = true;
                Polytone.LOGGER.error(message);
                throw e;
            }
        }
        Polytone.LOGGER.info("Reloaded Polytone Resources in {} ms", (Object)stopwatch.elapsed().toMillis());
    }

    private <T> void processTyped(PartialReloader<T> reloader, Object object) {
        reloader.process(object, (DynamicOps<JsonElement>)JsonOps.INSTANCE);
    }

    public void applyOnLevelLoad(class_5455 registryAccess, boolean firstLogin) {
        for (PartialReloader<?> c : this.children) {
            c.applyWithLevel(registryAccess, firstLogin);
        }
    }
}

