/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.texture;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.texture.VariantTexture;
import net.mehvahdjukaar.polytone.utils.BakedQuadsTransformer;
import net.mehvahdjukaar.polytone.utils.JsonPartialReloader;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1920;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_777;
import net.minecraft.class_7923;
import net.minecraft.class_853;
import org.jetbrains.annotations.NotNull;

public class VariantTextureManager
extends JsonPartialReloader {
    private final WeakHashMap<class_777, Map<class_2960, class_777>> variantQuadsCache = new WeakHashMap();
    private final Map<class_2248, VariantTexture> blocksWithVariants = new Object2ObjectOpenHashMap();
    private final Set<class_2248> forceTintBlocks = new HashSet<class_2248>();

    public VariantTextureManager() {
        super("variant_textures");
    }

    @Override
    public void process(Map<class_2960, JsonElement> jsonElementMap, DynamicOps<JsonElement> ops) {
        for (Map.Entry<class_2960, JsonElement> j : jsonElementMap.entrySet()) {
            JsonElement json = j.getValue();
            class_2960 id = j.getKey();
            VariantTexture variant = (VariantTexture)((Pair)VariantTexture.CODEC.decode(ops, (Object)json).getOrThrow(errorMsg -> new IllegalStateException("Could not decode Variant Texture with json id " + String.valueOf(id) + "\n error: " + errorMsg))).getFirst();
            this.addVariant(id, variant);
        }
    }

    private void addVariant(class_2960 pathId, VariantTexture mod) {
        for (class_2248 b : mod.getTargets(pathId, class_7923.field_41175)) {
            VariantTexture old = this.blocksWithVariants.put(b, mod);
            if (old == null) continue;
            Polytone.LOGGER.warn("Found 2 Variant Textures jsons with same target ({}). Overriding", (Object)b);
        }
    }

    @Override
    protected void reset() {
        this.blocksWithVariants.clear();
        this.variantQuadsCache.clear();
        this.forceTintBlocks.clear();
    }

    public boolean shouldSetTintTo0(int tintIndex, class_1920 blockView, class_2680 state, class_2338 blockPos) {
        if (tintIndex == -1 && !this.forceTintBlocks.isEmpty() && state != null) {
            return this.forceTintBlocks.contains(state.method_26204());
        }
        return false;
    }

    public class_777 maybeModify(class_777 quad, class_1920 level, class_2680 state, class_2338 pos) {
        Map<class_2960, class_2960> biomeToTexture;
        if (quad.field_4174 == -1 && !this.forceTintBlocks.isEmpty() && this.forceTintBlocks.contains(state.method_26204())) {
            quad.field_4174 = 0;
        }
        if (this.blocksWithVariants.isEmpty()) {
            return null;
        }
        class_2248 block = state.method_26204();
        VariantTexture variant = this.blocksWithVariants.get(block);
        if (variant != null && (biomeToTexture = variant.getBiomeMap(quad.method_35788())) != null && level instanceof class_853) {
            class_853 region = (class_853)level;
            class_6880 biome = region.field_4490.method_23753(pos);
            class_2960 biomeLoc = ((class_5321)biome.method_40230().get()).method_29177();
            class_2960 newTexture = biomeToTexture.get(biomeLoc);
            if (newTexture != null) {
                return this.getOrCreateQuad(quad, biomeLoc, newTexture);
            }
        }
        return null;
    }

    @NotNull
    private class_777 getOrCreateQuad(class_777 quad, class_2960 biome, class_2960 newTexture) {
        return this.variantQuadsCache.computeIfAbsent(quad, q -> new WeakHashMap()).computeIfAbsent(biome, b -> {
            class_1058 s = (class_1058)class_310.method_1551().method_1549(class_1059.field_5275).apply(newTexture);
            BakedQuadsTransformer transformer = BakedQuadsTransformer.create().applyingSprite(s);
            return transformer.transform(quad);
        });
    }

    public void addTintOverrideHack(class_2248 block) {
        if (block != class_2246.field_10219) {
            this.forceTintBlocks.add(block);
        }
    }
}

