/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.particle;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.polytone.particle.ParticleModifier;
import net.mehvahdjukaar.polytone.utils.JsonPartialReloader;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2960;
import net.minecraft.class_703;
import net.minecraft.class_7923;

public class ParticleModifiersManager
extends JsonPartialReloader {
    private final Multimap<class_2396<?>, ParticleModifier> particleModifiers = HashMultimap.create();

    public ParticleModifiersManager() {
        super("particle_modifiers");
    }

    public void maybeModify(class_2394 options, class_1937 level, class_703 particle) {
        Collection mod = this.particleModifiers.get((Object)options.method_10295());
        for (ParticleModifier modifier : mod) {
            modifier.modify(particle, level, options);
        }
    }

    @Override
    public void process(Map<class_2960, JsonElement> jsons, DynamicOps<JsonElement> ops) {
        for (Map.Entry<class_2960, JsonElement> j : jsons.entrySet()) {
            JsonElement json = j.getValue();
            class_2960 id = j.getKey();
            ParticleModifier modifier = (ParticleModifier)((Pair)ParticleModifier.CODEC.decode(ops, (Object)json).getOrThrow(errorMsg -> new IllegalStateException("Could not decode Particle Modifier with json id " + String.valueOf(id) + "\n error: " + errorMsg))).getFirst();
            this.addModifier(id, modifier);
        }
    }

    private void addModifier(class_2960 pathId, ParticleModifier mod) {
        for (class_2396 p : mod.getTargets(pathId, class_7923.field_41180)) {
            this.particleModifiers.put((Object)p, (Object)mod);
        }
    }

    @Override
    protected void reset() {
        this.particleModifiers.clear();
    }

    public void addCustomParticleColor(class_2960 id, String color) {
        Optional opt = class_7923.field_41180.method_17966(id);
        opt.ifPresent(t -> this.particleModifiers.put(t, (Object)ParticleModifier.ofColor(color)));
    }
}

