/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.particle;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.Map;
import java.util.function.Function;
import net.mehvahdjukaar.polytone.PlatStuff;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.particle.CustomParticleFactory;
import net.mehvahdjukaar.polytone.particle.CustomParticleType;
import net.mehvahdjukaar.polytone.particle.SemiCustomParticleType;
import net.mehvahdjukaar.polytone.utils.JsonPartialReloader;
import net.mehvahdjukaar.polytone.utils.MapRegistry;
import net.minecraft.class_2396;
import net.minecraft.class_2400;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_702;
import net.minecraft.class_707;
import net.minecraft.class_7923;

public class CustomParticlesManager
extends JsonPartialReloader {
    public final MapRegistry<CustomParticleFactory> customParticleFactories = new MapRegistry("Custom Particles");
    public static final Codec<CustomParticleFactory> CUSTOM_OR_SEMI_CUSTOM_CODEC = Codec.either(SemiCustomParticleType.CODEC, CustomParticleType.CODEC).xmap(e -> (CustomParticleFactory)e.map(Function.identity(), Function.identity()), p -> {
        Either either;
        if (p instanceof CustomParticleType) {
            CustomParticleType c = (CustomParticleType)p;
            either = Either.right((Object)c);
        } else {
            either = Either.left((Object)((SemiCustomParticleType)p));
        }
        return either;
    });

    public CustomParticlesManager() {
        super("custom_particles");
    }

    @Override
    protected void reset() {
        for (class_2960 id : this.customParticleFactories.orderedKeys()) {
            PlatStuff.unregisterParticleProvider(id);
            PlatStuff.unregisterDynamic(class_7923.field_41180, id);
        }
        this.customParticleFactories.clear();
    }

    public void addSpriteSets(class_3300 resourceManager) {
        class_702 engine = class_310.method_1551().field_1713;
        for (class_2960 v : this.customParticleFactories.keySet()) {
            engine.field_18300.remove(v);
        }
        Map<class_2960, JsonElement> jsons = this.getJsonsInDirectories(resourceManager);
        this.checkConditions(jsons);
        for (class_2960 v : jsons.keySet()) {
            engine.field_18300.put(v, new class_702.class_4090());
        }
    }

    @Override
    protected void process(Map<class_2960, JsonElement> obj, DynamicOps<JsonElement> ops) {
        class_702 particleEngine = class_310.method_1551().field_1713;
        for (Map.Entry<class_2960, JsonElement> j : obj.entrySet()) {
            try {
                JsonElement json = j.getValue();
                class_2960 id = j.getKey();
                CustomParticleFactory factory = (CustomParticleFactory)((Pair)CUSTOM_OR_SEMI_CUSTOM_CODEC.decode(ops, (Object)json).getOrThrow(errorMsg -> new IllegalStateException("Could not decode Custom Particle with json id " + String.valueOf(id) + "\n error: " + errorMsg))).getFirst();
                factory.setSpriteSet((class_702.class_4090)class_310.method_1551().field_1713.field_18300.get(id));
                this.customParticleFactories.register(id, factory);
                class_2400 type = PlatStuff.makeParticleType();
                PlatStuff.registerDynamic(class_7923.field_41180, id, type);
                particleEngine.method_3043((class_2396)type, (class_707)factory);
                Polytone.LOGGER.info("Registered Custom Particle {}", (Object)id);
            }
            catch (Exception e) {
                Polytone.LOGGER.error("!!!!!!!!!!!! Failed to load Custom Particle {}", (Object)j.getKey(), (Object)e);
            }
        }
    }

    public Codec<CustomParticleFactory> byNameCodec() {
        return this.customParticleFactories;
    }
}

