/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.lightmap;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.HashMap;
import java.util.Map;
import net.mehvahdjukaar.polytone.PlatStuff;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.lightmap.Lightmap;
import net.mehvahdjukaar.polytone.utils.ArrayImage;
import net.mehvahdjukaar.polytone.utils.JsonImgPartialReloader;
import net.mehvahdjukaar.polytone.utils.LegacyHelper;
import net.mehvahdjukaar.polytone.utils.MapRegistry;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_765;

public class LightmapsManager
extends JsonImgPartialReloader {
    public static final class_2960 GUI_LIGHTMAP = Polytone.res("lightmaps/gui.png");
    private final MapRegistry<Lightmap> lightmaps = new MapRegistry("Lightmaps");
    private final Map<class_5321<class_1959>, Lightmap> biomeLightmaps = new HashMap<class_5321<class_1959>, Lightmap>();
    private class_5321<class_1937> lastDimension = null;
    private Lightmap currentLightmap = null;
    private boolean reachedMainMenuHack = false;
    private boolean usingGuiLightmap = false;

    public LightmapsManager() {
        super("lightmaps");
    }

    @Override
    protected JsonImgPartialReloader.Resources prepare(class_3300 resourceManager) {
        Map<class_2960, JsonElement> jsons = this.getJsonsInDirectories(resourceManager);
        this.checkConditions(jsons);
        HashMap<class_2960, ArrayImage> textures = new HashMap<class_2960, ArrayImage>();
        Map<class_2960, ArrayImage> ofTextures = ArrayImage.scanDirectory(resourceManager, "optifine/lightmap");
        Map<class_2960, ArrayImage> cmTextures = ArrayImage.scanDirectory(resourceManager, "colormatic/lightmap");
        textures.putAll(LegacyHelper.convertPaths(ofTextures));
        textures.putAll(LegacyHelper.convertPaths(cmTextures));
        textures.putAll(this.getImagesInDirectories(resourceManager));
        return new JsonImgPartialReloader.Resources(jsons, textures);
    }

    @Override
    public void process(JsonImgPartialReloader.Resources resources, DynamicOps<JsonElement> ops) {
        Map<class_2960, ArrayImage> images = resources.textures();
        Map<class_2960, JsonElement> jsons = resources.jsons();
        this.lastDimension = null;
        this.currentLightmap = null;
        HashMap<class_2960, Map> grouped = new HashMap<class_2960, Map>();
        for (Map.Entry<class_2960, ArrayImage> entry : images.entrySet()) {
            ArrayImage value = entry.getValue();
            int height = value.height();
            class_2960 location = entry.getKey();
            if (height != 16 && height != 32 && height != 64) {
                throw new IllegalStateException("Lightmap must be either 16, 32 or 64 pixels tall. Provided one at " + String.valueOf(location) + " was " + height + " pixels");
            }
            String path = location.method_12832();
            if (path.endsWith("_thunder")) {
                grouped.computeIfAbsent(location.method_45136(path.replace("_thunder", "")), g -> new HashMap()).put("thunder", value);
                continue;
            }
            if (path.endsWith("_rain")) {
                grouped.computeIfAbsent(location.method_45136(path.replace("_rain", "")), g -> new HashMap()).put("rain", value);
                continue;
            }
            grouped.computeIfAbsent(location, g -> new HashMap()).put("normal", value);
        }
        for (Map.Entry<Object, ArrayImage> entry : grouped.entrySet()) {
            class_2960 location = (class_2960)entry.getKey();
            JsonElement j = jsons.remove(location);
            Lightmap lightmap = j != null ? (Lightmap)((Pair)Lightmap.DIRECT_CODEC.decode(ops, (Object)j).getOrThrow(errorMsg -> new IllegalStateException("Could not decode Lightmap with json id " + String.valueOf(location) + "\n error: " + errorMsg))).getFirst() : new Lightmap();
            Map map = (Map)((Object)entry.getValue());
            lightmap.acceptImages((ArrayImage)map.get("normal"), (ArrayImage)map.get("rain"), (ArrayImage)map.get("thunder"));
            this.lightmaps.register(location, lightmap);
        }
        if (!jsons.isEmpty()) {
            throw new IllegalStateException("Found some lightmaps .jsons with no associated textures at" + String.valueOf(jsons));
        }
    }

    @Override
    protected void reset() {
        this.lightmaps.clear();
    }

    public boolean maybeModifyLightTexture(class_765 instance, class_1011 lightPixels, class_1043 lightTexture, class_310 minecraft, class_638 level, float flicker, float partialTicks) {
        if (this.lastDimension != level.method_27983()) {
            this.reachedMainMenuHack = true;
            this.lastDimension = level.method_27983();
            this.currentLightmap = this.lightmaps.getValue(this.lastDimension.method_29177());
        }
        if (this.usingGuiLightmap) {
            boolean bl = true;
        }
        if (this.currentLightmap != null) {
            this.currentLightmap.applyToLightTexture(instance, lightPixels, lightTexture, minecraft, level, flicker, partialTicks);
            return true;
        }
        return false;
    }

    public void setupForGUI(boolean gui) {
        this.usingGuiLightmap = gui;
    }

    public boolean isGui() {
        if (!this.reachedMainMenuHack && !PlatStuff.isModStateValid()) {
            return false;
        }
        return this.usingGuiLightmap;
    }

    public Codec<Lightmap> byNameCodec() {
        return this.lightmaps;
    }
}

