/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.item;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.colormap.Colormap;
import net.mehvahdjukaar.polytone.colormap.ColormapsManager;
import net.mehvahdjukaar.polytone.item.IPolytoneItem;
import net.mehvahdjukaar.polytone.item.ItemModifier;
import net.mehvahdjukaar.polytone.utils.ArrayImage;
import net.mehvahdjukaar.polytone.utils.JsonImgPartialReloader;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_7923;

public class ItemModifiersManager
extends JsonImgPartialReloader {
    private final Map<class_1792, ItemModifier> modifiers = new HashMap<class_1792, ItemModifier>();
    private final Map<class_1792, ItemModifier> vanillaProperties = new HashMap<class_1792, ItemModifier>();

    public ItemModifiersManager() {
        super("item_modifiers", "item_properties");
    }

    public void earlyProcess(class_3300 resourceManager) {
        Map<class_2960, JsonElement> jsons = this.getJsonsInDirectories(resourceManager);
        for (Map.Entry<class_2960, JsonElement> e : jsons.entrySet()) {
            JsonElement json = e.getValue();
            class_2960 id = e.getKey();
            ItemModifier.Partial partial = (ItemModifier.Partial)((Pair)ItemModifier.CODEC_PARTIAL.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(errorMsg -> new IllegalStateException("Could not decode Item Modifier with json id " + String.valueOf(id) + "\n error: " + errorMsg))).getFirst();
            if (partial.customModels().isEmpty()) continue;
            for (class_1792 item : partial.getTargets(id, class_7923.field_41178)) {
                Polytone.ITEM_MODELS.addModelFromModifier(item, partial.customModels());
            }
        }
    }

    @Override
    public void process(JsonImgPartialReloader.Resources resources, DynamicOps<JsonElement> ops) {
        Map<class_2960, JsonElement> jsons = resources.jsons();
        Map<class_2960, ArrayImage> textures = resources.textures();
        HashSet<class_2960> usedTextures = new HashSet<class_2960>();
        HashMap<class_2960, ItemModifier> parsedModifiers = new HashMap<class_2960, ItemModifier>();
        for (Map.Entry<class_2960, JsonElement> entry : jsons.entrySet()) {
            JsonElement json = entry.getValue();
            class_2960 location = entry.getKey();
            ItemModifier modifier = (ItemModifier)((Pair)ItemModifier.CODEC.decode(ops, (Object)json).getOrThrow(errorMsg -> new IllegalStateException("Could not decode Item Modifier with json id " + String.valueOf(location) + "\n error: " + errorMsg))).getFirst();
            parsedModifiers.put(location, modifier);
        }
        for (Map.Entry<Object, Object> entry : parsedModifiers.entrySet()) {
            class_2960 tintId = (class_2960)entry.getKey();
            ItemModifier modifier = (ItemModifier)entry.getValue();
            if (!modifier.hasTint() && textures.containsKey(tintId)) {
                modifier = modifier.merge(ItemModifier.ofItemColor(Colormap.createDefTriangle()));
            }
            class_2960 barId = tintId.method_48331("_bar");
            if (!modifier.hasBarColor() && textures.containsKey(barId)) {
                modifier = modifier.merge(ItemModifier.ofBarColor(Colormap.createDamage()));
            }
            ColormapsManager.tryAcceptingTexture(textures, tintId, modifier.getTint(), usedTextures, true);
            ColormapsManager.tryAcceptingTexture(textures, barId, modifier.getBarColor(), usedTextures, true);
            this.addModifier(tintId, modifier);
        }
        textures.keySet().removeAll(usedTextures);
        for (Map.Entry<Object, Object> entry : textures.entrySet()) {
            Colormap defaultColormap;
            class_2960 id = (class_2960)entry.getKey();
            if (id.method_12832().endsWith("_bar")) {
                defaultColormap = Colormap.createDamage();
                ColormapsManager.tryAcceptingTexture(textures, id, (Object)defaultColormap, usedTextures, true);
                this.addModifier(id, ItemModifier.ofBarColor(defaultColormap));
                continue;
            }
            defaultColormap = Colormap.createDefTriangle();
            ColormapsManager.tryAcceptingTexture(textures, id, (Object)defaultColormap, usedTextures, true);
            this.addModifier(id, ItemModifier.ofItemColor(defaultColormap));
        }
    }

    private void addModifier(class_2960 id, ItemModifier mod) {
        for (class_1792 item : mod.getTargets(id, class_7923.field_41178)) {
            this.modifiers.merge(item, mod, ItemModifier::merge);
        }
    }

    @Override
    protected void reset() {
        for (Map.Entry<class_1792, ItemModifier> e : this.vanillaProperties.entrySet()) {
            e.getValue().apply(e.getKey());
            ((IPolytoneItem)e.getKey()).polytone$setModifier(null);
        }
        this.modifiers.clear();
    }

    @Override
    protected void apply() {
        for (Map.Entry<class_1792, ItemModifier> e : this.modifiers.entrySet()) {
            class_1792 target = e.getKey();
            ItemModifier modifier = e.getValue();
            this.vanillaProperties.put(target, modifier.apply(target));
            if (!modifier.shouldAttachToItem()) continue;
            ((IPolytoneItem)e.getKey()).polytone$setModifier(modifier);
        }
        if (!this.vanillaProperties.isEmpty()) {
            Polytone.LOGGER.info("Applied {} Custom Item Properties", (Object)this.vanillaProperties.size());
        }
        this.modifiers.clear();
    }
}

