/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.item;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.mehvahdjukaar.polytone.PlatStuff;
import net.mehvahdjukaar.polytone.item.ItemModelOverride;
import net.mehvahdjukaar.polytone.utils.DepthSearchTrie;
import net.mehvahdjukaar.polytone.utils.FrequencyOrderedCollection;
import net.minecraft.class_1087;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_5455;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9336;
import org.jetbrains.annotations.Nullable;

public class ItemModelOverrideList {
    private final PropertiesSearchTrie overrides = new PropertiesSearchTrie();
    private final List<ItemModelOverride> entries = new ArrayList<ItemModelOverride>();
    private boolean populated = false;

    public void populateModels(class_5455 registryAccess) {
        this.overrides.clear();
        this.overrides.acceptEntries(this.entries, registryAccess);
        this.populated = true;
        this.entries.clear();
    }

    public void addAll(Collection<ItemModelOverride> itemModelOverrides) {
        this.entries.addAll(itemModelOverrides);
    }

    public void add(ItemModelOverride itemModelOverride) {
        this.entries.add(itemModelOverride);
    }

    @Nullable
    public class_1087 getModel(class_1799 stack, @Nullable class_1937 level, @Nullable class_1309 entity, int seed) {
        if (!this.populated) {
            return null;
        }
        return this.overrides.searchModel(stack, level, (class_1297)entity);
    }

    public int size() {
        return this.entries.size();
    }

    public static void testTrie() {
    }

    public static class PropertiesSearchTrie
    extends DepthSearchTrie<Object, Object, ItemModelOverride, class_1799> {
        private final List<class_9331<?>> orderedKeys = new ArrayList();

        @Override
        public void clear() {
            super.clear();
            this.orderedKeys.clear();
        }

        public class_1087 searchModel(class_1799 stack, @Nullable class_1937 level, @Nullable class_1297 entity) {
            List list = this.search(stack);
            if (list == null || list.isEmpty()) {
                return null;
            }
            class_2561 customName = (class_2561)stack.method_57824(class_9334.field_49631);
            for (ItemModelOverride modelOverride : list) {
                Supplier entityTagSupplier;
                if (!modelOverride.matchesPredicate(stack, level, (java.util.function.Supplier<class_2487>)(entityTagSupplier = entity == null ? null : Suppliers.memoize(() -> entity.method_5647(new class_2487()))), customName)) continue;
                return PlatStuff.getBakedModel(modelOverride.model());
            }
            return null;
        }

        @Override
        protected Object getKeyOfType(Object folder) {
            if (folder instanceof class_9336) {
                class_9336 t = (class_9336)folder;
                return t.comp_2443();
            }
            if (folder instanceof Integer) {
                return Integer.class;
            }
            return folder;
        }

        @Override
        protected Object getKeyFromType(Object type, class_1799 stack) {
            if (type instanceof class_9331) {
                class_9331 t = (class_9331)type;
                return stack.method_57353().method_57834(t);
            }
            if (type == Integer.class) {
                return stack.method_7947();
            }
            return null;
        }

        public void acceptEntries(List<ItemModelOverride> entries, class_5455 registryAccess) {
            boolean hasCount = false;
            FrequencyOrderedCollection<class_9331> keyFrequencies = new FrequencyOrderedCollection<class_9331>();
            for (ItemModelOverride entry : entries) {
                if (entry.stackCount() != null) {
                    hasCount = true;
                }
                for (class_9336 component : entry.getComponents(registryAccess)) {
                    keyFrequencies.add(component.comp_2443());
                }
            }
            this.orderedKeys.addAll(keyFrequencies.stream().toList());
            for (ItemModelOverride entry : entries) {
                ArrayList<Integer> key = new ArrayList<Integer>();
                if (hasCount) {
                    key.add(entry.stackCount());
                }
                for (class_9331<?> type : this.orderedKeys) {
                    key.add((Integer)entry.getComponents(registryAccess).method_57834(type));
                }
                this.insert(key, entry);
            }
        }
    }
}

