/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.item;

import com.google.gson.JsonParseException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import net.mehvahdjukaar.polytone.colormap.ColormapExpressionProvider;
import net.mehvahdjukaar.polytone.utils.ClientFrameTicker;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.minecraft.class_5699;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_9323;
import org.jetbrains.annotations.Nullable;

public class ItemModelOverride {
    @Nullable
    protected final Dynamic<?> lazyComponent;
    @Nullable
    protected final Integer stackCount;
    @Nullable
    protected final Pattern pattern;
    @Nullable
    protected final class_2487 entityTag;
    @Nullable
    protected final ColormapExpressionProvider expression;
    protected final Map<class_2960, Float> predicates;
    protected class_2960 model;
    protected class_9323 decodedComponents;
    protected static final Codec<Map<class_2960, Float>> ITEM_PREDICATE_CODEC = Codec.unboundedMap((Codec)class_2960.field_25139, (Codec)Codec.FLOAT);
    public static final Codec<ItemModelOverride> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.PASSTHROUGH.fieldOf("components").forGetter(o -> o.lazyComponent), (App)class_2960.field_25139.fieldOf("model").forGetter(ItemModelOverride::model), (App)Codec.INT.optionalFieldOf("stack_count").forGetter(i -> Optional.ofNullable(i.stackCount())), (App)class_5699.field_37408.optionalFieldOf("name_pattern").forGetter(i -> Optional.ofNullable(i.namePattern())), (App)class_2487.field_25128.optionalFieldOf("entity_tag").forGetter(i -> Optional.ofNullable(i.entityTag)), (App)ColormapExpressionProvider.CODEC.optionalFieldOf("expression").forGetter(i -> Optional.ofNullable(i.expression)), (App)ITEM_PREDICATE_CODEC.optionalFieldOf("predicates", Map.of()).forGetter(i -> i.predicates)).apply((Applicative)instance, ItemModelOverride::new));

    public ItemModelOverride(Dynamic<?> lazyComponent, class_2960 model, Optional<Integer> stackCount, Optional<Pattern> pattern, Optional<class_2487> entityTag, Optional<ColormapExpressionProvider> expression, Map<class_2960, Float> predicates) {
        this.lazyComponent = lazyComponent;
        this.model = model;
        this.stackCount = stackCount.orElse(null);
        this.pattern = pattern.orElse(null);
        this.entityTag = entityTag.orElse(null);
        this.expression = expression.orElse(null);
        this.predicates = predicates;
    }

    public ItemModelOverride(class_9323 map, class_2960 model) {
        this.lazyComponent = null;
        this.model = model;
        this.stackCount = null;
        this.pattern = null;
        this.decodedComponents = map;
        this.entityTag = null;
        this.expression = null;
        this.predicates = Map.of();
    }

    public class_9323 getComponents(class_5455 registryAccess) {
        if (this.decodedComponents == null && this.lazyComponent != null) {
            this.decodedComponents = ItemModelOverride.runCodec(registryAccess, this.lazyComponent);
        }
        return this.decodedComponents;
    }

    private static <T> class_9323 runCodec(class_5455 ra, Dynamic<T> dynamic) {
        class_6903 ops = class_6903.method_46632((DynamicOps)dynamic.getOps(), (class_7225.class_7874)ra);
        return (class_9323)((Pair)class_9323.field_50234.decode((DynamicOps)ops, dynamic.getValue()).result().orElseThrow(() -> new JsonParseException("Failed to decode components map"))).getFirst();
    }

    public class_2960 model() {
        return this.model;
    }

    @Nullable
    public Integer stackCount() {
        return this.stackCount;
    }

    @Nullable
    public Pattern namePattern() {
        return this.pattern;
    }

    @Nullable
    public class_2487 entityTag() {
        return this.entityTag;
    }

    public boolean matchesPredicate(class_1799 stack, @Nullable class_1937 level, @Nullable Supplier<class_2487> entityTagGetter, @Nullable class_2561 customName) {
        class_2338 pos;
        class_2487 tag;
        if (this.pattern != null && customName != null && !this.pattern.matcher(customName.getString()).matches()) {
            return false;
        }
        if (this.entityTag != null && entityTagGetter != null && !this.containsTag(tag = entityTagGetter.get(), this.entityTag)) {
            return false;
        }
        return this.expression == null || this.expression.getValue(null, pos = ClientFrameTicker.getCameraPos(), null, null, stack) != 0.0f;
    }

    private boolean containsTag(class_2487 tagToMatch, class_2487 entityTag) {
        for (String key : tagToMatch.method_10541()) {
            class_2520 t = entityTag.method_10580(key);
            if (t == null) {
                return false;
            }
            if (t instanceof class_2487) {
                class_2487 ct = (class_2487)t;
                class_2487 compound = tagToMatch.method_10562(key);
                if (compound.method_33133()) {
                    return false;
                }
                if (this.containsTag(compound, ct)) continue;
                return false;
            }
            if (t.equals((Object)entityTag.method_10580(key))) continue;
            return false;
        }
        return true;
    }
}

