/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.fluid;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.colormap.Colormap;
import net.mehvahdjukaar.polytone.colormap.ColormapsManager;
import net.mehvahdjukaar.polytone.fluid.FluidPropertyModifier;
import net.mehvahdjukaar.polytone.fluid.fabric.FluidPropertiesManagerImpl;
import net.mehvahdjukaar.polytone.utils.ArrayImage;
import net.mehvahdjukaar.polytone.utils.JsonImgPartialReloader;
import net.mehvahdjukaar.polytone.utils.LegacyHelper;
import net.minecraft.class_2960;
import net.minecraft.class_322;
import net.minecraft.class_3300;
import net.minecraft.class_3611;
import net.minecraft.class_7923;

public class FluidPropertiesManager
extends JsonImgPartialReloader {
    private final Map<class_3611, FluidPropertyModifier> modifiers = new HashMap<class_3611, FluidPropertyModifier>();
    private Map<class_2960, FluidPropertyModifier> extraModifiers;
    private Map<class_2960, ArrayImage> extraImages;

    public FluidPropertiesManager() {
        super("fluid_modifiers", "fluid_properties");
    }

    public void addConvertedBlockProperties(Map<class_2960, FluidPropertyModifier> modifiers, Map<class_2960, ArrayImage> textures) {
        this.extraImages = textures;
        this.extraModifiers = modifiers;
    }

    @Override
    protected JsonImgPartialReloader.Resources prepare(class_3300 resourceManager) {
        Map<class_2960, JsonElement> jsons = this.getJsonsInDirectories(resourceManager);
        this.checkConditions(jsons);
        HashMap<class_2960, ArrayImage> textures = new HashMap<class_2960, ArrayImage>();
        Map<class_2960, ArrayImage> cmTextures = ArrayImage.scanDirectory(resourceManager, "colormatic/colormap");
        textures.putAll(LegacyHelper.convertPaths(cmTextures));
        textures.putAll(this.getImagesInDirectories(resourceManager));
        return new JsonImgPartialReloader.Resources(jsons, textures);
    }

    @Override
    public void process(JsonImgPartialReloader.Resources resources, DynamicOps<JsonElement> ops) {
        class_2960 id;
        Map<class_2960, JsonElement> jsons = resources.jsons();
        Map<class_2960, ArrayImage> textures = resources.textures();
        HashSet<class_2960> usedTextures = new HashSet<class_2960>();
        HashMap<class_2960, FluidPropertyModifier> parsedModifiers = new HashMap<class_2960, FluidPropertyModifier>(this.extraModifiers);
        textures.putAll(this.extraImages);
        for (Map.Entry<class_2960, JsonElement> entry : jsons.entrySet()) {
            JsonElement json = entry.getValue();
            class_2960 id2 = entry.getKey();
            FluidPropertyModifier modifier = (FluidPropertyModifier)((Pair)FluidPropertyModifier.CODEC.decode(ops, (Object)json).getOrThrow(errorMsg -> new IllegalStateException("Could not decode Fluid Modifier with json id " + String.valueOf(id2) + "\n error: " + errorMsg))).getFirst();
            if (parsedModifiers.containsKey(id2)) {
                Polytone.LOGGER.warn("Found duplicate fluid modifier with id {}. This is likely a non .json converted legacy oneOverriding previous one", (Object)id2);
            }
            parsedModifiers.put(id2, modifier);
        }
        for (Map.Entry<Object, Object> entry : parsedModifiers.entrySet()) {
            id = (class_2960)entry.getKey();
            FluidPropertyModifier modifier = (FluidPropertyModifier)entry.getValue();
            if (!modifier.hasColormap() && textures.containsKey(id)) {
                modifier = modifier.merge(FluidPropertyModifier.ofBlockColor(Colormap.createDefTriangle()));
            }
            class_322 tint = modifier.getTint();
            ColormapsManager.tryAcceptingTexture(textures, id, tint, usedTextures, true);
            this.addModifier(id, modifier);
        }
        textures.keySet().removeAll(usedTextures);
        for (Map.Entry<Object, Object> entry : textures.entrySet()) {
            id = (class_2960)entry.getKey();
            Colormap defaultColormap = Colormap.createDefTriangle();
            ColormapsManager.tryAcceptingTexture(textures, id, (Object)defaultColormap, usedTextures, true);
            this.addModifier(id, new FluidPropertyModifier(Optional.of(defaultColormap), Optional.empty(), Set.of()));
        }
    }

    @Override
    protected void apply() {
        super.apply();
        if (!this.modifiers.isEmpty()) {
            Polytone.LOGGER.info("Applied {} Fluid Modifiers", (Object)this.modifiers.size());
        }
    }

    @Override
    protected void reset() {
        this.modifiers.clear();
        FluidPropertiesManager.clearSpecial();
    }

    private void addModifier(class_2960 pathId, FluidPropertyModifier mod) {
        for (class_3611 fluid : mod.getTargets(pathId, class_7923.field_41173)) {
            this.modifiers.merge(fluid, mod, FluidPropertyModifier::merge);
            FluidPropertiesManager.tryAddSpecial(fluid, mod);
        }
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static void tryAddSpecial(class_3611 fluid, FluidPropertyModifier colormap) {
        void var1_1;
        FluidPropertiesManagerImpl.tryAddSpecial(fluid, (FluidPropertyModifier)var1_1);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static void clearSpecial() {
        FluidPropertiesManagerImpl.clearSpecial();
    }

    public FluidPropertyModifier getModifier(class_3611 water) {
        return this.modifiers.get(water);
    }
}

