/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.dimension;

import com.google.gson.JsonElement;
import com.llamalad7.mixinextras.sugar.ref.LocalFloatRef;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.objects.Object2BooleanArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.block.BlockContextExpression;
import net.mehvahdjukaar.polytone.colormap.Colormap;
import net.mehvahdjukaar.polytone.colormap.ColormapsManager;
import net.mehvahdjukaar.polytone.dimension.DimensionEffectsModifier;
import net.mehvahdjukaar.polytone.utils.ArrayImage;
import net.mehvahdjukaar.polytone.utils.ClientFrameTicker;
import net.mehvahdjukaar.polytone.utils.JsonImgPartialReloader;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_322;
import net.minecraft.class_4543;
import net.minecraft.class_5455;
import net.minecraft.class_638;
import net.minecraft.class_6491;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class DimensionEffectsManager
extends JsonImgPartialReloader {
    private final Map<class_2960, DimensionEffectsModifier> effectsToApply = new HashMap<class_2960, DimensionEffectsModifier>();
    private final Map<class_2960, DimensionEffectsModifier> vanillaEffects = new HashMap<class_2960, DimensionEffectsModifier>();
    private final Object2ObjectMap<class_2874, Colormap> fogColormaps = new Object2ObjectArrayMap();
    private final Object2ObjectMap<class_2874, Colormap> skyColormaps = new Object2ObjectArrayMap();
    private final Object2ObjectMap<class_2874, BlockContextExpression> cloudFunctions = new Object2ObjectArrayMap();
    private final Object2BooleanArrayMap<class_2874> cancelFogWeatherDarken = new Object2BooleanArrayMap();
    private final Object2BooleanArrayMap<class_2874> cancelSkyWeatherDarken = new Object2BooleanArrayMap();
    private boolean needsDynamicApplication = true;
    private final Map<class_2960, DimensionEffectsModifier> extraMods = new HashMap<class_2960, DimensionEffectsModifier>();

    public DimensionEffectsManager() {
        super("dimension_modifiers", "dimension_effects");
    }

    @Override
    public void reset() {
        this.needsDynamicApplication = true;
        this.effectsToApply.clear();
        this.fogColormaps.clear();
        this.skyColormaps.clear();
        this.cancelFogWeatherDarken.clear();
        this.cancelSkyWeatherDarken.clear();
        this.cloudFunctions.clear();
        this.extraMods.clear();
    }

    @Override
    protected void process(JsonImgPartialReloader.Resources resources, DynamicOps<JsonElement> ops) {
        class_2960 id;
        Map<class_2960, JsonElement> jsons = resources.jsons();
        Map<class_2960, ArrayImage> textures = resources.textures();
        HashSet<class_2960> usedTextures = new HashSet<class_2960>();
        HashMap<class_2960, DimensionEffectsModifier> parsedModifiers = new HashMap<class_2960, DimensionEffectsModifier>(this.extraMods);
        for (Map.Entry<class_2960, JsonElement> entry : jsons.entrySet()) {
            JsonElement json = entry.getValue();
            class_2960 id2 = entry.getKey();
            DimensionEffectsModifier modifier = (DimensionEffectsModifier)((Pair)DimensionEffectsModifier.CODEC.decode(ops, (Object)json).getOrThrow(errorMsg -> new IllegalStateException("Could not decode Dimension Effects with json id " + String.valueOf(id2) + " - error: " + errorMsg))).getFirst();
            if (parsedModifiers.containsKey(id2)) {
                Polytone.LOGGER.warn("Found duplicate Dimension Effects file with id {}.Overriding previous one", (Object)id2);
            }
            parsedModifiers.put(id2, modifier);
        }
        for (Map.Entry<Object, Object> entry : parsedModifiers.entrySet()) {
            class_2960 fogId;
            class_2960 skyId;
            id = (class_2960)entry.getKey();
            DimensionEffectsModifier modifier = (DimensionEffectsModifier)entry.getValue();
            class_322 fog = modifier.getFogColormap();
            class_322 sky = modifier.getSkyColormap();
            if (textures.containsKey(id) && fog == null && sky == null) {
                modifier = modifier.merge(DimensionEffectsModifier.ofFogColor(Colormap.createDefTriangle()));
                fog = modifier.getFogColormap();
            }
            if (textures.containsKey(skyId = id.method_48331("_sky")) && sky == null) {
                modifier = modifier.merge(DimensionEffectsModifier.ofSkyColor(Colormap.createDefTriangle()));
                sky = modifier.getSkyColormap();
            }
            if (textures.containsKey(fogId = id.method_48331("_fog")) && sky == null) {
                modifier = modifier.merge(DimensionEffectsModifier.ofFogColor(Colormap.createDefTriangle()));
                fog = modifier.getFogColormap();
            }
            if (fog != null ^ sky != null) {
                ColormapsManager.tryAcceptingTexture(textures, id, fog, usedTextures, false);
                ColormapsManager.tryAcceptingTexture(textures, id, sky, usedTextures, false);
            }
            ColormapsManager.tryAcceptingTexture(textures, fogId, fog, usedTextures, true);
            ColormapsManager.tryAcceptingTexture(textures, skyId, sky, usedTextures, true);
            this.addModifier(id, modifier);
        }
        textures.keySet().removeAll(usedTextures);
        for (Map.Entry<Object, Object> entry : textures.entrySet()) {
            id = (class_2960)entry.getKey();
            Colormap defaultColormap = Colormap.createDefTriangle();
            ColormapsManager.tryAcceptingTexture(textures, id, (Object)defaultColormap, usedTextures, true);
            this.addModifier(id, DimensionEffectsModifier.ofFogColor(defaultColormap));
        }
    }

    private void addModifier(class_2960 fileId, DimensionEffectsModifier mod) {
        for (class_2960 id : mod.getTargetsKeys(fileId)) {
            this.effectsToApply.merge(id, mod, DimensionEffectsModifier::merge);
        }
    }

    @Override
    protected void applyWithLevel(class_5455 registryAccess, boolean firstLogin) {
        if (!firstLogin && !this.needsDynamicApplication) {
            return;
        }
        this.needsDynamicApplication = false;
        for (Map.Entry<class_2960, DimensionEffectsModifier> v : this.vanillaEffects.entrySet()) {
            v.getValue().applyInplace(v.getKey());
        }
        class_2378 dimReg = registryAccess.method_30530(class_7924.field_41241);
        for (Map.Entry<class_2960, DimensionEffectsModifier> v : this.effectsToApply.entrySet()) {
            Colormap c;
            class_2960 dimensionId = v.getKey();
            DimensionEffectsModifier modifier = v.getValue();
            DimensionEffectsModifier old = modifier.applyInplace(dimensionId);
            this.vanillaEffects.put(dimensionId, old);
            class_2874 dim = (class_2874)dimReg.method_10223(dimensionId);
            class_322 class_3222 = modifier.getFogColormap();
            if (class_3222 instanceof Colormap) {
                c = (Colormap)class_3222;
                this.fogColormaps.put((Object)dim, (Object)c);
            }
            if ((class_3222 = modifier.getSkyColormap()) instanceof Colormap) {
                c = (Colormap)class_3222;
                this.skyColormaps.put((Object)dim, (Object)c);
            }
            if (modifier.noWeatherFogDarken()) {
                this.cancelFogWeatherDarken.put((Object)dim, true);
            }
            if (modifier.noWeatherSkyDarken()) {
                this.cancelSkyWeatherDarken.put((Object)dim, true);
            }
            if (!modifier.cloudLevel().isPresent() || !modifier.cloudLevel().get().right().isPresent()) continue;
            this.cloudFunctions.put((Object)dim, (Object)((BlockContextExpression)modifier.cloudLevel().get().right().get()));
        }
        if (!this.vanillaEffects.isEmpty()) {
            Polytone.LOGGER.info("Applied {} Dimension Modifiers", (Object)this.vanillaEffects.size());
        }
    }

    @Nullable
    public class_243 modifyFogColor(class_243 center, class_638 level, float brightness) {
        Colormap colormap = (Colormap)this.fogColormaps.get((Object)level.method_8597());
        if (colormap == null) {
            return null;
        }
        class_4543 biomeManager = level.method_22385();
        return level.method_28103().method_28112(class_6491.method_24895((class_243)center, (qx, qy, qz) -> {
            class_1959 biome = (class_1959)biomeManager.method_24854(qx, qy, qz).comp_349();
            int fogColor1 = colormap.sampleColor(null, class_2338.method_49637((double)(qx * 4), (double)(qy * 4), (double)(qz * 4)), biome, null);
            return class_243.method_24457((int)fogColor1);
        }), brightness);
    }

    public void modifyFogMagicNumber(float renderDistanceChunks, LocalFloatRef distance) {
        float c = 0.25f;
        float b = c + (1.0f - c) * renderDistanceChunks / 32.0f;
        b = 1.0f - (float)Math.pow(b, 0.25);
        float a = 1.0f * renderDistanceChunks / 32.0f;
        a = 1.0f - (float)Math.pow(a, 0.25);
        distance.set(b);
    }

    @Nullable
    public class_243 modifySkyColor(class_243 center, class_638 level) {
        Colormap colormap = (Colormap)this.skyColormaps.get((Object)level.method_8597());
        if (colormap == null) {
            return null;
        }
        class_4543 biomeManager = level.method_22385();
        return class_6491.method_24895((class_243)center, (qx, qy, qz) -> {
            class_1959 biome = (class_1959)biomeManager.method_24854(qx, qy, qz).comp_349();
            int skyColor1 = colormap.sampleColor(null, class_2338.method_49637((double)(qx * 4), (double)(qy * 4), (double)(qz * 4)), biome, null);
            return class_243.method_24457((int)skyColor1);
        });
    }

    @Nullable
    public Float modifyCloudHeight(class_638 level) {
        BlockContextExpression height = (BlockContextExpression)this.cloudFunctions.get((Object)level.method_8597());
        if (height == null) {
            return null;
        }
        class_2338 pos = ClientFrameTicker.getCameraPos();
        double v = height.getValue((class_1937)level, pos, class_2246.field_10124.method_9564());
        if (v >= 10000.0) {
            return Float.valueOf(Float.NaN);
        }
        return Float.valueOf((float)v);
    }

    public boolean shouldCancelFogWeatherDarken(class_1937 level) {
        return this.cancelFogWeatherDarken.getOrDefault((Object)level.method_8597(), false);
    }

    public boolean shouldCancelSkyWeatherDarken(class_1937 level) {
        return this.cancelSkyWeatherDarken.getOrDefault((Object)level.method_8597(), false);
    }

    public void addConvertedBlockProperties(Map<class_2960, DimensionEffectsModifier> converted) {
        this.extraMods.clear();
        this.extraMods.putAll(converted);
    }
}

