/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.block;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.block.BlockClientTickable;
import net.mehvahdjukaar.polytone.block.BlockPropertyModifier;
import net.mehvahdjukaar.polytone.colormap.ColormapsManager;
import net.mehvahdjukaar.polytone.colormap.IColorGetter;
import net.mehvahdjukaar.polytone.colormap.IndexCompoundColorGetter;
import net.mehvahdjukaar.polytone.particle.BlockParticleEmitter;
import net.mehvahdjukaar.polytone.sound.BlockSoundEmitter;
import net.mehvahdjukaar.polytone.utils.ArrayImage;
import net.mehvahdjukaar.polytone.utils.LegacyHelper;
import net.mehvahdjukaar.polytone.utils.PartialReloader;
import net.mehvahdjukaar.polytone.utils.PropertiesUtils;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_322;
import net.minecraft.class_3300;
import net.minecraft.class_4309;
import net.minecraft.class_7923;

public class BlockPropertiesManager
extends PartialReloader<Resources> {
    private final Map<class_2248, BlockPropertyModifier> vanillaProperties = new HashMap<class_2248, BlockPropertyModifier>();
    private final Map<class_2248, BlockPropertyModifier> modifiers = new HashMap<class_2248, BlockPropertyModifier>();
    private final Map<class_2248, List<BlockClientTickable>> particleAndSoundEmitters = new Object2ObjectOpenHashMap();
    private final Map<class_2960, String> optifineColormapsToBlocks = new HashMap<class_2960, String>();

    public BlockPropertiesManager() {
        super("block_modifiers", "block_properties");
    }

    @Override
    protected Resources prepare(class_3300 resourceManager) {
        Map<class_2960, JsonElement> jsons = this.getJsonsInDirectories(resourceManager);
        this.checkConditions(jsons);
        HashMap<class_2960, ArrayImage> textures = new HashMap<class_2960, ArrayImage>();
        Map<class_2960, ArrayImage> ofTextures = ArrayImage.scanDirectory(resourceManager, "optifine/colormap");
        Map<class_2960, ArrayImage> cmTextures = ArrayImage.scanDirectory(resourceManager, "colormatic/colormap");
        Map<class_2960, Properties> ofProperties = PropertiesUtils.gatherProperties(resourceManager, "optifine/colormap");
        HashMap<class_2960, JsonElement> ofJsons = new HashMap<class_2960, JsonElement>();
        class_4309.method_51148((class_3300)resourceManager, (String)"optifine/colormap", (Gson)GSON, ofJsons);
        this.checkConditions(ofJsons);
        ofJsons.forEach((k, v) -> ofProperties.put((class_2960)k, PropertiesUtils.jsonToProperties(v)));
        textures.putAll(LegacyHelper.convertPaths(ofTextures));
        textures.putAll(LegacyHelper.convertPaths(cmTextures));
        textures.putAll(this.getImagesInDirectories(resourceManager));
        return new Resources(jsons, textures, LegacyHelper.convertPaths(ofProperties));
    }

    @Override
    public void process(Resources resources, DynamicOps<JsonElement> ops) {
        class_2960 id;
        Map<class_2960, JsonElement> jsons = resources.jsons();
        Map<class_2960, ArrayImage.Group> textures = ArrayImage.groupTextures(resources.textures());
        HashSet<class_2960> usedTextures = new HashSet<class_2960>();
        HashMap<class_2960, BlockPropertyModifier> parsedModifiers = new HashMap<class_2960, BlockPropertyModifier>();
        parsedModifiers.putAll(LegacyHelper.convertBlockProperties(resources.ofProperties, resources.textures));
        parsedModifiers.putAll(LegacyHelper.convertInlinedPalettes(this.optifineColormapsToBlocks));
        LegacyHelper.convertOfBlockToFluidProp(parsedModifiers, resources.textures);
        LegacyHelper.convertOfBlockToDimensionProperties(parsedModifiers, resources.textures);
        for (Map.Entry<class_2960, JsonElement> entry : jsons.entrySet()) {
            JsonElement json = entry.getValue();
            class_2960 id2 = entry.getKey();
            BlockPropertyModifier prop = (BlockPropertyModifier)((Pair)BlockPropertyModifier.CODEC.decode(ops, (Object)json).getOrThrow(errorMsg -> new IllegalStateException("Could not decode Client Block Property with json id " + String.valueOf(id2) + "\n error: " + errorMsg))).getFirst();
            if (parsedModifiers.containsKey(id2)) {
                Polytone.LOGGER.warn("Found duplicate block modifier with id {}. This is likely a non .json converted legacy oneOverriding previous one", (Object)id2);
            }
            parsedModifiers.put(id2, prop);
        }
        for (Map.Entry<Object, Object> entry : parsedModifiers.entrySet()) {
            id = (class_2960)entry.getKey();
            BlockPropertyModifier modifier = (BlockPropertyModifier)entry.getValue();
            if (!modifier.hasColormap() && textures.containsKey(id)) {
                ArrayImage.Group text = textures.get(id);
                IndexCompoundColorGetter defaultSampler = IndexCompoundColorGetter.createDefault((Set<Integer>)text.keySet(), true);
                modifier = modifier.merge(BlockPropertyModifier.ofBlockColor(defaultSampler));
            }
            IColorGetter tint = modifier.getColormap();
            ColormapsManager.tryAcceptingTextureGroup(textures, id, tint, usedTextures, true);
            this.addModifier(id, modifier);
        }
        textures.keySet().removeAll(usedTextures);
        for (Map.Entry<Object, Object> entry : textures.entrySet()) {
            id = (class_2960)entry.getKey();
            ArrayImage.Group image = (ArrayImage.Group)((Object)entry.getValue());
            IndexCompoundColorGetter tintMap = IndexCompoundColorGetter.createDefault((Set<Integer>)image.keySet(), true);
            ColormapsManager.tryAcceptingTextureGroup(textures, id, (class_322)tintMap, usedTextures, true);
            BlockPropertyModifier modifier = BlockPropertyModifier.ofBlockColor(tintMap);
            this.addModifier(id, modifier);
        }
    }

    private void addModifier(class_2960 fileId, BlockPropertyModifier mod) {
        for (class_2248 block : mod.getTargets(fileId, class_7923.field_41175)) {
            this.modifiers.merge(block, mod, BlockPropertyModifier::merge);
        }
    }

    @Override
    public void reset() {
        for (Map.Entry<class_2248, BlockPropertyModifier> e : this.vanillaProperties.entrySet()) {
            e.getValue().apply(e.getKey());
        }
        this.vanillaProperties.clear();
        this.modifiers.clear();
        this.optifineColormapsToBlocks.clear();
        this.particleAndSoundEmitters.clear();
    }

    @Override
    public void apply() {
        for (Map.Entry<class_2248, BlockPropertyModifier> e : this.modifiers.entrySet()) {
            class_2248 target = e.getKey();
            BlockPropertyModifier value = e.getValue();
            this.vanillaProperties.put(target, value.apply(target));
            Optional<List<BlockParticleEmitter>> particle = value.particleEmitters();
            particle.ifPresent(emitters -> this.particleAndSoundEmitters.computeIfAbsent(target, t -> new ArrayList()).addAll(emitters));
            Optional<List<BlockSoundEmitter>> sound = value.soundEmitters();
            sound.ifPresent(emitters -> this.particleAndSoundEmitters.computeIfAbsent(target, t -> new ArrayList()).addAll(emitters));
        }
        if (!this.vanillaProperties.isEmpty()) {
            Polytone.LOGGER.info("Applied {} Block Modifiers", (Object)this.vanillaProperties.size());
        }
        this.modifiers.clear();
    }

    public void addSimpleColormap(class_2960 path, String str) {
        this.optifineColormapsToBlocks.put(path, str);
    }

    public void maybeEmitParticle(class_2248 block, class_2680 state, class_1937 level, class_2338 pos) {
        List<BlockClientTickable> m = this.particleAndSoundEmitters.get(block);
        if (m != null) {
            for (BlockClientTickable p : m) {
                p.tick(level, pos, state);
            }
        }
    }

    public record Resources(Map<class_2960, JsonElement> jsons, Map<class_2960, ArrayImage> textures, Map<class_2960, Properties> ofProperties) {
    }
}

