/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.biome;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.Map;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.biome.BiomeIdMapper;
import net.mehvahdjukaar.polytone.utils.JsonPartialReloader;
import net.mehvahdjukaar.polytone.utils.MapRegistry;
import net.minecraft.class_2960;

public class BiomeIdMapperManager
extends JsonPartialReloader {
    private final MapRegistry<BiomeIdMapper> biomeIdMappers = new MapRegistry("Biome ID Mappers");

    public BiomeIdMapperManager() {
        super("biome_id_mappers");
    }

    @Override
    protected void reset() {
        this.biomeIdMappers.clear();
    }

    @Override
    protected void process(Map<class_2960, JsonElement> obj, DynamicOps<JsonElement> ops) {
        for (Map.Entry<class_2960, JsonElement> j : obj.entrySet()) {
            JsonElement json = j.getValue();
            class_2960 id = j.getKey();
            BiomeIdMapper mapper = (BiomeIdMapper)((Pair)BiomeIdMapper.CODEC.decode(ops, (Object)json).getOrThrow(errorMsg -> new IllegalStateException("Could not decode Biome ID mapper with json id " + String.valueOf(id) + "\n error: " + errorMsg))).getFirst();
            try {
                this.biomeIdMappers.register(id, mapper);
            }
            catch (Exception e) {
                Polytone.LOGGER.warn("Found duplicate biome in biome id mapper {}", (Object)id);
            }
        }
    }

    public Codec<BiomeIdMapper> byNameCodec() {
        return this.biomeIdMappers;
    }
}

