/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.biome;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.biome.BiomeEffectModifier;
import net.mehvahdjukaar.polytone.utils.JsonPartialReloader;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_241;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4763;
import net.minecraft.class_5455;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_746;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class BiomeEffectsManager
extends JsonPartialReloader {
    private final Map<class_2960, class_4763> vanillaEffects = new HashMap<class_2960, class_4763>();
    private final Map<class_2960, BiomeEffectModifier> effectsToApply = new HashMap<class_2960, BiomeEffectModifier>();
    private boolean needsDynamicApplication = true;
    private final Map<class_2960, JsonElement> lazyJsons = new HashMap<class_2960, JsonElement>();
    private final Map<class_1959, BiomeEffectModifier> fogParametersModifiers = new HashMap<class_1959, BiomeEffectModifier>();
    private static float lastFogStart = 1.0f;
    private static float lastFogEnd = 1.0f;

    public BiomeEffectsManager() {
        super("biome_modifiers", "biome_effects");
    }

    @Override
    public void process(Map<class_2960, JsonElement> biomesJsons, DynamicOps<JsonElement> ops) {
        this.lazyJsons.clear();
        this.lazyJsons.putAll(biomesJsons);
    }

    @Override
    public void applyWithLevel(class_5455 access, boolean firstLogin) {
        for (Map.Entry<class_2960, JsonElement> j : this.lazyJsons.entrySet()) {
            JsonElement json = j.getValue();
            class_2960 id = j.getKey();
            BiomeEffectModifier effect = (BiomeEffectModifier)((Pair)BiomeEffectModifier.CODEC.decode((DynamicOps)class_6903.method_46632((DynamicOps)JsonOps.INSTANCE, (class_7225.class_7874)access), (Object)json).getOrThrow(errorMsg -> new IllegalStateException("Could not decode Biome Special Effect with json id " + String.valueOf(id) + "\n error: " + errorMsg))).getFirst();
            this.addEffect(id, effect);
        }
        this.lazyJsons.clear();
        this.doApplyWithLevel(access, firstLogin);
    }

    private void addEffect(class_2960 pathId, BiomeEffectModifier mod) {
        Set<class_2960> explTargets = mod.explicitTargets();
        if (!explTargets.isEmpty()) {
            for (class_2960 explicitId : explTargets) {
                this.effectsToApply.merge(explicitId, mod, BiomeEffectModifier::merge);
            }
        } else {
            this.effectsToApply.merge(pathId, mod, BiomeEffectModifier::merge);
        }
    }

    @Override
    public void apply() {
    }

    private void doApplyWithLevel(class_5455 registryAccess, boolean firstLogin) {
        if (!firstLogin && !this.needsDynamicApplication) {
            return;
        }
        this.needsDynamicApplication = false;
        if (firstLogin) {
            this.vanillaEffects.clear();
        }
        class_2378 biomeReg = (class_2378)registryAccess.method_33310(class_7924.field_41236).get();
        for (Map.Entry<class_2960, BiomeEffectModifier> v : this.effectsToApply.entrySet()) {
            class_2960 biomeId = v.getKey();
            BiomeEffectModifier modifier = v.getValue();
            Optional biome = biomeReg.method_17966(biomeId);
            if (!biome.isPresent()) continue;
            class_4763 old = modifier.apply((class_1959)biome.get());
            this.vanillaEffects.put(biomeId, old);
            if (!modifier.modifyFogParameter()) continue;
            this.fogParametersModifiers.put((class_1959)biome.get(), modifier);
        }
        if (!this.vanillaEffects.isEmpty()) {
            Polytone.LOGGER.info("Applied {} Custom Biome Effects Properties", (Object)this.vanillaEffects.size());
        }
    }

    @Override
    public void reset() {
        this.needsDynamicApplication = true;
        class_638 level = class_310.method_1551().field_1687;
        if (level != null) {
            class_2378 biomeReg = (class_2378)level.method_30349().method_33310(class_7924.field_41236).get();
            for (Map.Entry<class_2960, class_4763> v : this.vanillaEffects.entrySet()) {
                Optional biome = biomeReg.method_17966(v.getKey());
                biome.ifPresent(bio -> BiomeEffectModifier.applyEffects(bio, (class_4763)v.getValue()));
            }
        }
        this.vanillaEffects.clear();
        this.effectsToApply.clear();
        this.fogParametersModifiers.clear();
    }

    @Nullable
    public class_241 modifyFogParameters(float originalNearPlane, float originalFarPlane) {
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        if (player == null) {
            return null;
        }
        class_1937 level = player.method_37908();
        class_6880 biome = level.method_23753(player.method_24515());
        BiomeEffectModifier fogMod = this.fogParametersModifiers.get(biome.comp_349());
        class_241 targetFog = null;
        if (fogMod != null) {
            targetFog = fogMod.modifyFogParameters(level);
        }
        if (targetFog == null && (class_3532.method_15379((float)(lastFogStart - 1.0f)) > 0.02f || class_3532.method_15379((float)(lastFogEnd - 1.0f)) > 0.02f)) {
            targetFog = new class_241(1.0f, 1.0f);
        }
        if (targetFog != null) {
            float deltaTime = class_310.method_1551().method_60646().method_60638();
            float interpolationFactor = deltaTime * 0.1f;
            lastFogStart = class_3532.method_16439((float)interpolationFactor, (float)lastFogStart, (float)targetFog.field_1343);
            lastFogEnd = class_3532.method_16439((float)interpolationFactor, (float)lastFogEnd, (float)targetFog.field_1342);
            float distance = originalFarPlane - originalNearPlane;
            return new class_241((originalFarPlane - distance * lastFogStart) * lastFogEnd, originalFarPlane * lastFogEnd);
        }
        return null;
    }
}

