/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.frapi.mesh;

import net.caffeinemc.mods.sodium.client.render.frapi.mesh.EncodingFormat;
import net.caffeinemc.mods.sodium.client.render.frapi.mesh.MeshImpl;
import net.caffeinemc.mods.sodium.client.render.frapi.mesh.MutableQuadViewImpl;
import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.MeshBuilder;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;

public class MeshBuilderImpl
implements MeshBuilder {
    private int[] data = new int[256];
    private int index = 0;
    private int limit = this.data.length;
    private final Maker maker = new Maker();

    public MeshBuilderImpl() {
        this.ensureCapacity(EncodingFormat.TOTAL_STRIDE);
        this.maker.data = this.data;
        this.maker.baseIndex = this.index;
        this.maker.clear();
    }

    protected void ensureCapacity(int stride) {
        if (stride > this.limit - this.index) {
            this.limit *= 2;
            int[] bigger = new int[this.limit];
            System.arraycopy(this.data, 0, bigger, 0, this.index);
            this.data = bigger;
            this.maker.data = this.data;
        }
    }

    public QuadEmitter getEmitter() {
        this.maker.clear();
        return this.maker;
    }

    public Mesh build() {
        int[] packed = new int[this.index];
        System.arraycopy(this.data, 0, packed, 0, this.index);
        this.maker.baseIndex = this.index = 0;
        this.maker.clear();
        return new MeshImpl(packed);
    }

    private class Maker
    extends MutableQuadViewImpl {
        private Maker() {
        }

        @Override
        public void emitDirectly() {
            this.computeGeometry();
            MeshBuilderImpl.this.index += EncodingFormat.TOTAL_STRIDE;
            MeshBuilderImpl.this.ensureCapacity(EncodingFormat.TOTAL_STRIDE);
            this.baseIndex = MeshBuilderImpl.this.index;
        }
    }
}

