/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.api.vertex.buffer;

import net.caffeinemc.mods.sodium.api.memory.MemoryIntrinsics;
import net.minecraft.class_293;
import net.minecraft.class_4588;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.MemoryStack;

public interface VertexBufferWriter {
    public static VertexBufferWriter of(class_4588 consumer) {
        VertexBufferWriter writer;
        if (consumer instanceof VertexBufferWriter && (writer = (VertexBufferWriter)consumer).canUseIntrinsics()) {
            return writer;
        }
        throw VertexBufferWriter.createUnsupportedVertexConsumerThrowable(consumer);
    }

    @Nullable
    public static VertexBufferWriter tryOf(class_4588 consumer) {
        VertexBufferWriter writer;
        if (consumer instanceof VertexBufferWriter && (writer = (VertexBufferWriter)consumer).canUseIntrinsics()) {
            return writer;
        }
        return null;
    }

    private static RuntimeException createUnsupportedVertexConsumerThrowable(class_4588 consumer) {
        Class clazz = consumer.getClass();
        String name = clazz.getName();
        return new IllegalArgumentException("The class %s does not implement interface VertexBufferWriter, which is required for compatibility with Sodium (see: https://github.com/CaffeineMC/sodium-fabric/issues/1620)".formatted(name));
    }

    public void push(MemoryStack var1, long var2, int var4, class_293 var5);

    default public boolean canUseIntrinsics() {
        return true;
    }

    public static void copyInto(VertexBufferWriter writer, MemoryStack stack, long ptr, int count, class_293 format) {
        int length = count * format.method_1362();
        long copy = stack.nmalloc(length);
        MemoryIntrinsics.copyMemory(ptr, copy, length);
        writer.push(stack, copy, count, format);
    }
}

