/*
 * Decompiled with CFR 0.152.
 */
package foundationgames.enhancedblockentities.client.resource.template;

import foundationgames.enhancedblockentities.client.resource.template.TemplateDefinitions;
import foundationgames.enhancedblockentities.client.resource.template.TemplateLoader;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TemplateProvider {
    private final TemplateLoader loader;
    private final TemplateDefinitions.Impl definitions = new TemplateDefinitions.Impl();
    private final Deque<String> loaded = new ArrayDeque<String>();

    public TemplateProvider(TemplateLoader loader) {
        this.loader = loader;
    }

    public String load(String templatePath, Consumer<TemplateDefinitions> definitions) throws IOException {
        this.definitions.push();
        definitions.accept(this.definitions);
        try {
            HashMap<String, String> substitutions = new HashMap<String, String>();
            for (Map.Entry<String, TemplateApplyingFunction> entry : this.definitions) {
                substitutions.put(entry.getKey(), entry.getValue().getAndApplyTemplate(this));
            }
            String templateRaw = this.loader.getOrLoadRaw(templatePath);
            Matcher matcher = Pattern.compile("!\\[(" + String.join((CharSequence)"|", substitutions.keySet()) + ")]").matcher(templateRaw);
            StringBuilder result = new StringBuilder();
            while (matcher.find()) {
                matcher.appendReplacement(result, (String)substitutions.get(matcher.group(1)));
            }
            matcher.appendTail(result);
            this.definitions.pop();
            return result.toString();
        }
        catch (IOException ex) {
            this.definitions.pop();
            throw ex;
        }
    }

    @FunctionalInterface
    public static interface TemplateApplyingFunction {
        public String getAndApplyTemplate(TemplateProvider var1) throws IOException;
    }
}

