/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.processor.simple;

import java.util.function.Supplier;
import me.pepperbell.continuity.api.client.ProcessingDataProvider;
import me.pepperbell.continuity.client.processor.ConnectionPredicate;
import me.pepperbell.continuity.client.processor.DirectionMaps;
import me.pepperbell.continuity.client.processor.OrientationMode;
import me.pepperbell.continuity.client.processor.ProcessingDataKeys;
import me.pepperbell.continuity.client.processor.simple.HorizontalSpriteProvider;
import me.pepperbell.continuity.client.processor.simple.SpriteProvider;
import me.pepperbell.continuity.client.properties.OrientedConnectingCtmProperties;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadView;
import net.minecraft.class_1058;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class HorizontalVerticalSpriteProvider
extends HorizontalSpriteProvider {
    protected static final int[] SECONDARY_SPRITE_INDEX_MAP = new int[]{3, 3, 6, 3, 3, 3, 3, 3, 3, 3, 6, 3, 3, 3, 3, 3, 4, 4, 5, 4, 4, 4, 4, 4, 3, 3, 6, 3, 3, 3, 3, 3, 3, 3, 6, 3, 3, 3, 3, 3, 3, 3, 6, 3, 3, 3, 3, 3, 3, 3, 6, 3, 3, 3, 3, 3, 3, 3, 6, 3, 3, 3, 3, 3};

    public HorizontalVerticalSpriteProvider(class_1058[] sprites, ConnectionPredicate connectionPredicate, boolean innerSeams, OrientationMode orientationMode) {
        super(sprites, connectionPredicate, innerSeams, orientationMode);
    }

    @Override
    @Nullable
    public class_1058 getSprite(QuadView quad, class_1058 sprite, class_1920 blockView, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, ProcessingDataProvider dataProvider) {
        class_2338.class_2339 mutablePos;
        class_2350[] directions = DirectionMaps.getDirections(this.orientationMode, quad, state);
        int connections = this.getConnections(directions, mutablePos = dataProvider.getData(ProcessingDataKeys.MUTABLE_POS_KEY), blockView, state, pos, quad.lightFace(), sprite);
        if (connections != 0) {
            return this.sprites[SPRITE_INDEX_MAP[connections]];
        }
        int secondaryConnections = this.getSecondaryConnections(directions, mutablePos, blockView, state, pos, quad.lightFace(), sprite);
        return this.sprites[SECONDARY_SPRITE_INDEX_MAP[secondaryConnections]];
    }

    protected int getSecondaryConnections(class_2350[] directions, class_2338.class_2339 mutablePos, class_1920 blockView, class_2680 state, class_2338 pos, class_2350 face, class_1058 quadSprite) {
        int connections = 0;
        for (int i = 0; i < 2; ++i) {
            class_2350 direction = directions[i * 2 + 1];
            mutablePos.method_25505((class_2382)pos, direction);
            if (!this.connectionPredicate.shouldConnect(blockView, state, pos, mutablePos, face, quadSprite, this.innerSeams)) continue;
            connections |= 1 << i * 3 + 1;
            for (int j = 0; j < 2; ++j) {
                mutablePos.method_25505((class_2382)pos, direction).method_10098(directions[(i + j) % 2 * 2]);
                if (!this.connectionPredicate.shouldConnect(blockView, state, pos, mutablePos, face, quadSprite, this.innerSeams)) continue;
                connections |= 1 << i * 3 + j * 2;
            }
        }
        return connections;
    }

    public static class Factory
    implements SpriteProvider.Factory<OrientedConnectingCtmProperties> {
        @Override
        public SpriteProvider createSpriteProvider(class_1058[] sprites, OrientedConnectingCtmProperties properties) {
            return new HorizontalVerticalSpriteProvider(sprites, properties.getConnectionPredicate(), properties.getInnerSeams(), properties.getOrientationMode());
        }

        @Override
        public int getTextureAmount(OrientedConnectingCtmProperties properties) {
            return 7;
        }
    }
}

