/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.debugify.mixinplugin;

import dev.isxander.debugify.Debugify;
import dev.isxander.debugify.api.DebugifyApi;
import dev.isxander.debugify.fixes.BugFixData;
import dev.isxander.debugify.mixinplugin.BugFixDataCache;
import dev.isxander.debugify.mixinplugin.DebugifyErrorHandler;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class MixinPlugin
implements IMixinConfigPlugin {
    public void onLoad(String mixinPackage) {
        Debugify.onPreInitialize();
        List entrypoints = FabricLoader.getInstance().getEntrypointContainers("debugify", DebugifyApi.class);
        entrypoints.forEach(container -> {
            DebugifyApi api = (DebugifyApi)container.getEntrypoint();
            String containerModId = container.getProvider().getMetadata().getId();
            for (String bugId : api.getDisabledFixes()) {
                BugFixData.registerApiConflict(containerModId, bugId);
            }
            api.getProvidedDisabledFixes().forEach((modId, bugs) -> {
                if (FabricLoader.getInstance().isModLoaded(modId)) {
                    bugs.forEach(bugId -> BugFixData.registerApiConflict(modId, bugId));
                }
            });
        });
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        Optional<BugFixData> bugFixOptional = BugFixDataCache.getOrResolve(mixinClassName);
        if (bugFixOptional.isEmpty()) {
            return true;
        }
        BugFixData bugFix = bugFixOptional.get();
        boolean multipleMixins = Debugify.CONFIG.getBugFixes().containsKey(bugFix);
        Debugify.CONFIG.registerBugFix(bugFix);
        if (DebugifyErrorHandler.hasErrored(bugFix)) {
            Debugify.LOGGER.warn("Preventing loading of {} mixin, {} because another mixin for the same bug fix failed to apply.", (Object)bugFix.bugId(), (Object)mixinClassName);
            return false;
        }
        Set<String> conflicts = bugFix.getActiveConflicts();
        if (!conflicts.isEmpty()) {
            if (Debugify.CONFIG.isBugFixEnabled(bugFix) && !multipleMixins) {
                Debugify.LOGGER.warn("Force disabled {} because it's conflicting with: {}", (Object)bugFix.bugId(), (Object)String.join((CharSequence)", ", conflicts));
            }
            return false;
        }
        if (!bugFix.satisfiesOSRequirement()) {
            if (Debugify.CONFIG.isBugFixEnabled(bugFix) && !multipleMixins) {
                Debugify.LOGGER.warn("Force disabled {} because it only applies to OS: {}", (Object)bugFix.bugId(), (Object)bugFix.requiredOs().name());
            }
            return false;
        }
        return Debugify.CONFIG.isBugFixEnabled(bugFix);
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

