/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.ingredients.itemStacks;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.time.Duration;
import java.util.Optional;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.library.ingredients.itemStacks.FullTypedItemStack;
import mezz.jei.library.ingredients.itemStacks.NormalizedTypedItemStack;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_6880;

public abstract class TypedItemStack
implements ITypedIngredient<class_1799> {
    private static final LoadingCache<TypedItemStack, class_1799> CACHE = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofSeconds(1L)).build((CacheLoader)new CacheLoader<TypedItemStack, class_1799>(){

        public class_1799 load(TypedItemStack key) {
            return key.createItemStackUncached();
        }
    });

    public static ITypedIngredient<class_1799> create(class_1799 ingredient) {
        if (ingredient.method_7947() == 1) {
            return NormalizedTypedItemStack.create((class_6880<class_1792>)ingredient.method_41409(), ingredient.method_57380());
        }
        return new FullTypedItemStack((class_6880<class_1792>)ingredient.method_41409(), ingredient.method_57380(), ingredient.method_7947());
    }

    public static ITypedIngredient<class_1799> normalize(ITypedIngredient<class_1799> typedIngredient) {
        if (typedIngredient instanceof TypedItemStack) {
            TypedItemStack typedItemStack = (TypedItemStack)typedIngredient;
            return typedItemStack.getNormalized();
        }
        class_1799 itemStack = typedIngredient.getIngredient();
        return NormalizedTypedItemStack.create((class_6880<class_1792>)itemStack.method_41409(), itemStack.method_57380());
    }

    @Override
    public final class_1799 getIngredient() {
        return (class_1799)CACHE.getUnchecked((Object)this);
    }

    @Override
    public final Optional<class_1799> getItemStack() {
        return Optional.of(this.getIngredient());
    }

    @Override
    public final IIngredientType<class_1799> getType() {
        return VanillaTypes.ITEM_STACK;
    }

    protected abstract TypedItemStack getNormalized();

    protected abstract class_1799 createItemStackUncached();
}

