/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.helpers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import mezz.jei.api.helpers.ICodecHelper;
import mezz.jei.api.ingredients.IIngredientSupplier;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IFocusFactory;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.codecs.EnumCodec;
import mezz.jei.common.codecs.TupleCodec;
import mezz.jei.common.codecs.TypedIngredientCodecs;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_8786;
import org.jetbrains.annotations.Nullable;

public class CodecHelper
implements ICodecHelper {
    private static final Codec<class_8786<?>> RECIPE_HOLDER_CODEC = Codec.lazyInitialized(() -> {
        class_310 minecraft = class_310.method_1551();
        class_638 level = minecraft.field_1687;
        assert (level != null);
        class_1863 recipeManager = level.method_8433();
        return Codec.either((Codec)class_2960.field_25139, TupleCodec.of(class_2960.field_25139, class_1860.field_47319)).flatXmap(either -> (DataResult)either.map(recipeHolderId -> recipeManager.method_8130(recipeHolderId).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Could not find recipe for key: " + String.valueOf(recipeHolderId))), pair -> {
            class_2960 recipeHolderId = (class_2960)pair.getFirst();
            class_1860 recipe = (class_1860)pair.getSecond();
            if (recipe == null) {
                return DataResult.error(() -> "Could not find recipe for key: " + String.valueOf(recipeHolderId));
            }
            class_8786 recipeHolder = new class_8786(recipeHolderId, recipe);
            return DataResult.success((Object)recipeHolder);
        }), recipeHolder -> {
            class_2960 recipeHolderId = recipeHolder.comp_1932();
            Optional found = recipeManager.method_8130(recipeHolderId);
            if (found.isPresent() && ((class_8786)found.get()).equals(recipeHolder)) {
                return DataResult.success((Object)Either.left((Object)recipeHolderId));
            }
            class_1860 recipe = recipeHolder.comp_1933();
            return DataResult.success((Object)Either.right((Object)Pair.of((Object)recipeHolderId, (Object)recipe)));
        });
    });
    private final IIngredientManager ingredientManager;
    private final IFocusFactory focusFactory;
    private final Map<RecipeType<?>, Codec<?>> defaultRecipeCodecs = new HashMap();
    @Nullable
    private Codec<RecipeType<?>> recipeTypeCodec;

    public CodecHelper(IIngredientManager ingredientManager, IFocusFactory focusFactory) {
        this.ingredientManager = ingredientManager;
        this.focusFactory = focusFactory;
    }

    @Override
    public Codec<IIngredientType<?>> getIngredientTypeCodec() {
        return TypedIngredientCodecs.getIngredientTypeCodec(this.ingredientManager);
    }

    @Override
    public MapCodec<ITypedIngredient<?>> getTypedIngredientCodec() {
        return TypedIngredientCodecs.getIngredientCodec(this.ingredientManager);
    }

    @Override
    public <T> Codec<ITypedIngredient<T>> getTypedIngredientCodec(IIngredientType<T> ingredientType) {
        return TypedIngredientCodecs.getIngredientCodec(ingredientType, this.ingredientManager);
    }

    @Override
    public <T extends class_8786<?>> Codec<T> getRecipeHolderCodec() {
        Codec<class_8786<?>> recipeHolderCodec = RECIPE_HOLDER_CODEC;
        return recipeHolderCodec;
    }

    @Override
    public <T> Codec<T> getSlowRecipeCategoryCodec(IRecipeCategory<T> recipeCategory, IRecipeManager recipeManager) {
        RecipeType<T> recipeType = recipeCategory.getRecipeType();
        Object codec = this.defaultRecipeCodecs.get(recipeType);
        if (codec == null) {
            codec = this.createDefaultRecipeCategoryCodec(recipeManager, recipeCategory);
            this.defaultRecipeCodecs.put(recipeType, (Codec<?>)codec);
        }
        return codec;
    }

    private <T> Codec<T> createDefaultRecipeCategoryCodec(IRecipeManager recipeManager, IRecipeCategory<T> recipeCategory) {
        Codec dataCodec = RecordCodecBuilder.create(builder -> builder.group((App)class_2960.field_25139.fieldOf("registryName").forGetter(Data::registryName), (App)this.getTypedIngredientCodec().codec().fieldOf("ingredient").forGetter(Data::ingredient), (App)EnumCodec.create(RecipeIngredientRole.class, RecipeIngredientRole::valueOf).fieldOf("ingredient_role").forGetter(Data::ingredientRole)).apply((Applicative)builder, Data::new));
        Codec codec = dataCodec.flatXmap(data -> {
            class_2960 registryName = data.registryName();
            ITypedIngredient<?> ingredient = data.ingredient();
            IFocus<?> focus = this.focusFactory.createFocus(data.ingredientRole(), ingredient);
            RecipeType recipeType = recipeCategory.getRecipeType();
            return recipeManager.createRecipeLookup(recipeType).limitFocus(List.of(focus)).get().filter(recipe -> registryName.equals((Object)recipeCategory.getRegistryName(recipe))).findFirst().map(DataResult::success).orElseGet(() -> DataResult.error(() -> "No recipe found for registry name: " + String.valueOf(registryName)));
        }, recipe -> {
            class_2960 registryName = recipeCategory.getRegistryName(recipe);
            if (registryName == null) {
                return DataResult.error(() -> "No registry name for recipe");
            }
            IIngredientSupplier ingredients = recipeManager.getRecipeIngredients(recipeCategory, recipe);
            List<ITypedIngredient<?>> outputs = ingredients.getIngredients(RecipeIngredientRole.OUTPUT);
            if (!outputs.isEmpty()) {
                Data result = new Data(registryName, outputs.getFirst(), RecipeIngredientRole.OUTPUT);
                return DataResult.success((Object)result);
            }
            List<ITypedIngredient<?>> inputs = ingredients.getIngredients(RecipeIngredientRole.INPUT);
            if (!inputs.isEmpty()) {
                Data result = new Data(registryName, inputs.getFirst(), RecipeIngredientRole.INPUT);
                return DataResult.success((Object)result);
            }
            return DataResult.error(() -> "No inputs or outputs for recipe");
        });
        return Codec.withAlternative((Codec)codec, this.createLegacyDefaultRecipeCategoryCodec(recipeManager, recipeCategory));
    }

    private <T> Codec<T> createLegacyDefaultRecipeCategoryCodec(IRecipeManager recipeManager, IRecipeCategory<T> recipeCategory) {
        Codec legacyPairCodec = RecordCodecBuilder.create(builder -> builder.group((App)class_2960.field_25139.fieldOf("registryName").forGetter(Pair::getFirst), (App)this.getTypedIngredientCodec().codec().fieldOf("output").forGetter(Pair::getSecond)).apply((Applicative)builder, Pair::new));
        TupleCodec tupleCodec = TupleCodec.of(class_2960.field_25139, this.getTypedIngredientCodec().codec());
        return Codec.withAlternative(tupleCodec, (Codec)legacyPairCodec).flatXmap(pair -> {
            class_2960 registryName = (class_2960)pair.getFirst();
            ITypedIngredient output = (ITypedIngredient)pair.getSecond();
            IFocus focus = this.focusFactory.createFocus(RecipeIngredientRole.OUTPUT, output);
            RecipeType recipeType = recipeCategory.getRecipeType();
            return recipeManager.createRecipeLookup(recipeType).limitFocus(List.of(focus)).get().filter(recipe -> registryName.equals((Object)recipeCategory.getRegistryName(recipe))).findFirst().map(DataResult::success).orElseGet(() -> DataResult.error(() -> "No recipe found for registry name: " + String.valueOf(registryName)));
        }, recipe -> {
            class_2960 registryName = recipeCategory.getRegistryName(recipe);
            if (registryName == null) {
                return DataResult.error(() -> "No registry name for recipe");
            }
            IIngredientSupplier ingredients = recipeManager.getRecipeIngredients(recipeCategory, recipe);
            List<ITypedIngredient<?>> outputs = ingredients.getIngredients(RecipeIngredientRole.OUTPUT);
            if (outputs.isEmpty()) {
                return DataResult.error(() -> "No outputs for recipe");
            }
            Pair result = new Pair((Object)registryName, outputs.getFirst());
            return DataResult.success((Object)result);
        });
    }

    @Override
    public Codec<RecipeType<?>> getRecipeTypeCodec(IRecipeManager recipeManager) {
        if (this.recipeTypeCodec == null) {
            this.recipeTypeCodec = class_2960.field_25139.flatXmap(resourceLocation -> recipeManager.getRecipeType((class_2960)resourceLocation).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Failed to find recipe type " + String.valueOf(resourceLocation))), recipeType -> {
                class_2960 uid = recipeType.getUid();
                return DataResult.success((Object)uid);
            });
        }
        return this.recipeTypeCodec;
    }

    private record Data(class_2960 registryName, ITypedIngredient<?> ingredient, RecipeIngredientRole ingredientRole) {
    }
}

