/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.input.handlers;

import java.util.function.Supplier;
import mezz.jei.api.gui.inputs.IJeiInputHandler;
import mezz.jei.api.gui.inputs.IJeiUserInput;
import mezz.jei.common.util.MathUtil;
import net.minecraft.class_3675;
import net.minecraft.class_8029;
import net.minecraft.class_8030;

public class OffsetJeiInputHandler
implements IJeiInputHandler {
    private final IJeiInputHandler inputHandler;
    private final Supplier<class_8029> offset;

    public OffsetJeiInputHandler(IJeiInputHandler inputHandler, Supplier<class_8029> offset) {
        this.inputHandler = inputHandler;
        this.offset = offset;
    }

    @Override
    public boolean handleInput(double mouseX, double mouseY, IJeiUserInput input) {
        class_8029 screenPosition = this.offset.get();
        double offsetMouseX = mouseX - (double)screenPosition.comp_1193();
        double offsetMouseY = mouseY - (double)screenPosition.comp_1194();
        class_8030 originalArea = this.inputHandler.getArea();
        if (MathUtil.contains(originalArea, offsetMouseX, offsetMouseY)) {
            class_8029 position = originalArea.comp_1195();
            double relativeMouseX = offsetMouseX - (double)position.comp_1193();
            double relativeMouseY = offsetMouseY - (double)position.comp_1194();
            return this.inputHandler.handleInput(relativeMouseX, relativeMouseY, input);
        }
        return false;
    }

    @Override
    public boolean handleMouseScrolled(double mouseX, double mouseY, double scrollDeltaX, double scrollDeltaY) {
        class_8029 screenPosition = this.offset.get();
        double offsetMouseX = mouseX - (double)screenPosition.comp_1193();
        double offsetMouseY = mouseY - (double)screenPosition.comp_1194();
        class_8030 originalArea = this.inputHandler.getArea();
        if (MathUtil.contains(originalArea, offsetMouseX, offsetMouseY)) {
            class_8029 position = originalArea.comp_1195();
            double relativeMouseX = offsetMouseX - (double)position.comp_1193();
            double relativeMouseY = offsetMouseY - (double)position.comp_1194();
            return this.inputHandler.handleMouseScrolled(relativeMouseX, relativeMouseY, scrollDeltaX, scrollDeltaY);
        }
        return false;
    }

    @Override
    public boolean handleMouseDragged(double mouseX, double mouseY, class_3675.class_306 mouseKey, double dragX, double dragY) {
        class_8029 screenPosition = this.offset.get();
        double offsetMouseX = mouseX - (double)screenPosition.comp_1193();
        double offsetMouseY = mouseY - (double)screenPosition.comp_1194();
        class_8030 originalArea = this.inputHandler.getArea();
        if (MathUtil.contains(originalArea, offsetMouseX, offsetMouseY)) {
            class_8029 position = originalArea.comp_1195();
            double relativeMouseX = offsetMouseX - (double)position.comp_1193();
            double relativeMouseY = offsetMouseY - (double)position.comp_1194();
            return this.inputHandler.handleMouseDragged(relativeMouseX, relativeMouseY, mouseKey, dragX, dragY);
        }
        return false;
    }

    @Override
    public void handleMouseMoved(double mouseX, double mouseY) {
        class_8029 screenPosition = this.offset.get();
        double offsetMouseX = mouseX - (double)screenPosition.comp_1193();
        double offsetMouseY = mouseY - (double)screenPosition.comp_1194();
        class_8030 originalArea = this.inputHandler.getArea();
        if (MathUtil.contains(originalArea, offsetMouseX, offsetMouseY)) {
            class_8029 position = originalArea.comp_1195();
            double relativeMouseX = offsetMouseX - (double)position.comp_1193();
            double relativeMouseY = offsetMouseY - (double)position.comp_1194();
            this.inputHandler.handleMouseMoved(relativeMouseX, relativeMouseY);
        }
    }

    @Override
    public class_8030 getArea() {
        class_8030 area = this.inputHandler.getArea();
        return new class_8030(this.offset.get(), area.comp_1196(), area.comp_1197());
    }
}

