/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.bookmarks;

import java.util.Objects;
import java.util.Optional;
import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.gui.bookmarks.BookmarkType;
import mezz.jei.gui.bookmarks.IBookmark;
import mezz.jei.gui.overlay.elements.IElement;
import mezz.jei.gui.overlay.elements.RecipeBookmarkElement;
import net.minecraft.class_2960;

public class RecipeBookmark<R, I>
implements IBookmark {
    private final IElement<I> element;
    private final IRecipeCategory<R> recipeCategory;
    private final R recipe;
    private final class_2960 recipeUid;
    private final ITypedIngredient<I> displayIngredient;
    private final boolean displayIsOutput;
    private boolean visible = true;

    public static <T> Optional<RecipeBookmark<T, ?>> create(IRecipeLayoutDrawable<T> recipeLayoutDrawable, IIngredientManager ingredientManager) {
        T recipe = recipeLayoutDrawable.getRecipe();
        IRecipeCategory<T> recipeCategory = recipeLayoutDrawable.getRecipeCategory();
        class_2960 recipeUid = recipeCategory.getRegistryName(recipe);
        if (recipeUid == null) {
            return Optional.empty();
        }
        IRecipeSlotsView recipeSlotsView = recipeLayoutDrawable.getRecipeSlotsView();
        Optional outputOptional = recipeSlotsView.getSlotViews(RecipeIngredientRole.OUTPUT).stream().flatMap(IRecipeSlotView::getAllIngredients).findFirst();
        if (outputOptional.isPresent()) {
            ITypedIngredient output = (ITypedIngredient)outputOptional.get();
            output = ingredientManager.normalizeTypedIngredient(output);
            return Optional.of(new RecipeBookmark(recipeCategory, recipe, recipeUid, output, true));
        }
        Optional inputOptional = recipeSlotsView.getSlotViews(RecipeIngredientRole.INPUT).stream().flatMap(IRecipeSlotView::getAllIngredients).findFirst();
        if (inputOptional.isPresent()) {
            ITypedIngredient input = (ITypedIngredient)inputOptional.get();
            input = ingredientManager.normalizeTypedIngredient(input);
            return Optional.of(new RecipeBookmark(recipeCategory, recipe, recipeUid, input, false));
        }
        return Optional.empty();
    }

    public RecipeBookmark(IRecipeCategory<R> recipeCategory, R recipe, class_2960 recipeUid, ITypedIngredient<I> displayIngredient, boolean displayIsOutput) {
        this.recipeCategory = recipeCategory;
        this.recipe = recipe;
        this.recipeUid = recipeUid;
        this.displayIngredient = displayIngredient;
        this.element = new RecipeBookmarkElement(this);
        this.displayIsOutput = displayIsOutput;
    }

    @Override
    public BookmarkType getType() {
        return BookmarkType.RECIPE;
    }

    public IRecipeCategory<R> getRecipeCategory() {
        return this.recipeCategory;
    }

    public R getRecipe() {
        return this.recipe;
    }

    public ITypedIngredient<I> getDisplayIngredient() {
        return this.displayIngredient;
    }

    public boolean isDisplayIsOutput() {
        return this.displayIsOutput;
    }

    @Override
    public IElement<?> getElement() {
        return this.element;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public int hashCode() {
        return Objects.hash(this.recipeUid, this.recipeCategory.getRecipeType());
    }

    public boolean equals(Object obj) {
        if (obj instanceof RecipeBookmark) {
            RecipeBookmark recipeBookmark = (RecipeBookmark)obj;
            return recipeBookmark.recipeUid.equals((Object)this.recipeUid) && this.recipeCategory.getRecipeType().equals(recipeBookmark.recipeCategory.getRecipeType());
        }
        return false;
    }

    public String toString() {
        return "RecipeBookmark{recipeCategory=" + String.valueOf(this.recipeCategory.getRecipeType()) + ", recipe=" + String.valueOf(this.recipe) + ", recipeUid=" + String.valueOf(this.recipeUid) + ", displayIngredient=" + String.valueOf(this.displayIngredient) + ", visible=" + this.visible + "}";
    }
}

