/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.config;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import mezz.jei.common.config.BookmarkTooltipFeature;
import mezz.jei.common.config.GiveMode;
import mezz.jei.common.config.IClientConfig;
import mezz.jei.common.config.IngredientSortStage;
import mezz.jei.common.config.RecipeSorterStage;
import mezz.jei.common.config.file.ConfigValue;
import mezz.jei.common.config.file.IConfigCategoryBuilder;
import mezz.jei.common.config.file.IConfigSchemaBuilder;
import mezz.jei.common.config.file.serializers.EnumSerializer;
import mezz.jei.common.config.file.serializers.ListSerializer;
import mezz.jei.common.platform.Services;
import org.jetbrains.annotations.Nullable;

public final class ClientConfig
implements IClientConfig {
    @Nullable
    private static IClientConfig instance;
    private final Supplier<Boolean> centerSearchBarEnabled;
    private final Supplier<Integer> maxRecipeGuiHeight;
    private final Supplier<GiveMode> giveMode;
    private final Supplier<Boolean> cheatToHotbarUsingHotkeysEnabled;
    private final Supplier<Boolean> showHiddenItemsEnabled;
    private final Supplier<Boolean> addBookmarksToFrontEnabled;
    private final Supplier<List<BookmarkTooltipFeature>> bookmarkTooltipFeatures;
    private final Supplier<Boolean> holdShiftToShowBookmarkTooltipFeaturesEnabled;
    private final Supplier<Boolean> dragToRearrangeBookmarksEnabled;
    private final Supplier<Boolean> lowMemorySlowSearchEnabled;
    private final Supplier<Boolean> catchRenderErrorsEnabled;
    private final Supplier<Boolean> lookupFluidContentsEnabled;
    private final Supplier<Boolean> lookupBlockTagsEnabled;
    private final Supplier<Boolean> showTagRecipesEnabled;
    private final Supplier<Boolean> showCreativeTabNamesEnabled;
    private final Supplier<Integer> dragDelayMs;
    private final Supplier<Integer> smoothScrollRate;
    private final Supplier<List<IngredientSortStage>> ingredientSorterStages;
    private final ConfigValue<List<RecipeSorterStage>> recipeSorterStages;
    private final Supplier<Boolean> tagContentTooltipEnabled;
    private final Supplier<Boolean> hideSingleIngredientTagsEnabled;

    public ClientConfig(IConfigSchemaBuilder schema) {
        instance = this;
        boolean isDev = Services.PLATFORM.getModHelper().isInDev();
        IConfigCategoryBuilder appearance = schema.addCategory("appearance");
        this.centerSearchBarEnabled = appearance.addBoolean("CenterSearch", false, "Move the JEI search bar to the bottom center of the screen.");
        this.maxRecipeGuiHeight = appearance.addInteger("RecipeGuiHeight", 350, 175, Integer.MAX_VALUE, "Max recipe GUI height.");
        IConfigCategoryBuilder cheatMode = schema.addCategory("cheat_mode");
        this.giveMode = cheatMode.addEnum("GiveMode", GiveMode.defaultGiveMode, "Choose if JEI should give ingredients directly to the inventory (INVENTORY) or pick them up with the mouse (MOUSE_PICKUP).");
        this.cheatToHotbarUsingHotkeysEnabled = cheatMode.addBoolean("CheatToHotbarUsingHotkeysEnabled", false, "Enable cheating items into the hotbar by using Shift + numeric keys.");
        this.showHiddenItemsEnabled = cheatMode.addBoolean("ShowHiddenItems", false, "Enable showing items that are not in the creative menu.");
        IConfigCategoryBuilder bookmarks = schema.addCategory("bookmarks");
        this.addBookmarksToFrontEnabled = bookmarks.addBoolean("AddBookmarksToFrontEnabled", false, "Add new bookmarks to the front of the bookmark list instead of the end.");
        this.bookmarkTooltipFeatures = bookmarks.addList("BookmarkTooltipFeatures", BookmarkTooltipFeature.DEFAULT_BOOKMARK_TOOLTIP_FEATURES, new ListSerializer<BookmarkTooltipFeature>(new EnumSerializer<BookmarkTooltipFeature>(BookmarkTooltipFeature.class)), "Extra features for bookmark tooltips.");
        this.holdShiftToShowBookmarkTooltipFeaturesEnabled = bookmarks.addBoolean("HoldShiftToShowBookmarkTooltipFeatures", true, "Hold Shift to show bookmark tooltip features.");
        this.dragToRearrangeBookmarksEnabled = bookmarks.addBoolean("DragToRearrangeBookmarksEnabled", true, "Drag bookmarks to rearrange them in the list.");
        IConfigCategoryBuilder advanced = schema.addCategory("advanced");
        this.lowMemorySlowSearchEnabled = advanced.addBoolean("LowMemorySlowSearchEnabled", false, "Set low-memory mode (makes search very slow but uses less RAM).");
        this.catchRenderErrorsEnabled = advanced.addBoolean("CatchRenderErrorsEnabled", !isDev, "Catch render errors from ingredients and attempt to recover from them instead of crashing.");
        this.lookupFluidContentsEnabled = advanced.addBoolean("lookupFluidContentsEnabled", false, "When looking up recipes with items that contain fluids, also look up recipes for the fluids.");
        this.lookupBlockTagsEnabled = advanced.addBoolean("lookupBlockTagsEnabled", true, "When searching for item tags, also include tags for the default blocks contained in the items.");
        this.showTagRecipesEnabled = advanced.addBoolean("showTagRecipesEnabled", isDev, "Show recipes for ingredient tags like item tags and block tags.");
        this.showCreativeTabNamesEnabled = advanced.addBoolean("showCreativeTabNamesEnabled", false, "Show creative tab names in ingredient tooltips.");
        IConfigCategoryBuilder input = schema.addCategory("input");
        this.dragDelayMs = input.addInteger("dragDelayInMilliseconds", 150, 0, 1000, "Number of milliseconds before a long mouse click is considered a drag operation.");
        this.smoothScrollRate = input.addInteger("smoothScrollRate", 9, 1, 50, "Scroll rate for scrolling the mouse wheel in smooth-scrolling scroll boxes. Measured in pixels.");
        IConfigCategoryBuilder sorting = schema.addCategory("sorting");
        this.ingredientSorterStages = sorting.addList("IngredientSortStages", IngredientSortStage.defaultStages, new ListSerializer<IngredientSortStage>(new EnumSerializer<IngredientSortStage>(IngredientSortStage.class)), "Sorting order for the ingredient list.");
        this.recipeSorterStages = sorting.addList("RecipeSorterStages", RecipeSorterStage.defaultStages, new ListSerializer<RecipeSorterStage>(new EnumSerializer<RecipeSorterStage>(RecipeSorterStage.class)), "Sorting order for displayed recipes.");
        IConfigCategoryBuilder tags = schema.addCategory("tags");
        this.tagContentTooltipEnabled = tags.addBoolean("TagContentTooltipEnabled", true, "Show tag content in tooltips.");
        this.hideSingleIngredientTagsEnabled = tags.addBoolean("HideSingleIngredientTagsEnabled", true, "Hide tags that only have 1 ingredient.");
    }

    @Deprecated
    public static IClientConfig getInstance() {
        Preconditions.checkNotNull((Object)instance);
        return instance;
    }

    @Override
    public boolean isCenterSearchBarEnabled() {
        return this.centerSearchBarEnabled.get();
    }

    @Override
    public boolean isLowMemorySlowSearchEnabled() {
        return this.lowMemorySlowSearchEnabled.get();
    }

    @Override
    public boolean isCatchRenderErrorsEnabled() {
        return this.catchRenderErrorsEnabled.get();
    }

    @Override
    public boolean isCheatToHotbarUsingHotkeysEnabled() {
        return this.cheatToHotbarUsingHotkeysEnabled.get();
    }

    @Override
    public boolean isAddingBookmarksToFrontEnabled() {
        return this.addBookmarksToFrontEnabled.get();
    }

    @Override
    public boolean isLookupFluidContentsEnabled() {
        return this.lookupFluidContentsEnabled.get();
    }

    @Override
    public boolean isLookupBlockTagsEnabled() {
        return this.lookupBlockTagsEnabled.get();
    }

    @Override
    public GiveMode getGiveMode() {
        return this.giveMode.get();
    }

    @Override
    public boolean isShowHiddenItemsEnabled() {
        return this.showHiddenItemsEnabled.get();
    }

    @Override
    public List<BookmarkTooltipFeature> getBookmarkTooltipFeatures() {
        return this.bookmarkTooltipFeatures.get();
    }

    @Override
    public boolean isHoldShiftToShowBookmarkTooltipFeaturesEnabled() {
        return this.holdShiftToShowBookmarkTooltipFeaturesEnabled.get();
    }

    @Override
    public boolean isDragToRearrangeBookmarksEnabled() {
        return this.dragToRearrangeBookmarksEnabled.get();
    }

    @Override
    public int getDragDelayMs() {
        return this.dragDelayMs.get();
    }

    @Override
    public int getSmoothScrollRate() {
        return this.smoothScrollRate.get();
    }

    @Override
    public int getMaxRecipeGuiHeight() {
        return this.maxRecipeGuiHeight.get();
    }

    @Override
    public List<IngredientSortStage> getIngredientSorterStages() {
        return this.ingredientSorterStages.get();
    }

    @Override
    public Set<RecipeSorterStage> getRecipeSorterStages() {
        return Set.copyOf((Collection)this.recipeSorterStages.getValue());
    }

    @Override
    public void enableRecipeSorterStage(RecipeSorterStage stage) {
        List<RecipeSorterStage> recipeSorterStages = this.recipeSorterStages.get();
        if (!recipeSorterStages.contains((Object)stage)) {
            recipeSorterStages = new ArrayList<RecipeSorterStage>(recipeSorterStages);
            recipeSorterStages.add(stage);
            this.recipeSorterStages.set(recipeSorterStages);
        }
    }

    @Override
    public void disableRecipeSorterStage(RecipeSorterStage stage) {
        List<RecipeSorterStage> recipeSorterStages = this.recipeSorterStages.get();
        if (recipeSorterStages.contains((Object)stage)) {
            recipeSorterStages = new ArrayList<RecipeSorterStage>(recipeSorterStages);
            recipeSorterStages.remove((Object)stage);
            this.recipeSorterStages.set(recipeSorterStages);
        }
    }

    @Override
    public boolean isTagContentTooltipEnabled() {
        return this.tagContentTooltipEnabled.get();
    }

    @Override
    public boolean isHideSingleIngredientTagsEnabled() {
        return this.hideSingleIngredientTagsEnabled.get();
    }

    @Override
    public boolean isShowTagRecipesEnabled() {
        return this.showTagRecipesEnabled.get();
    }

    @Override
    public boolean isShowCreativeTabNamesEnabled() {
        return this.showCreativeTabNamesEnabled.get();
    }
}

