/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl;

import com.google.common.base.Preconditions;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IJadeProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.IWailaCommonRegistration;
import snownee.jade.api.view.IServerExtensionProvider;
import snownee.jade.impl.CommonRegistrationSession;
import snownee.jade.impl.PriorityStore;
import snownee.jade.impl.config.PluginConfig;
import snownee.jade.impl.lookup.HierarchyLookup;
import snownee.jade.impl.lookup.PairHierarchyLookup;
import snownee.jade.impl.lookup.WrappedHierarchyLookup;

public class WailaCommonRegistration
implements IWailaCommonRegistration {
    private static final WailaCommonRegistration INSTANCE = new WailaCommonRegistration();
    public final PairHierarchyLookup<IServerDataProvider<BlockAccessor>> blockDataProviders = new PairHierarchyLookup(new HierarchyLookup(class_2248.class), new HierarchyLookup(class_2586.class));
    public final HierarchyLookup<IServerDataProvider<EntityAccessor>> entityDataProviders;
    public final PriorityStore<class_2960, IJadeProvider> priorities;
    public final WrappedHierarchyLookup<IServerExtensionProvider<class_1799>> itemStorageProviders;
    public final WrappedHierarchyLookup<IServerExtensionProvider<class_2487>> fluidStorageProviders;
    public final WrappedHierarchyLookup<IServerExtensionProvider<class_2487>> energyStorageProviders;
    public final WrappedHierarchyLookup<IServerExtensionProvider<class_2487>> progressProviders;
    private CommonRegistrationSession session;

    WailaCommonRegistration() {
        this.blockDataProviders.idMapped();
        this.entityDataProviders = new HierarchyLookup(class_1297.class);
        this.entityDataProviders.idMapped();
        this.priorities = new PriorityStore<class_2960, IJadeProvider>(IJadeProvider::getDefaultPriority, IJadeProvider::getUid);
        this.priorities.setSortingFunction((store, allKeys) -> {
            List keys = allKeys.stream().filter(PluginConfig::isPrimaryKey).sorted(Comparator.comparingInt(store::byKey)).collect(Collectors.toCollection(ArrayList::new));
            allKeys.stream().filter(Predicate.not(PluginConfig::isPrimaryKey)).forEach($ -> {
                int index = keys.indexOf(PluginConfig.getPrimaryKey($));
                keys.add(index + 1, $);
            });
            return keys;
        });
        this.priorities.configurable("jade/sort-order", (Codec<class_2960>)class_2960.field_25139);
        this.itemStorageProviders = new WrappedHierarchyLookup();
        this.fluidStorageProviders = new WrappedHierarchyLookup();
        this.energyStorageProviders = new WrappedHierarchyLookup();
        this.progressProviders = new WrappedHierarchyLookup();
    }

    public static WailaCommonRegistration instance() {
        return INSTANCE;
    }

    @Override
    public void registerBlockDataProvider(IServerDataProvider<BlockAccessor> dataProvider, Class<?> blockOrBlobkEntityClass) {
        if (this.isSessionActive()) {
            this.session.registerBlockDataProvider(dataProvider, blockOrBlobkEntityClass);
        } else {
            this.blockDataProviders.register(blockOrBlobkEntityClass, dataProvider);
        }
    }

    @Override
    public void registerEntityDataProvider(IServerDataProvider<EntityAccessor> dataProvider, Class<? extends class_1297> entityClass) {
        if (this.isSessionActive()) {
            this.session.registerEntityDataProvider(dataProvider, entityClass);
        } else {
            this.entityDataProviders.register(entityClass, dataProvider);
        }
    }

    public List<IServerDataProvider<BlockAccessor>> getBlockNBTProviders(class_2248 block, @Nullable class_2586 blockEntity) {
        if (blockEntity == null) {
            return this.blockDataProviders.first.get(block);
        }
        return this.blockDataProviders.getMerged(block, blockEntity);
    }

    public List<IServerDataProvider<EntityAccessor>> getEntityNBTProviders(class_1297 entity) {
        return this.entityDataProviders.get(entity);
    }

    public void loadComplete() {
        this.blockDataProviders.loadComplete(this.priorities);
        this.entityDataProviders.loadComplete(this.priorities);
        this.itemStorageProviders.loadComplete(this.priorities);
        this.fluidStorageProviders.loadComplete(this.priorities);
        this.energyStorageProviders.loadComplete(this.priorities);
        this.progressProviders.loadComplete(this.priorities);
        this.session = null;
    }

    @Override
    public <T> void registerItemStorage(IServerExtensionProvider<class_1799> provider, Class<? extends T> clazz) {
        if (this.isSessionActive()) {
            this.session.registerItemStorage(provider, clazz);
        } else {
            this.itemStorageProviders.register(clazz, provider);
        }
    }

    @Override
    public <T> void registerFluidStorage(IServerExtensionProvider<class_2487> provider, Class<? extends T> clazz) {
        if (this.isSessionActive()) {
            this.session.registerFluidStorage(provider, clazz);
        } else {
            this.fluidStorageProviders.register(clazz, provider);
        }
    }

    @Override
    public <T> void registerEnergyStorage(IServerExtensionProvider<class_2487> provider, Class<? extends T> clazz) {
        if (this.isSessionActive()) {
            this.session.registerEnergyStorage(provider, clazz);
        } else {
            this.energyStorageProviders.register(clazz, provider);
        }
    }

    @Override
    public <T> void registerProgress(IServerExtensionProvider<class_2487> provider, Class<? extends T> clazz) {
        if (this.isSessionActive()) {
            this.session.registerProgress(provider, clazz);
        } else {
            this.progressProviders.register(clazz, provider);
        }
    }

    public void startSession() {
        if (this.session == null) {
            this.session = new CommonRegistrationSession(this);
        }
        this.session.reset();
    }

    public void endSession() {
        Preconditions.checkState((this.session != null ? 1 : 0) != 0, (Object)"Session not started");
        this.session.end();
    }

    public boolean isSessionActive() {
        return this.session != null && this.session.isActive();
    }
}

