/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.mainmenucredits.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.isxander.mainmenucredits.config.MMCConfigEntry;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;

public class MMCConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("isxander-main-menu-credits.json");
    public final MMCConfigEntry MAIN_MENU = new MMCConfigEntry("main_menu");
    public final MMCConfigEntry PAUSE_MENU = new MMCConfigEntry("pause_menu");

    public void createEmpty() {
        try {
            JsonObject root = new JsonObject();
            this.MAIN_MENU.createEmpty(root);
            this.PAUSE_MENU.createEmpty(root);
            Files.deleteIfExists(CONFIG_PATH);
            Files.writeString(CONFIG_PATH, (CharSequence)GSON.toJson((JsonElement)root), new OpenOption[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void load() {
        try {
            if (Files.notExists(CONFIG_PATH, new LinkOption[0])) {
                this.createEmpty();
                return;
            }
            JsonObject root = (JsonObject)GSON.fromJson(Files.readString(CONFIG_PATH), JsonObject.class);
            this.MAIN_MENU.load(root);
            this.PAUSE_MENU.load(root);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

