/*
 * Decompiled with CFR 0.152.
 */
package dynamic_fps.impl.service;

import dynamic_fps.impl.service.Services;
import dynamic_fps.impl.util.Version;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Optional;

public interface Platform {
    public String getName();

    public Path getCacheDir();

    public Path getConfigDir();

    public boolean isDevelopmentEnvironment();

    public boolean isModLoaded(String var1);

    public Optional<Version> getModVersion(String var1);

    public void registerStartTickEvent(StartTickEvent var1);

    default public boolean isModLoaded(String ... modId) {
        return Arrays.stream(modId).anyMatch(this::isModLoaded);
    }

    public static Platform getInstance() {
        return Services.PLATFORM;
    }

    @FunctionalInterface
    public static interface StartTickEvent {
        public void onStartTick();
    }
}

