/*
 * Decompiled with CFR 0.152.
 */
package dynamic_fps.impl.feature.state;

import dynamic_fps.impl.DynamicFPSMod;
import dynamic_fps.impl.config.DynamicFPSConfig;
import dynamic_fps.impl.config.option.IdleCondition;
import dynamic_fps.impl.feature.battery.BatteryTracker;
import dynamic_fps.impl.service.Platform;
import net.lostluma.battery.api.State;
import net.minecraft.class_156;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWCursorPosCallback;
import org.lwjgl.glfw.GLFWKeyCallback;
import org.lwjgl.glfw.GLFWMouseButtonCallback;
import org.lwjgl.glfw.GLFWScrollCallback;

public class IdleHandler {
    private static boolean active = false;
    private static boolean wasIdle = false;
    private static long previousActivity = 0L;
    private static class_243 prevPosition = class_243.field_1353;
    private static class_243 prevLookAngle = class_243.field_1353;
    @Nullable
    private static GLFWKeyCallback previousKeyCallback;
    @Nullable
    private static GLFWScrollCallback previousScrollCallback;
    @Nullable
    private static GLFWCursorPosCallback previousCursorPosCallback;
    @Nullable
    private static GLFWMouseButtonCallback previousMouseClickCallback;

    public static void init() {
        if (active) {
            return;
        }
        DynamicFPSConfig config = DynamicFPSConfig.INSTANCE;
        if (config.idle().timeout() == 0) {
            return;
        }
        if (config.idle().condition() == IdleCondition.ON_BATTERY && !BatteryTracker.hasBatteries()) {
            return;
        }
        active = true;
        if (DynamicFPSMod.getWindow() != null) {
            IdleHandler.setWindow(DynamicFPSMod.getWindow().address());
        }
        Platform.getInstance().registerStartTickEvent(IdleHandler::checkActivity);
    }

    public static void setWindow(long address) {
        if (active) {
            previousKeyCallback = GLFW.glfwSetKeyCallback((long)address, IdleHandler::onKey);
            previousScrollCallback = GLFW.glfwSetScrollCallback((long)address, IdleHandler::onScroll);
            previousCursorPosCallback = GLFW.glfwSetCursorPosCallback((long)address, IdleHandler::onMove);
            previousMouseClickCallback = GLFW.glfwSetMouseButtonCallback((long)address, IdleHandler::onPress);
        }
    }

    public static void onActivity() {
        previousActivity = class_156.method_659();
    }

    public static boolean isIdle() {
        DynamicFPSConfig config = DynamicFPSConfig.INSTANCE;
        if (config.idle().timeout() == 0) {
            return false;
        }
        if (config.idle().condition() == IdleCondition.ON_BATTERY && BatteryTracker.status() != State.DISCHARGING) {
            return false;
        }
        return class_156.method_659() - previousActivity >= (long)config.idle().timeout() * 1000L;
    }

    private static void checkActivity() {
        IdleHandler.checkPlayerActivity();
        boolean idle = IdleHandler.isIdle();
        if (idle != wasIdle) {
            wasIdle = idle;
            DynamicFPSMod.onStatusChanged(!idle);
        }
    }

    private static void checkPlayerActivity() {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        class_243 position = player.method_19538();
        class_243 lookAngle = player.method_5720();
        if (!position.equals((Object)prevPosition) || !lookAngle.equals((Object)prevLookAngle)) {
            IdleHandler.onActivity();
        }
        prevPosition = position;
        prevLookAngle = lookAngle;
    }

    private static void onKey(long address, int key, int scancode, int action, int mods) {
        IdleHandler.onActivity();
        if (previousKeyCallback != null) {
            previousKeyCallback.invoke(address, key, scancode, action, mods);
        }
    }

    private static void onScroll(long address, double xOffset, double yOffset) {
        IdleHandler.onActivity();
        if (previousScrollCallback != null) {
            previousScrollCallback.invoke(address, xOffset, yOffset);
        }
    }

    private static void onMove(long address, double x, double y) {
        IdleHandler.onActivity();
        if (previousCursorPosCallback != null) {
            previousCursorPosCallback.invoke(address, x, y);
        }
    }

    private static void onPress(long address, int button, int action, int mods) {
        IdleHandler.onActivity();
        if (previousMouseClickCallback != null) {
            previousMouseClickCallback.invoke(address, button, action, mods);
        }
    }
}

